<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ManufacturerCenter;

class Price extends \Google\Model
{
  /**
   * The numeric value of the price.
   *
   * @var string
   */
  public $amount;
  /**
   * The currency in which the price is denoted.
   *
   * @var string
   */
  public $currency;

  /**
   * The numeric value of the price.
   *
   * @param string $amount
   */
  public function setAmount($amount)
  {
    $this->amount = $amount;
  }
  /**
   * @return string
   */
  public function getAmount()
  {
    return $this->amount;
  }
  /**
   * The currency in which the price is denoted.
   *
   * @param string $currency
   */
  public function setCurrency($currency)
  {
    $this->currency = $currency;
  }
  /**
   * @return string
   */
  public function getCurrency()
  {
    return $this->currency;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Price::class, 'Google_Service_ManufacturerCenter_Price');
