<?php $__env->startSection('dashboardContent'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($title ?? ''); ?></h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('administrator/dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active"><?php echo e($breadcumbs ?? 'No title'); ?></li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> <?php echo $__env->make('messages.flash_messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"> <a href="<?php echo e(url('administrator/game/add')); ?>" class="btn btn-dark"> <i
                                    class="fa fa-plus" aria-hidden="true"></i> Add</a>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                                        <thead>
                                            <tr>
                                                <th>ID</th>
                                                <th>Status</th>
                                                <th>Image</th>
                                                <th>Name</th>
                                                <th>Category Name</th>
                                                <th>Slot</th>
                                                <th>Play Day</th>
                                                <th>Minimum Coin</th>

                                                <th>Action</th>
                                            </tr>
                                        </thead>
                                        <tbody>

                                            <?php $i=1;?>
                                            <?php $__currentLoopData = $game_type_list['records']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <td><?php echo e($i); ?></td>
                                                <td><?php if($row->status==1): ?><span
                                                        class="label label-success">Active</span><?php else: ?><span
                                                        class="label label-danger">In-active</span><?php endif; ?></td>
                                                <td><img src="<?php echo e(Helpers::category_image($row->image) ?? ''); ?>"
                                                        width="50px" alt="Avatar"></td>
                                                <td><?php echo e($row->name); ?></td>
                                                <td><?php echo e($row->category); ?></td>
                                                <td><?php echo e($row->from_time); ?> - <?php echo e($row->to_time); ?></td>
                                                <td><?php echo e($row->day); ?></td>
                                                <td><?php echo e($row->min_bid_amount); ?></td>
                                                <td><a href="<?php echo e(url('administrator/game/edit/'.$row->id)); ?>"
                                                        class="btn btn-sm btn-primary" data-toggle="tooltip"
                                                        title="Edit"><i class="fas fa-edit"></i></a> <a
                                                        href="javascript:;" class="btn btn-danger btn-sm delete-icon"
                                                        data-id="<?php echo e($row->id); ?>" data-toggle="tooltip" title="Remove"><i
                                                            class=" fa fa-trash"></i></a></td>
                                            </tr>
                                            <?php $i++;?>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>

                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
    </section>
</div>
<div style="display:none;">
    <?php echo e(Form::open(['route'=>['csv.save'],'class'=>'form-csv-upload', 'id' => 'form-csv-upload','files'=>true])); ?>

    <input name="upload_csv" id="upload_csv" style="display:none" onchange="preview_csv(this.files)" type="file"
        accept=".xlsx, .xls, .csv">
    </form>
</div>
<div id="dialog-csv-confirm" title="Confirmation" style="display: none;">
    <p>Are you sure you want to import csv?</p>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
    <p>Are you sure you want to delete this game?</p>
</div>
<div id="dialog-alert" title="Alert" style="display: none;">
    <p>Please select only csv files</p>
</div>
<?php $__env->startPush('stylesheet'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
$(function() {
    $('#example1').dataTable({
        "ordering": false,
        "scrollY": "678px",
        "scrollCollapse": true,
        "scrollX": true,
        "stripeClasses": ['strip1'],
        "language": {
            "lengthMenu": "_MENU_ records"
        },
        "initComplete": function(settings, json) {}
    });
});



$(document).on('click', '.csv_upload_btn', function(e) {
    $('#upload_csv').click();
});

function preview_csv(files) {
    $("#dialog-csv-confirm").dialog({
        resizable: false,
        height: 200,
        width: 'auto',
        modal: true,
        buttons: {
            "Yes": function() {
                $(this).dialog("close");
                $("#form-csv-upload").submit()
            },
            No: function() {
                $("#form-csv-upload")[0].reset();
                $(this).dialog("close");
            }
        }
    });

}



$(function() {
    $(document).on('click', '.delete-icon', function() {
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
                    location.href = "<?=url('/administrator/game/delete?id=')?>" + id;

                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
})
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.adminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ff4k/public_html/resources/views/admin/game/index.blade.php ENDPATH**/ ?>