<?php $__env->startSection('dashboardContent'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($title ?? ''); ?></h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('administrator/dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('administrator/slider')); ?>">Slider</a></li>
                        <li class="breadcrumb-item active"><?php echo e($breadcumbs ?? 'No title'); ?></li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> <?php echo $__env->make('messages.flash_messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="card card-default">
                <?php echo e(Form::open(['route'=>['slider.save'],'name'=>'slider','id' =>'slider-form','files'=>true])); ?>

                <input type="hidden" name="slider_id" value="<?php echo e($data->id ?? ''); ?>" />
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="label">Title</label>
                                <input type="text" class="form-control" id="title" name="title"
                                    placeholder="Enter Title" value="<?php echo e($data->title ?? ''); ?>">
                            </div>
                            <!-- <div class="form-group">
                <label for="label">Title 2</label>
                <input type="text" class="form-control" id="title2" name="title2" placeholder="Enter Title 2" value="<?php echo e($data->title2 ?? ''); ?>">
              </div>
              <div class="form-group">
                <label for="label">Title 3</label>
                <input type="text" class="form-control" id="title3" name="title3" placeholder="Enter Title 3" value="<?php echo e($data->title3 ?? ''); ?>">
              </div>
              <div class="form-group">
                <label for="label">Description</label>
                <input type="text" class="form-control" id="desc" name="desc" placeholder="Description" value="<?php echo e($data->desc ?? ''); ?>">
              </div> -->
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option value="">--Select Status--</option>
                                    <option value="1" <?php if(isset($data->status)){if($data->status==1){ echo
                                        'selected="selected"';}} ?>> Active </option>
                                    <option value="0" <?php if(isset($data->status)){if($data->status==0){ echo
                                        'selected="selected"';}} ?> echo> InActive </option>
                                </select>
                            </div>
                        </div>

                        <!-- /.col -->
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category">Slider Image</label>
                                <div class="col-auto"> <a href="javascript:;" class="preview fetch_image"
                                        id="thumb-image"><img src="<?php echo e($thumb ??  ''); ?>" alt="<?php echo e($thumb ?? ''); ?>"
                                            width="150px"></a>
                                    <input type="hidden" name="image" value="<?php echo e($data->image ?? ''); ?>" id="input-image">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                <?php echo e(Form::close()); ?>

            </div>
        </div>
    </section>
</div>
<div style="display:none;">
    <?php echo e(Form::open(['route'=>['image.save'],'class'=>'form-image-upload', 'id' => 'form-image-upload','files'=>true])); ?>

    <input name="upload_photo" id="upload_photo" style="display:none" onchange="preview_image(this.files)" type="file">
    </form>
</div>
<?php $__env->startPush('stylesheet'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
$(document).on('click', '.fetch_image', function(e) {
    $('#upload_photo').click();
});

function preview_image(files) {

    input = document.getElementById('upload_photo');
    var files = !!input.files ? input.files : [];
    if (!files.length || !window.FileReader) return;
    if (/^image/.test(files[0].type)) {
        var reader = new FileReader(); // instance of the FileReader
        reader.readAsDataURL(files[0]); // read the local file
        reader.onloadend = function() { // set image data as background of div
            $("#form-image-upload").submit()
            //$("#view_image_"+index).attr("src",this.result);  
            //$("#thumb-image").find('img').attr('src', this.result).css("height", "150px").css("height", "150px");;
        }
    }
}

$(document).ready(function() {
    $('#form-image-upload').submit(function(evt) {
        evt.preventDefault();
        var formData = new FormData(this);
        if ($('input[name=\'upload_photo\']').val() != '') {
            var upload_photo_id = $('#upload_photo_id').val();
            $.ajax({
                type: 'POST',
                url: $(this).attr('action'),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                dataType: "json",
                beforeSend: function() {
                    $('.loader-bg').fadeIn();
                },
                complete: function() {
                    $('.loader-bg').fadeOut();
                    $('#form-image-upload')[0].reset();
                },
                success: function(json) {
                    ;
                    if (json[0].success == 1) {
                        $("#thumb-image").find('img').attr('src', json[0].image_path);
                        $("#input-image").val(json[0].file_name);
                        //$('#button-clear').show();
                    } else {
                        alert(json[0].error_message);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }
    });
});

$(function() {
    $("#slider-form").validate({
        errorElement: "span",
        rules: {
            title: "required",
            status: "required"
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.adminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ff2co/public_html/admin-login.ff2.co.in/resources/views/admin/slider/form.blade.php ENDPATH**/ ?>