@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.tableMd small.label.bg-red {
    padding: 0.2rem 0.5rem;
    border-radius: 0.2rem;
}
.dark-mode .bg-red, .dark-mode .bg-red>a {
    color: #fff!important;
}
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">@include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="fromdate" class="form-control form-control-sm datetimepicker-input" value="{{ $fromdate }}" data-target="#reservationdate" required="required"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <!--<div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>To Date:</label>
                      <div class="input-group date" id="reservationdate2" data-target-input="nearest">
                        <input type="text" name="todate" class="form-control form-control-sm datetimepicker-input" value="{{ $todate ?? '' }}" data-target="#reservationdate" required="required"/>
                        <div class="input-group-append" data-target="#reservationdate2" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>-->
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Total Amount: Rs.{{$totalAmount}}</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table tableMd table-bordered table-striped text-nowrap">
                  <thead>
                    <tr>
                      <th>S.n</th>
                      <th>Name</th>
                      <th>Mobile No</th>
                      <th>Amount</th>
                      <th>Othersvid</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @php $i=1; @endphp
                  @foreach($withdraw_request_list['records'] as $row)
                  <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $row->customer_name }}</td>
                    <td>{{ $row->customer_phone }}</td>
                    <td><i class="fa fa-inr"></i> {{ $row->amount }}</td>
                    <td>{{ $row->payment_method }}</td>
                    <td>{{ \Carbon\Carbon::parse($row->created_at)->format('M d Y h:i a') }}</td>
                  </tr>
                  @php $i++; @endphp
                  @endforeach
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Accept?</p>
</div>
<div id="dialog-confirm2" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Reject?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script> 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 

<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask --> 
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script> 
<script>
//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});
$('#reservationdate2').datetimepicker({
	format: 'YYYY-MM-DD'
});


/*$(function () {
    $('#example1').DataTable()
})*/

</script> 
@endpush
@endsection 