@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ $title ?? '' }}</h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{url('administrator/slot')}}">Slot</a></li>
                        <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> @include('messages.flash_messages')
            <div class="card card-default">
                {{Form::open(['route'=>['slot.save'],'name'=>'slot','id' =>'slot-form','files'=>true])}}
                <input type="hidden" name="slot_id" value="{{$data->id ?? ''}}" />
                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Category</label>
                                <select class="form-control" name="category_id" id="category_id">
                                    <option value="">--Select Category--</option>
                                    @foreach($category_list as $row)
                                    <option value="{{ $row->id }}" @php if(isset($data->
                                        category_id)){if($row->id==$data->category_id){ echo 'selected="selected"';}}
                                        @endphp> {{ $row->label }} </option>
                                    @endforeach
                                </select>
                            </div>
                            <div class="form-group">
                                <div class="bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>Start Time:</label>
                                        <div class="input-group date" id="timepicker" data-target-input="nearest">
                                            <input type="text" id="start_time" name="start_time"
                                                class="form-control datetimepicker-input" data-target="#timepicker"
                                                placeholder="Enter Start Time" value="{{$data->from_time ?? ''}}" />
                                            <div class="input-group-append" data-target="#timepicker"
                                                data-toggle="datetimepicker">
                                                <div class="input-group-text"><i class="far fa-clock"></i></div>
                                            </div>
                                        </div>
                                        <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                </div>
                            </div>
                            <div class="form-group">
                                <div class="bootstrap-timepicker">
                                    <div class="form-group">
                                        <label>End Time:</label>
                                        <div class="input-group date" id="timepicker2" data-target-input="nearest">
                                            <input type="text" id="end_time" name="end_time"
                                                class="form-control datetimepicker-input" data-target="#timepicker2"
                                                placeholder="Enter End Time" value="{{$data->to_time ?? ''}}" />
                                            <div class="input-group-append" data-target="#timepicker2"
                                                data-toggle="datetimepicker">
                                                <div class="input-group-text"><i class="far fa-clock"></i></div>
                                            </div>
                                        </div>
                                        <!-- /.input group -->
                                    </div>
                                    <!-- /.form group -->
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="status">Status</label>
                                <select class="form-control" name="status" id="status">
                                    <option value="">--Select Status--</option>
                                    <option value="1" @php if(isset($data->status)){if($data->status==1){ echo
                                        'selected="selected"';}} @endphp> Active </option>
                                    <option value="0" @php if(isset($data->status)){if($data->status==0){ echo
                                        'selected="selected"';}} @endphp echo> InActive </option>
                                </select>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                {{Form::close()}}
            </div>
        </div>
    </section>
</div>
@push('stylesheet')

@endpush
@push('scripts')

<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet"
    href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask -->
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script>
<!-- Tempusdominus Bootstrap 4 -->
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}">
</script>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
//Timepicker
$('#timepicker').datetimepicker({
    format: 'LT'
});
$('#timepicker2').datetimepicker({
    format: 'LT'
});


$(function() {
    $("#slot-form").validate({
        errorElement: "span",
        rules: {
            //label: "required",
            category: "required",
            status: "required"
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});
</script>
@endpush
@endsection