@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.ui-dialog {
    z-index: 9999 !important;
}
.flot-right-btn{
	float:right;	
}
.result-CP{
	display:none;
}

</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }} <a href="{{ url('administrator/prev_result/') }}/{{$category_id}}" class="btn btn-warning"> <i class="fa fa-plus" aria-hidden="true"></i> Previous 10 Result</a></h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12"> @foreach($result as $row)
          <div class="card">
            <div class="card-body">
              <div class="widget-content widget-content-area br-6">
                <h4> {{$row['cat_name']}} Play Result - {{$row['date']}}</h4>
                <div class="table-responsive mb-4 mt-4">
                  <table id="" class="table table-hover non-hover text-nowrap forBtn" style="width:100%">
                    <thead>
                      <tr> @php $i=1;@endphp
                        @foreach($row['time_slot'] as $time_slot_row)
                        <th style="color: #fff;">Time{{$i}}({{$time_slot_row['from_time']}})</th>
                        @php $i++;@endphp
                        @endforeach </tr>
                    </thead>
                    <tbody>
                      <tr> 
                      @php $i=1;@endphp
                      @foreach($row['time_slot'] as $time_slot_row)
                        @php
                        $btn='btn-success add_result';
                        if($time_slot_row['status']=='Y'){
                        $btn='btn-danger edit_result';
                        }
                        $is_disabled_btn='';
                        if($time_slot_row['next_result_btn_status']=='N'){
                        	//$is_disabled_btn='disabled="disabled"';
                        }
                        @endphp
                        <td> @if($time_slot_row['game_type_id']!='')
                          <button class="btn {{$btn}} mb-2" data-time_id="{{$i}}" data-slot_id="{{$row['id']}}" data-game_id="{{$time_slot_row['game_type_id']}}" data-time_slot_id="{{$time_slot_row['id']}}" data-published_on="{{$row['date']}}" data-id="{{$i}}" {{$is_disabled_btn}}>Manage Result</button>
                          @foreach($time_slot_row['play_result'] as $play_type_row)
                          <input type="hidden" class="pay_type-{{$row['id']}}-{{$time_slot_row['id']}}" data-type_id="{{$play_type_row['type_id']}}" data-period_id="{{$play_type_row['period_id']}}" data-win_number="{{$play_type_row['win_number']}}" data-type_name="{{$play_type_row['type_name']}}" />
                          @endforeach
                          
                          @else
                          
                          <p class="text-warning">NO GAME</p>
                          @endif </td>
                        @php $i++;@endphp
                        @endforeach </tr>
                    </tbody>
                  </table>
                </div>
              </div>
            </div>
          </div>
          <div class="card">
            <div class="card-body">
              <div class="widget-content widget-content-area br-6">
                <h4> {{$row['cat_name']}} {{$row['type_title']}} Result - {{$row['date']}}</h4>
                <div class="table-responsive mb-4 mt-4">
                  <table id="" class="table table-hover non-hover text-nowrap" style="width:100%">
                    <thead>
                      <tr> @php $i=1;@endphp
                        @foreach($row['time_slot'] as $time_slot_row)
                        <th>Time{{$i}}({{$time_slot_row['from_time']}})</th>
                        @php $i++;@endphp
                        @endforeach </tr>
                    </thead>
                    <tbody>
                    
                    @foreach($row['slot_result'] as $slot_row)
                    <tr class="result-{{$slot_row['type_name']}}"> @foreach($slot_row['slotWiseResult'] as $rrow)
                      <td > @if($rrow['status']=='Y')
                        <button class="btn btn-info mb-2">{{ $rrow['win_number'] }}</button>
                        @endif </td>
                      @endforeach </tr>
                    @endforeach
                      </tbody>
                    
                  </table>
                </div>
              </div>
            </div>
          </div>
          @endforeach </div>
      </div>
    </div>
  </section>
</div>
<div class="example-modal">
  <div class="modal" id="set_result_modal">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h4 class="modal-title" id="modal-title">Set Win Number </h4>
          <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span aria-hidden="true">×</span></button>
        </div>
        {!! Form::open(['url'=>'administrator/result/save', 'class'=>'result-form', 'id' =>'result-form', 'autocomplete' => 'off']) !!}
        <input type="hidden" id="game_id" name="game_id" value="">
        <input type="hidden" id="date_slot" name="date_slot" value="">
         <input type="hidden" id="time_id" name="time_id" value="">
        <input type="hidden" id="time_slot_id" name="time_slot_id" value="">
        <input type="hidden" name="category_id" value="{{$category_id}}">
        <div class="modal-body"> @foreach($type_list as $row)
          @if($row->id==1)
          <div class="form-group" id="win_number-sec-{{$row->id}}">
            <label for="" class="control-label">{{$row->name}} Win Number:</label>
            <input type="number" name="win_number[]" id="win_number-{{$row->id}}" class="form-control" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==1) return false;"/>
            <input type="hidden" name="type_id[]" value="{{$row->id}}">
            <input type="hidden" id="type_period_id-{{$row->id}}" name="period_id[]">
          </div>
          @elseif($row->id==2)
          <div class="form-group" id="win_number-sec-{{$row->id}}">
            <label for="" class="control-label">{{$row->name}} Win Number:</label>
            <input type="number" name="win_number[]" id="win_number-{{$row->id}}" class="form-control" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==3) return false;"/>
            <input type="hidden" name="type_id[]" value="{{$row->id}}">
            <input type="hidden" id="type_period_id-{{$row->id}}" name="period_id[]">
          </div>
          @elseif($row->id==3)
          <div class="form-group" id="win_number-sec-{{$row->id}}">
            <label for="" class="control-label">{{$row->name}} Win Number:</label>
            <input type="number" name="win_number[]" id="win_number-{{$row->id}}" class="form-control" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==2) return false;"/>
            <input type="hidden" name="type_id[]" value="{{$row->id}}">
            <input type="hidden" id="type_period_id-{{$row->id}}" name="period_id[]">
          </div>
          @elseif($row->id==4)
          <div class="form-group" id="win_number-sec-{{$row->id}}">
            <label for="" class="control-label">{{$row->name}} Win Number:</label>
            <input type="number" name="win_number[]" id="win_number-{{$row->id}}" class="form-control" pattern="/^-?\d+\.?\d*$/" onKeyPress="if(this.value.length==3) return false;"/>
            <input type="hidden" name="type_id[]" value="{{$row->id}}">
            <input type="hidden" id="type_period_id-{{$row->id}}" name="period_id[]">
          </div>
          @endif
          
          @endforeach </div>
        <div class="modal-footer justify-content-between">
          <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
          <button type="button" class="btn btn-primary btn-save" >Save changes</button>
        </div>
        </form>
      </div>
    </div>
  </div>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to save this win number?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script> 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 
<script>
$(document).on('click','.add_result,.edit_result',function(){
	var time_id			= $(this).data('time_id');
	var slot_id			= $(this).data('slot_id');
	var game_id			= $(this).data('game_id');
	var time_slot_id	= $(this).data('time_slot_id');
	var published_on	= $(this).data('published_on');
	var id				= $(this).data('id');
	
	console.log(id);
	
	if(id==1){
		$('#win_number-sec-3').hide();
	}else{
		$('#win_number-sec-3').show();
	}
	
	
	
	$('#time_id').val(time_id);
	$('#game_id').val(game_id);
	$('#date_slot').val(published_on);
	$('#time_slot_id').val(time_slot_id);
	
	var ek=[];
	$('.pay_type-'+slot_id+'-'+time_slot_id).each(function() {
		var type_id		= $(this).data('type_id');
		var period_id	= $(this).data('period_id');
		var win_number	= $(this).data('win_number');
		$('#win_number-'+type_id).val(win_number);
		$('#type_period_id-'+type_id).val(period_id);
		ek.push(period_id);
	});
	console.log(ek);
	
	console.log(slot_id);
	console.log(time_slot_id);
	$('#set_result_modal').modal('show');
});

$(function() {
	$('#win_number-sec-4').hide();
	$(document).on('keyup','#win_number-2',function(){
		$('#win_number-4').val($(this).val());
	});
});

$(function() {
	$(document).on('click','.btn-save',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					$("#result-form").submit();
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
});

/*rules: {
			single_win_number: {
				number:true,
                required: true,
                maxlength: 1
            },
			patti_win_number: {
				number:true,
                required: true,
				minlength: 3,
                maxlength: 3
            },
        },*/

$(function() {
    $("#result-form").validate({
        errorElement: "span",
        rules: {
            "win_number[]": "required",
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});

</script> 
@endpush
@endsection 