@extends('layouts.admin.adminLayout')
@section('dashboardContent') 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label for="">Category</label>
                      <select class="selectOption" name="cat_id" id="category_id">
                        <option value="">Choose..</option>
                        
                        
                        
                        
                      
                      @foreach($category_list as $row)
                      
                        
                        
                        
                        <option value="{{ $row->id }}" @php if(isset($_GET['cat_id'])){if($row->id==$_GET['cat_id']){ echo 'selected="selected"';}} @endphp> {{ $row->label }} </option>
                        
                        
                        
                        
                      @endforeach
                    
                    
                      
                      
                      
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="date" class="form-control form-control-sm datetimepicker-input" value="{{ $current_date }}" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label for="">Time Slot</label>
                      <select class="selectOption" name="slot_id" id="time_slot_id">
                        <option value="">Choose..</option>
                        
                        
                        
                        
                      @foreach($time_slots as $row)
                        
                        
                        
                        <option value="{{ $row->id }}" @php if(isset($_GET['slot_id'])){if($row->id==$_GET['slot_id']){ echo 'selected="selected"';}} @endphp> {{ $row->from_time }} - {{ $row->to_time }} </option>
                        
                        
                        
                        @endforeach
                    
                      
                      
                      
                      </select>
                    </div>
                  </div>
                  <!--<div class="col-lg-3 col-md-3 col-sm-6 col-12">
                  <div class="form-group">
                    <label for="">Type</label>
                    <select class="selectOption" name="type_id" id="type_id">
                      <option value="">Choose..</option>
                      
                      @foreach($type_list as $row)
                      <option value="{{ $row->id }}" @php if(isset($_GET['type_id'])){if($row->id==$_GET['type_id']){ echo 'selected="selected"';}} @endphp> {{ $row->name }}</option>
                      @endforeach
                    
                    </select>
                  </div>
                </div>-->
                  
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Single</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                  <thead>
                    <tr>
                      <th>Bid Number</th>
                      <th>Total Bid</th>
                      <th>Amount (₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @foreach($result['singleBidResult'] as $row)
                  <tr>
                    <td>{{ $row['digit'] }}</td>
                    <td>{{ $row['totalBid'] }}</td>
                    <td>{{ $row['amount'] }}</td>
                  </tr>
                  @endforeach
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total:</td>
                    <td>{{$result['totalSingleAmount']}}</td>
                  </tr>
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total Win:</td>
                    <td>{{$result['totalSingleWinAmount']}}</td>
                  </tr>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Patti</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                  <thead>
                    <tr>
                      <th>Bid Number</th>
                      <th>Total Bid</th>
                      <th>Amount (₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @foreach($result['pattiBidResult'] as $row)
                  <tr>
                    <td>{{ $row['digit'] }}</td>
                    <td>{{ $row['totalBid'] }}</td>
                    <td>{{ $row['amount'] }}</td>
                  </tr>
                  @endforeach
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total:</td>
                    <td>{{$result['totalPattiAmount']}}</td>
                  </tr>
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total Win:</td>
                    <td>{{$result['totalPattiWinAmount']}}</td>
                  </tr>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Jodi</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                  <thead>
                    <tr>
                      <th>Bid Number</th>
                      <th>Total Bid</th>
                      <th>Amount (₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @foreach($result['jodiBidResult'] as $row)
                  <tr>
                    <td>{{ $row['digit'] }}</td>
                    <td>{{ $row['totalBid'] }}</td>
                    <td>{{ $row['amount'] }}</td>
                  </tr>
                  @endforeach
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total:</td>
                    <td>{{$result['totalJodiAmount']}}</td>
                  </tr>
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total Win:</td>
                    <td>{{$result['totalJodiWinAmount']}}</td>
                  </tr>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">CP</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                  <thead>
                    <tr>
                      <th>Bid Number</th>
                      <th>Total Bid</th>
                      <th>Amount (₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @foreach($result['cpBidResult'] as $row)
                  <tr>
                    <td>{{ $row['digit'] }}</td>
                    <td>{{ $row['totalBid'] }}</td>
                    <td>{{ $row['amount'] }}</td>
                  </tr>
                  @endforeach
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total:</td>
                    <td>{{$result['totalCpAmount']}}</td>
                  </tr>
                  <tr>
                    <td colspan="2" align="center" style="color:#F00">Total Win:</td>
                    <td>{{$result['totalCpWinAmount']}}</td>
                  </tr>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask --> 
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script> 
<script>
$(function () {
	//$('#example1').DataTable();
});

//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});

$('#category_id').change(function(e) {
    var category_id = $(this).val();
    if (category_id != '') {
        $.ajax({
            url: prop.ajaxurl,
            type: 'post',
            data: {
                category_id: category_id,
                action: 'get_slot',
                _token: prop.csrf_token
            },
            beforeSend: function() {},
            success: function(response) {
                $('#time_slot_id').html(response);
            }
        });
    }
});
</script> 
@endpush
@endsection 