@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.tableMd small.label.bg-success{
    padding: .2rem .5rem;
    border-radius: .2rem;
}
.tableMd small.label.bg-danger{
    padding: .2rem .5rem;
    border-radius: .2rem;
}
 
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label for="">Category</label>
                      <select class="selectOption" name="cat_id" id="category_id" required="required">
                        <option value="">Choose..</option>
                        
                        
                        
                        
                        
                        
                        
                        
                        
                      
                      @foreach($category_list as $row)
                      
                        
                        
                        
                        
                        
                        
                        
                        
                        <option value="{{ $row->id }}" @php if(isset($_GET['cat_id'])){if($row->id==$_GET['cat_id']){ echo 'selected="selected"';}} @endphp> {{ $row->label }} </option>
                        
                        
                        
                        
                        
                        
                        
                        
                        
                      @endforeach
                    
                    
                      
                      
                      
                      
                      
                      
                      
                      
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-2 col-md-2 col-sm-6 col-12">
                    <div class="form-group">
                      <label>From Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="fromdate" class="form-control form-control-sm datetimepicker-input" value="{{ $fromdate }}" data-target="#reservationdate" required="required"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-md-2 col-sm-6 col-12">
                    <div class="form-group">
                      <label>To Date:</label>
                      <div class="input-group date" id="reservationdate2" data-target-input="nearest">
                        <input type="text" name="todate" class="form-control form-control-sm datetimepicker-input" value="{{ $todate ?? '' }}" data-target="#reservationdate" required="required"/>
                        <div class="input-group-append" data-target="#reservationdate2" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Total Amount: Rs.{{$result['total_bit_amount']}}</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped tableMd dataTable no-footer">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <th>DATE</th>
                      <th>SINGLE</th>
                      <th>TOTAL SINGLE(₹)</th>
                      <th>TOTAL WIN SINGLE(₹)</th>
                      <th>PATTI</th>
                      <th>TOTAL PATTI(₹)</th>
                       <th>TOTAL WIN PATTI(₹)</th>
                      <th>JODI</th>
                      <th>TOTAL JODI(₹)</th>
                      <th>TOTAL WIN JODI(₹)</th>
                      <th>CP</th>
                      <th>TOTAL CP(₹)</th>
                      <th>TOTAL WIN CP(₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @php $i=1;@endphp
                  @foreach($result['record'] as $row)
                  <tr>
                    <td>{{ $i }}</td>
                    <td>{{ $row['date_slot'] }}</td>
                    <td>{{ $row['single_win_digit'] }}</td>
                    <td>Rs.{{ $row['single_win_amount'] }}</td>
                    <td>Rs.{{ $row['single_total_win_amount'] }}</td>
                    <td>{{ $row['patti_win_digit'] }}</td>
                    <td>Rs.{{ $row['patti_win_amount'] }}</td>
                    <td>Rs.{{ $row['patti_total_win_amount'] }}</td>
                    <td>{{ $row['jodi_win_digit'] }}</td>
                    <td>Rs.{{ $row['jodi_win_amount'] }}</td>
                    <td>Rs.{{ $row['jodi_total_win_amount'] }}</td>
                    <td>{{ $row['cp_win_digit'] }}</td>
                    <td>Rs.{{ $row['cp_win_amount'] }}</td>
                    <td>Rs.{{ $row['cp_total_win_amount'] }}</td>
                  </tr>
                  @php $i++;@endphp
                  @endforeach
                  <tr>
                    <td></td>
                    <td>Total:</td>
                    <td></td>
                    <td>Rs.{{$result['total_single_win_amount']}}</td>
                    <td></td>
                    <td>Rs.{{$result['total_patti_win_amount']}}</td>
                    <td></td>
                    <td>Rs.{{$result['total_jodi_win_amount']}}</td>
                    <td></td>
                    <td>Rs.{{$result['total_cp_win_amount']}}</td>
                  </tr>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask --> 
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script> 
<script>
$(function () {
	//$('#example1').DataTable();
});

$(function() {
    $('#example1').dataTable({
		"paging":   false,
        "info":     false,
        "ordering": false,
        "scrollY": "678px",
        "scrollCollapse": true,
        "scrollX": true,
        "stripeClasses": ['strip1'],
        "language": {
            "lengthMenu": "_MENU_ records"
        },
        "initComplete": function(settings, json) {}
    });
});

//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});
$('#reservationdate2').datetimepicker({
	format: 'YYYY-MM-DD'
});

/*$('#category_id').change(function(e) {
    var category_id = $(this).val();
    if (category_id != '') {
        $.ajax({
            url: prop.ajaxurl,
            type: 'post',
            data: {
                category_id: category_id,
                action: 'get_slot',
                _token: prop.csrf_token
            },
            beforeSend: function() {},
            success: function(response) {
                $('#time_slot_id').html(response);
            }
        });
    }
});*/
</script> 
@endpush
@endsection 