@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.tableMd small.label.bg-success{
    padding: .2rem .5rem;
    border-radius: .2rem;
}
.tableMd small.label.bg-danger{
    padding: .2rem .5rem;
    border-radius: .2rem;
}
 
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="form-group">
                      <label for="">Category</label>
                      <select class="selectOption" name="cat_id" id="category_id">
                        <option value="">Choose..</option>
                        
                        
                        
                        
                        
                        
                        
                        
                      
                      @foreach($category_list as $row)
                      
                        
                        
                        
                        
                        
                        
                        
                        <option value="{{ $row->id }}" @php if(isset($_GET['cat_id'])){if($row->id==$_GET['cat_id']){ echo 'selected="selected"';}} @endphp> {{ $row->label }} </option>
                        
                        
                        
                        
                        
                        
                        
                        
                      @endforeach
                    
                    
                      
                      
                      
                      
                      
                      
                      
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-4 col-md-4 col-sm-6 col-12">
                    <div class="form-group">
                      <label>Mobile Number</label>
                      <div class="input-group">
                        <div class="input-group-prepend"> <span class="input-group-text"><i class="fas fa-phone"></i></span> </div>
                        <input type="tel" name="number" class="form-control form-control-sm" placeholder="Enter Mobile Number" value="@php if(isset($_GET['number'])){ echo $_GET['number']; } @endphp">
                      </div>
                      <!-- /.input group --> 
                    </div>
                  </div>
                  <div class="col-lg-2 col-md-2 col-sm-6 col-12">
                    <div class="form-group">
                      <label>From Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="date" class="form-control form-control-sm datetimepicker-input" value="{{ $current_date }}" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-2 col-md-2 col-sm-6 col-12">
                    <div class="form-group">
                      <label>To Date:</label>
                      <div class="input-group date" id="reservationdate2" data-target-input="nearest">
                        <input type="text" name="todate" class="form-control form-control-sm datetimepicker-input" value="{{ $todate }}" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate2" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped tableMd dataTable no-footer">
                  <thead>
                    <tr>
                      <th>ID</th>
                      <!--<th>GAME NAME</th>-->
                      <th>NAME</th>
                      <th>MOBILE NUMBER</th>
                      <th>DIGIT</th>
                      <th>AMOUNT (₹)</th>
                      <th>BALANCE</th>
                      <th>AFTER BALANCE</th>
                      <th>DATE</th>
                      <th>TIME</th>
                      <th>STATUS</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @php $i=1;@endphp
                  @foreach($result['records'] as $row)
                  @php
                  $userWalletInfo=App\User_wallet::where('user_id',$row->user_id)->first();
                  $walletBalance=isset($userWalletInfo->balance)?$userWalletInfo->balance:'0';
                  @endphp
                  <tr>
                    <td>{{ $i }}</td>
                    <!--<td>{{ $row->name }}</td>-->
                    <td>{{ $row->customer_name }}</td>
                    <td>{{ $row->phone }}</td>
                    <td>{{ $row->number }}</td>
                    <td>{{ $row->amount }}</td>
                    <td>Rs.{{ $row->available_bal }}</td>
                    <td>Rs.{{$walletBalance}}</td>
                    <td>{{ $row->date_slot }}</td>
                    <td>{{ $row->from_time }}</td>
                    <td>@if($row->win_status=='pending')<small class="label bg-yellow">Pending</small>@elseif($row->win_status=='win')<small class="label bg-success">Win</small>@else<small class="label bg-danger">Loss</small>@endif</td>
                  </tr>
                  @php $i++;@endphp
                  @endforeach
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask --> 
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script> 
<script>
$(function () {
	$('#example1').DataTable();
});
/*$(function() {
    $('#example1').dataTable({
        "ordering": false,
        "scrollY": "678px",
        "scrollCollapse": true,
        "scrollX": true,
        "stripeClasses": ['strip1'],
        "language": {
            "lengthMenu": "_MENU_ records"
        },
        "initComplete": function(settings, json) {}
    });
});*/

//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});
$('#reservationdate2').datetimepicker({
	format: 'YYYY-MM-DD'
});

</script> 
@endpush
@endsection 