@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ $title ?? '' }}</h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
                        <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> @include('messages.flash_messages')
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"> <a href="{{url('administrator/news/add')}}" class="btn btn-dark"> <i
                                    class="fa fa-plus" aria-hidden="true"></i> Add</a> </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>News</th>
                                            <th>Status</th>
                                            <th>Action</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        @php $i=1;@endphp
                                        @foreach($news_list['records'] as $row)
                                        <tr>
                                            <td>{{ $i }}</td>
                                            <td>{{ $row->name }}</td>
                                            <td>@if($row->status==1)<span
                                                    class="label label-success">Active</span>@else<span
                                                    class="label label-danger">In-active</span>@endif</td>
                                            <td><a href="{{url('administrator/news/edit/'.$row->id)}}"
                                                    class="btn btn-sm btn-primary" data-toggle="tooltip" title="Edit"><i
                                                        class="fas fa-edit"></i></a> <a href="javascript:;"
                                                    class="btn btn-danger btn-sm delete-icon" data-id="{{$row->id}}"
                                                    data-toggle="tooltip" title="Remove"><i
                                                        class=" fa fa-trash"></i></a></td>
                                        </tr>
                                        @php $i++;@endphp
                                        @endforeach
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
    <p>Are you sure you want to delete this news?</p>
</div>
@push('stylesheet')

@endpush
@push('scripts')
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
$(function() {
    $('#example1').DataTable()
});

$(function() {
    $(document).on('click', '.delete-icon', function() {
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
                    location.href = "<?=url('/administrator/news/delete?id=')?>" + id;

                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
})
</script>
@endpush
@endsection