@extends('layouts.admin.adminLayout')
@section('dashboardContent') 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{url('administrator/money/deduction')}}">Deduction List</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="alert alert-danger alert-dismissible" id="danger_Alert" style="display:none;">
      <button type="button" class="close" data-dismiss="alert" aria-hidden="true">×</button>
      <h5><i class="icon fas fa-ban"></i> Error!</h5>
      oops! Wrong Mobile Number. </div>
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="card card-default"> {{Form::open(['route'=>['deduction.save'],'name'=>'deduction','id' =>'deduction-form','files'=>true])}}
        <input type="hidden" name="slider_id" value="{{$data->id ?? ''}}" />
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label>Mobile No:</label>
                <div class="input-group">
                  <div class="input-group-prepend"> <span class="input-group-text"><i class="fas fa-phone"></i></span> </div>
                  <input type="tel" name="mobile" id="mobile" class="form-control" onkeyup="getCustomerDetails(this.value)" placeholder="Mobile No" />
                </div>
                <!-- /.input group --> 
              </div>
              <div class="form-group" id="customer_sec" style="display:none">
                <label>Customer Name:</label>
                <div class="input-group">
                  <div class="input-group-prepend"> <span class="input-group-text"><i class="fas fa-user"></i></span> </div>
                  <input type="text" name="customer_name" id="customer_name" class="form-control" readonly="readonly">
                  <input type="hidden" name="customer_id" id="customer_id" value="">
                </div>
                <!-- /.input group --> 
              </div>
              <div class="form-group" id="current_amount_sec" style="display:none">
                <label>Current Amount:</label>
                <div class="input-group">
                  <div class="input-group-prepend"> <span class="input-group-text"><i class="fas fa-rupee-sign"></i></span> </div>
                  <input type="text" name="current_amount" id="current_amount" class="form-control" readonly="readonly">
                </div>
                <!-- /.input group --> 
              </div>
              <div class="form-group" id="amount_sec" style="display:none">
                <label>Amount:</label>
                <div class="input-group">
                  <div class="input-group-prepend"> <span class="input-group-text"><i class="fas fa-rupee-sign"></i></span> </div>
                  <input type="text" name="amount" id="amount" class="form-control" placeholder="Enter Amount">
                </div>
                <!-- /.input group --> 
              </div>
            </div>
            
            <!-- /.col --> 
            
          </div>
        </div>
        <div class="card-footer" id="btn_sec" style="display:none">
          <button type="submit" class="btn btn-primary">Submit</button>
        </div>
        {{Form::close()}} </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 
<script>
$(document).ready(function() {
  $(window).keydown(function(event){
    if(event.keyCode == 13) {
      event.preventDefault();
      return false;
    }
  });
});
function getCustomerDetails(value) {
    if (value.length > 0) {
        if (value.length == 10) {
            $.ajax({
                url: prop.ajaxurl,
                type: "post",

                data: {
                    mobile: value,
                    action: 'get_account',
                    _token: prop.csrf_token
                },
                beforeSend: function() {},
                success: function(response) {
                    const obj_response = JSON.parse(response);
                    if (obj_response.status == '1') {
						$('#danger_Alert').hide();
                        $('#customer_sec').show();
                        $('#amount_sec').show();
						$('#current_amount_sec').show();
                        $('#btn_sec').show();
                        $('#customer_name').val(obj_response.customer_name);
                        $('#customer_id').val(obj_response.customer_id);
                        $('#current_amount').val(obj_response.current_amount);
                    } else {
                        $('#danger_Alert').show();
                    }
                },
                error: function(jqXHR, textStatus, errorThrown) {
                    console.log(textStatus, errorThrown);
                }
            });
        } else {
			$('#danger_Alert').hide();
            $('#customer_sec').hide();
			$('#current_amount_sec').hide();
            $('#amount_sec').hide();
            $('#btn_sec').hide();
        }
    }
}




$(function() {
    $("#deduction-form").validate({
        errorElement: "span",
        rules: {
            amount: {
                required: true,
                number: true,
                denominationCheck: 0
            }

        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});

</script> 
@endpush
@endsection 