@extends('layouts.admin.adminLayout')
@section('dashboardContent') 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label for="">Category</label>
                      <select class="selectOption" name="cat_id" id="category_id">
                        <option value="">Choose..</option>
                        
                        
                        
                        
                        
                      
                      @foreach($category_list as $row)
                      
                        
                        
                        
                        
                        <option value="{{ $row->id }}" @php if(isset($_GET['cat_id'])){if($row->id==$_GET['cat_id']){ echo 'selected="selected"';}} @endphp> {{ $row->label }} </option>
                        
                        
                        
                        
                        
                      @endforeach
                    
                    
                      
                      
                      
                      
                      </select>
                    </div>
                  </div>
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="date" class="form-control form-control-sm datetimepicker-input" value="{{ $fromdate }}" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">Game Report</h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                  <thead>
                    <tr>
                      <th>Category Name</th>
                      <th>Name</th>
                      <th>Slot</th>
                      <th>Total Play Amount (₹)</th>
                      <th>Total Win Amount (₹)</th>
                    </tr>
                  </thead>
                  <tbody>
                  @if(count($game_report_result))
                      @foreach($game_report_result as $row)
                      <tr>
                        <td>{{ $row['cat_name'] }}</td>
                        <td>{{ $row['name'] }}</td>
                        <td>{{ $row['time_slot'] }}</td>
                        <td>{{ $row['played_amount'] }}</td>
                        <td><strong>Total:-{{ $row['total_win_amount'] }} </strong></br>
                        	Single Win:-{{ $row['total_win_result']['single_total_win_amount'] }}</br>
                         	Patti Win:-{{ $row['total_win_result']['patti_total_win_amount'] }}</br>
                          	Jodi Win:-{{ $row['total_win_result']['jodi_total_win_amount'] }}</br>
                           	Cp Win:-{{ $row['total_win_result']['cp_total_win_amount'] }}</br>
                        
                        </td>
                      </tr>
                      @endforeach
                      <tr>
                        <td colspan="3" align="center" style="color:#F00">Total Play Amount (₹) :</td>
                        <td>{{$gross_total_played_amount ?? ''}}</td>
                      </tr>
                      <tr>
                        <td colspan="3" align="center" style="color:#F00">Total Win Amount (₹):</td>
                        <td>{{$gross_total_win_amount ?? ''}}</td>
                      </tr>
                       
                  @endif
                 </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css') }}">
<!-- InputMask --> 
<script src="{{ asset('public/front/plugins/moment/moment.min.js') }}"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="{{ asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js') }}"></script> 
<script>
//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});
</script> 
@endpush
@endsection 