@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.tableMd small.label.bg-red {
    padding: 0.2rem 0.5rem;
    border-radius: 0.2rem;
}
.dark-mode .bg-red, .dark-mode .bg-red>a {
    color: #fff!important;
}
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">@include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table tableMd table-bordered table-striped text-nowrap">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Action</th>
                      <th>Name</th>
                      <th>Amount</th>
                      <th>TXN</th>
                      {{-- <th>Banking Name</th> --}}
                      <th>Pay Mode</th>
                      <th>Status</th>
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  
                  @php $i=1; @endphp
                  @foreach($balance_request_list['records'] as $row)
                  <tr>
                    <td>{{ $i }}</td>
                    <td id="action_{{$row->id}}"><a href="javascript:;"
                      class="btn btn-info btn-xs status-icon info_btn"
                      data-toggle="tooltip" title="Payment History"
                      data-id="{{ $row->id }}" data-user_id="{{ $row->user_id }}"><i
                          class="fa fa-info-circle"></i> Info</a> @if($row->status=='pending') <a href="javascript:;" class="btn btn-success btn-xs status-icon accept_btn" data-toggle="tooltip" title="Accept" data-id="{{ $row->id }}"><i class="fa fa-check"></i>Accept</a> <a href="javascript:;" class="btn btn-danger btn-xs status-icon reject_btn" data-toggle="tooltip" title="Reject" data-id="{{ $row->id }}"><i class="fa fa-times"></i>Reject</a>@endif</td>
                 
                    <td><a href="{{ route('user.show', $row->user_id)}}" style="text-decoration: underline;">{{ $row->customer_name }}</a></td>
                    <td><i class="fa fa-inr"></i> {{ $row->amount }}</td>
                    <td>{{ $row->txn }}</td>
                    {{-- <td>{{ $row->bankName }}</td> --}}
                    <td style="text-transform: uppercase;">
                      @if($row->payment_method=='qr')
                      Scan
                      @else
                      {{$row->payment_method}}
                      @endif
                      </td>
                    <td id="status_{{$row->id}}">@if($row->status=='pending')<small class="label bg-yellow">Pending</small>@elseif($row->status=='rejected')<small class="label bg-red">Rejected</small>@else($row->status=='pending')<small class="label bg-green">Paid</small>@endif</td>
                    <td>{{ \Carbon\Carbon::parse($row->created_at)->format('M d Y h:i a') }}</td>
                    
                  </tr>
                  @php $i++; @endphp
                  @endforeach
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div class="example-modal">
  <div class="modal" id="transaction_history_modal">
      <div class="modal-dialog modal-lg">
          <div class="modal-content">
              <div class="modal-header">
                  <h4 class="modal-title" id="modal-title">Transaction history </h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span
                          aria-hidden="true">×</span></button>
              </div>
              <div class="modal-body">
                  <div class="col-md-12">
                      <div class="card">
                          <div class="card-header p-2">
                              <ul class="nav nav-pills">
                                  <li class="nav-item"><a class="nav-link active" href="#withdraw_sec"
                                          data-toggle="tab">Withdraw</a></li>
                                  <li class="nav-item"><a class="nav-link" href="#deposit_sec"
                                          data-toggle="tab">Deposit</a></li>
                                  <li class="nav-item"><a class="nav-link" href="#report_sec" data-toggle="tab">Report</a></li>
                              </ul>
                          </div>
                          
                          <div class="card-body">
                              <div class="tab-content">
                                  <div class="active tab-pane" id="withdraw_sec">
                                      <div class="col-md-12">
                                          <div class="box">
                                              <div class="box-header">
                                                  <h3 class="box-title">Last 10 Withdraw History</h3>
                                              </div>
                                              <!-- /.box-header -->
                                              <div class="box-body no-padding">
                                                  <table class="table table-striped">
                                                      <tr>
                                                          <th style="width: 10px">#</th>
                                                          <th>Amount</th>
                                                          <th>Transfer Mode</th>
                                                          <th>Date</th>
                                                      </tr>
                                                      <tbody id="withdraw_transaction_history_sec">
                                                          <tr>
                                                          </tr>
                                                      </tbody>
                                                      <!--<td><span class="badge bg-red">55%</span></td>
                      <td><span class="badge bg-yellow">70%</span></td>
                      <td><span class="badge bg-green">90%</span></td>-->

                                                  </table>
                                              </div>
                                              <!-- /.box-body -->
                                          </div>
                                          <!-- /.box -->
                                      </div>
                                  </div>
                                  <div class="tab-pane" id="deposit_sec">
                                      <div class="col-md-12">
                                          <div class="box">
                                              <div class="box-header">
                                                  <h3 class="box-title">Last 10 Deposit History</h3>
                                              </div>
                                              <!-- /.box-header -->
                                              <div class="box-body no-padding">
                                                  <table class="table table-striped">
                                                      <tr>
                                                          <th style="width: 10px">#</th>
                                                          <th>Amount</th>
                                                          <th>Transfer Mode</th>
                                                          <th>Date</th>
                                                      </tr>
                                                      <tbody id="deposit_transaction_history_sec">
                                                          <tr>
                                                          </tr>
                                                      </tbody>
                                                  </table>
                                              </div>
                                              <!-- /.box-body -->
                                          </div>
                                          <!-- /.box -->
                                      </div>
                                  </div>
                                  <div class="tab-pane" id="report_sec">
                                      <div class="col-md-12">
                                        <div class="box">
                                          <div class="box-header">
                                            <h3 class="box-title">Report</h3>
                                          </div>
                                          <!-- /.box-header -->
                                          <div class="box-body no-padding">
                                            <table class="table table-striped">
                                              <tr>
                                                <th>Total Withdraw</th>
                                                <th>Total Deposit</th>
                                                <th>Total Wallet</th>
                                                <th>Total Profit</th>
                                              </tr>
                                               <tbody id="transaction_report_sec">
                                              <tr> 
                                              </tr>
                                              </tbody>
                                            </table>
                                          </div>
                                          <!-- /.box-body --> 
                                        </div>
                                        <!-- /.box --> 
                                      </div>
                                    </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer justify-content-between">
                  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
          </div>
      </div>
  </div>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Accept?</p>
</div>
<div id="dialog-confirm2" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Reject?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script> 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 
<script>
$(function () {
    //$('#example1').DataTable()
	
	$('#example1').dataTable({"pageLength": 100});
  })
$(function() {
      $(document).on('click','.accept_btn',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					//location.href = "<?=url('/administrator/balance_request/accept?id=')?>" + id;
					
					$('#action_'+id).html('');
					$('#status_'+id).html('<small class="label bg-green">Paid</small>');
					
					
					$.ajax({
						type: 'GET',
						url: "<?=url('/administrator/balance_request/accept?id=')?>" + id,
						data: '',
						cache: false,
						contentType: false,
						processData: false,
						dataType: "json",
						beforeSend: function() {
							//$('.loader-bg').fadeIn();
						},
						complete: function() {
							//$('.loader-bg').fadeOut();
							
							
						},
						success: function(json) {
							
							
						},
						error: function(xhr, ajaxOptions, thrownError) {
							//$('.loader-bg').fadeOut();
							//alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
						}
					});
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
	  $(document).on('click','.reject_btn',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm2").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					//location.href = "<?=url('/administrator/balance_request/reject?id=')?>" + id;
					
					$('#action_'+id).html('');
					$('#status_'+id).html('<small class="label bg-red">Rejected</small>');
							
					$.ajax({
						type: 'GET',
						url: "<?=url('/administrator/balance_request/reject?id=')?>" + id,
						data: '',
						cache: false,
						contentType: false,
						processData: false,
						dataType: "json",
						beforeSend: function() {
							//$('.loader-bg').fadeIn();
						},
						complete: function() {
							//$('.loader-bg').fadeOut();
							
						},
						success: function(json) {
							
						},
						error: function(xhr, ajaxOptions, thrownError) {
							$('.loader-bg').fadeOut();
							//alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
						}
					});
                    
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
    $(document).on('click', '.info_btn', function() {
        var user_id = $(this).attr("data-user_id");
        $.ajax({
            url: prop.ajaxurl,
            type: "post",
            data: {
                user_id: user_id,
                action: 'get_transaction_history',
                _token: prop.csrf_token
            },
            beforeSend: function() {},
            success: function(response) {
                const obj_response = JSON.parse(response);
                $('#withdraw_transaction_history_sec').html(obj_response.withdraw_html);
                $('#deposit_transaction_history_sec').html(obj_response.deposite_html);
                $('#transaction_report_sec').html(obj_response.report_html);

                $('#transaction_history_modal').modal('show');
            },

            error: function(jqXHR, textStatus, errorThrown) {
                console.log(textStatus, errorThrown);
            }
        });
    });
}); 
</script> 
@endpush
@endsection 