<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB AS DB;

use Helpers;

class Win_period extends Model
{
    protected $table = 'win_period';
	protected $guarded=[];
	
	public static function get_data($param = array()) {
		$type 			= $param['type'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		/*$avality_date_slots	= DB::table('user_bit_transaction')->select('avality_time_date_slots.id','avality_time_date_slots.date')->leftJoin('avality_time_date_slots', 'avality_time_date_slots.id', 'user_bit_transaction.date_slot_id')->distinct('avality_time_date_slots.date')
		->orderBy('avality_time_date_slots.date', 'desc')
		->take(15)
		->get();*/
		
		$current_date=date('Y-m-d');
		
		
		$avality_date_slots	= DB::table('avality_time_date_slots')->where('date', '<=', $current_date)->orderBy('date', 'desc')->take(30)->get();
		
		$result=[];
		$time_slot_ids=[];
		$avality_time_slots	= DB::table('time_slots')->where('game_type_id',$type)->get();
		foreach($avality_time_slots as $row){
			$time_slot_ids[]=$row->id;
		}
		
		//print_r($time_slot_ids);exit;
		
		foreach($avality_date_slots as $row){
			
			$win_result=[];
			
			if(count($time_slot_ids)>0){
				for($i=0;count($time_slot_ids)>$i;$i++){
					$time_slot_id=$time_slot_ids[$i];
					$time_slot_info = DB::table('time_slots')->where('id',$time_slot_id)->first();
					$time_slot_from	= isset($time_slot_info->from_time)?$time_slot_info->from_time:'';
					$time_slot_to	= isset($time_slot_info->to_time)?$time_slot_info->to_time:'';

					$winSingleResultList = DB::table('win_period')->where('type_id',$type)->where('play_type',1)->where('date_slot_id',$row->id)->where('time_slot_id',$time_slot_id)->first();
					$single_win_no=isset($winSingleResultList->win_number)?$winSingleResultList->win_number:'';

					$winPattyResultList = DB::table('win_period')->where('type_id',$type)->where('play_type',2)->where('date_slot_id',$row->id)->where('time_slot_id',$time_slot_id)->first();
					$patty_win_no=isset($winPattyResultList->win_number)?$winPattyResultList->win_number:'';

					$win_result[]=array(
						'time_id'		=> $time_slot_id,
						'time_from'		=> $time_slot_from,
						'to_time'		=> $time_slot_to,
						'single_win_no'	=> $single_win_no,
						'patty_win_no'	=> $patty_win_no
					);
				}
			}
			
			$result[]=array(
				'date_slot_id'	=> $row->id,
				'date_slot'		=> $row->date,
				'win_result'	=> $win_result
			);
		}
		
		return $result;
		
	}
	

}
