<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB AS DB;

use Helpers;

class User_bit_transaction extends Model
{
    protected $table = 'user_bit_transaction';
	protected $guarded=[];
	
	
	
	
	public static function getDevTotalSingleBidResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		$slot_id 		= $param['slot_id'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$result=[];
		
		
		$singleBidResult	= [];
		$totalSingleAmount	= 0;
		
		
		/*$bid_numbers = DB::table('user_bit_transaction')->select('*')->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
		$amount=0;
		foreach($bid_numbers as $row){
			$amount +=$row->amount;
		}
		
		echo $amount;//25042*/
		
		
		$bid_numbers = DB::table('user_bit_transaction')->select('user_id', DB::raw('SUM(amount) as total_amount'))->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->groupBy('user_id')->get();
		
		$amount=0;
		
		//echo '<pre>';print_r($bid_numbers);exit;
		foreach($bid_numbers as $row){
			$amount =$row->total_amount;
			$user_id=$row->user_id;
			
			
			$wallet_data 	= Common::getSingelData($where=['user_id'=>$user_id],$table='user_wallet',$data=['balance'],'id','ASC');
			$balance_gross 	= isset($wallet_data->balance)? $wallet_data->balance:'0';
			$wallet_amount = 0;
			$wallet_amount+= $balance_gross;
			$wallet_amount+= $amount;
			//Common::updateData($table="user_wallet", "user_id", $user_id, array('balance'=>$wallet_amount,'updated_at'=>date('Y-m-d H:i:s')));	
			
			echo 'user_id-'.$user_id.'-wallet_amount-'.$wallet_amount.'</br>';
			
			
		}
		
		
		
		
		echo '<pre>';print_r($bid_numbers);exit;
		
		
		
		
		
		
		
		
		
		
		
		
		
		$distinct_single_win_numbers = DB::table('win_period')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('win_number', 'asc')->first();
		
		//print_r($distinct_single_win_numbers);exit;
		
		$single_win_number=isset($distinct_single_win_numbers->win_number)?$distinct_single_win_numbers->win_number:'0';
		
		
		
		if($cat_id!='' && $current_date!='' && $slot_id!=''){
			$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_single_bid_numbers as $row){
				$single_bid_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$single_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalSingleAmount+= $single_bid_amount;
				
				$singleBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$single_bid_count,
					'amount'=>$single_bid_amount
				);
			}
		}
		
		$return['singleBidResult']	 = $singleBidResult;
		$return['totalSingleAmount'] = $totalSingleAmount;
		$return['single_win_number'] = $single_win_number;
		
		
		return $return;
			
	}
	
	
	
	#START API FOR FFLIVERESULT
	
	public static function getffliveHistoryResult($param = array()) {
		$return			= array();
		
		$cat_id 			= $param['game_id'];
		$current_date		= $param['date_slot'];
		$cat_id 			= $param['game_id'];
		$current_date		= $param['date_slot'];
		
		$cur_page 		= $param['time_slot'] == '' ? 1 : $param['time_slot'];
        $limit_start	= ($cur_page - 1);
		$per_page		= 1;
		
		$game_result= DB::table('game_type')->select('game_type.*')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->offset($limit_start)->limit($per_page)->first();
		$time_slot_id=isset($game_result->id)?$game_result->id:'';
		
		if($time_slot_id!=''){
			$result	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','game_type.name','users.name as customer_name','users.phone','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'user_bit_transaction.time_slot_id')->leftJoin('game_type', 'game_type.id', 'user_bit_transaction.type_id')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->where('user_bit_transaction.category_id', $cat_id)->where('user_bit_transaction.date_slot', $current_date)->where('user_bit_transaction.time_slot_id', $time_slot_id);
			$result	= $result->orderby('user_bit_transaction.id', 'DESC')->get();
			$return['records'] = $result;
		}
		return $return;
			
	}
	
	
	public static function getffliveHistoryResult_old($param = array()) {
		$return				= array();
		$cat_id 			= $param['game_id'];
		$current_date		= $param['date_slot'];
		
		$cur_page 		= $param['time_slot'] == '' ? 1 : $param['time_slot'];
        $limit_start	= ($cur_page - 1);
		$per_page			= 1;
		
		$totalSingleAmount	= 0;
		$totalPattiAmount	= 0;
		$totalJodiAmount	= 0;
		$totalCpAmount		= 0;
		$totalWinAmount		= 0;
		
		$result=[];
		
		if($cat_id!=''){
			$game_result= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->offset($limit_start)->limit($per_page)->get();
			
			
			
			//$game_result	= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->get();
			
			
			//echo '<pre>';
			//print_r($game_result_test);
			//print_r($game_result);exit;
			
			
			
			foreach($game_result as $row){
				$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date)->first();
				
				$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
				$single_win_amount='';
				if($single_win_digit!=''){
					$single_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $single_win_digit)->where('play_type', 1)->first();
					$single_win_amount=isset($single_result->total_amount)?$single_result->total_amount:'';
					
					if($single_win_amount!=''){
						$totalSingleAmount+= $single_win_amount;
					}
				}
				
				$patti_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date)->first();
				$patti_win_digit=isset($patti_win_result->win_number)?$patti_win_result->win_number:'';
				$patti_win_amount='';
				if($patti_win_digit!=''){
					$patti_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $patti_win_digit)->where('play_type', 2)->first();
					$patti_win_amount=isset($patti_result->total_amount)?$patti_result->total_amount:'';
					if($patti_win_amount!=''){
						$totalPattiAmount+= $patti_win_amount;
					}
					
					$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $patti_win_digit)->where('play_type', 4)->first();
					$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
					if($cp_win_amount!=''){
						$totalPattiAmount+= $cp_win_amount;
					}
				}
				
				$jodi_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date)->first();
				$jodi_win_digit=isset($jodi_win_result->win_number)?$jodi_win_result->win_number:'';
				$jodi_win_amount='';
				if($jodi_win_digit!=''){
					$jodi_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $jodi_win_digit)->where('play_type', 3)->first();
					$jodi_win_amount=isset($jodi_result->total_amount)?$jodi_result->total_amount:'';
					if($jodi_win_amount!=''){
						$totalJodiAmount+= $jodi_win_amount;
					}
				}
				
				/*$cp_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date)->first();
				$cp_win_digit=isset($cp_win_result->win_number)?$cp_win_result->win_number:'';
				$cp_win_amount='';
				if($cp_win_digit!=''){
					$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $cp_win_digit)->where('play_type', 4)->first();
					$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
					if($cp_win_amount!=''){
						$totalCpAmount+= $cp_win_amount;
					}
				}*/
				
				$result[]=array(
					'id'				=> $row->id,
					'name'				=> $row->name,
					'from_time'			=> $row->from_time,
					'single_win_digit'	=> $single_win_digit,
					'single_win_amount'	=> $single_win_amount,
					'patti_win_digit'	=> $patti_win_digit,
					'patti_win_amount'	=> $patti_win_amount,
					'jodi_win_digit'	=> $jodi_win_digit,
					'jodi_win_amount'	=> $jodi_win_amount,
					//'cp_win_digit'		=> $cp_win_digit,
					//'cp_win_amount'		=> $cp_win_amount,
				);
			}
		}
		
		$return['record']=$result;
		
		//echo '<pre>';print_r($return);exit;
		
		$return['total_single_win_amount']	= $totalSingleAmount;
		$return['total_patti_win_amount']	= $totalPattiAmount;
		$return['total_jodi_win_amount']	= $totalJodiAmount;
		$return['total_cp_win_amount']		= $totalCpAmount;
		$return['total_win_amount']			= $totalSingleAmount+$totalPattiAmount+$totalJodiAmount+$totalCpAmount;
		
		
		
		return $return;
			
	}
	
	#END API FOR FFLIVERESULT
	
	
	public static function getTotalBidResultTest($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		$slot_id 		= $param['slot_id'];
		//$play_type_id 	= $param['play_type_id'];
		
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$result=[];
		
		//echo '<pre>';print_r($search);exit;
		
		
		$singleBidResult	= [];
		$totalSingleAmount	= 0;
		
		$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('time_slot_id', $slot_id)->where('play_type', 1)->where('date_slot', $current_date)->first();
		$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
			
		if($cat_id!='' && $current_date!='' && $slot_id!=''){
			
			
			$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('play_type', 1);

			if(!empty($search)){
				$distinct_single_bid_numbers = $distinct_single_bid_numbers->whereIn('user_id', $search);
			}
			$distinct_single_bid_numbers = $distinct_single_bid_numbers->groupBy('number')->get();
			
			//echo '<pre>';print_r($distinct_single_bid_numbers);exit;
			
			foreach($distinct_single_bid_numbers as $row){
				$status='p';
				if($single_win_digit!=''){
					if($single_win_digit==$row->number){
						$status='w';
					}else{
						$status='l';
					}
				}
				$singleBidResult[]=array(
					'digit'		=> $row->number,
					'totalBid'	=> $row->total_bid,
					'amount'	=> $row->total_amount,
					'status'	=> $status
				);
			}
		}
		
		$return['singleBidResult']	 = $singleBidResult;
		
		
		//echo '<pre>';print_r($return);exit;
		
		return $return;
			
	}
	
	public static function getTotalBidResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		$slot_id 		= $param['slot_id'];
		//$play_type_id 	= $param['play_type_id'];
		
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$result=[];
		
		
		$singleBidResult	    = [];
		$totalSingleAmount	    = 0;
		$totalSingleWinAmount	= 0;
		
		$pattiBidResult		    = [];
		$totalPattiAmount	    = 0;
		$totalPattiWinAmount	= 0;
		
		$jodiBidResult		    = [];
		$totalJodiAmount	    = 0;
		$totalJodiWinAmount	    = 0;
		
		$cpBidResult		    = [];
		$totalCpAmount		    = 0;
		$totalCpWinAmount		= 0;
		
		$single_bid_win_amount  = 0;
		$patti_bid_win_amount   = 0;
		$jodi_bid_win_amount    = 0;
		$cp_bid_win_amount      = 0;
		
		
		
		$price_calculation	= DB::table('win_price_calculation')->select('value')->where('category_id', $cat_id)->orderby('play_type', 'asc')->get();
		$calculation_single_value	= isset($price_calculation[0]->value)?$price_calculation[0]->value:'9.5';
		$calculation_patti_value	= isset($price_calculation[1]->value)?$price_calculation[1]->value:'100';
		$calculation_jodi_value	= isset($price_calculation[2]->value)?$price_calculation[2]->value:'90';
		$calculation_cp_value	= isset($price_calculation[3]->value)?$price_calculation[3]->value:'100';
		
		//echo "single-".$calculation_single_value."- patti-".$calculation_patti_value."- jodi-".$calculation_jodi_value." - cp -".$calculation_cp_value;
		
		//echo '<pre>';print_r($price_calculation);exit;
		
		
		
		
		
		
		if($cat_id!='' && $current_date!='' && $slot_id!=''){
			$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_single_bid_numbers as $row){
				$single_bid_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$single_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalSingleAmount+= $single_bid_amount;
				
				$singleBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$single_bid_count,
					'amount'=>$single_bid_amount
				);
			}
			
			$single_bid_win_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('win_status', 'win')->sum('amount');
			
			$distinct_patti_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_patti_bid_numbers as $row){
				$patti_bid_amount = DB::table('user_bit_transaction')->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$patti_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalPattiAmount+= $patti_bid_amount;
				
				$pattiBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$patti_bid_count,
					'amount'=>$patti_bid_amount
				);
				
			}
			
			$patti_bid_win_amount = DB::table('user_bit_transaction')->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('win_status', 'win')->sum('amount');
			
			$distinct_jodi_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_jodi_bid_numbers as $row){
				$jodi_bid_amount = DB::table('user_bit_transaction')->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$jodi_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalJodiAmount+= $jodi_bid_amount;
				
				$jodiBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$jodi_bid_count,
					'amount'=>$jodi_bid_amount
				);
				
			}
			
			$jodi_bid_win_amount = DB::table('user_bit_transaction')->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('win_status', 'win')->sum('amount');
			
			$distinct_cp_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_cp_bid_numbers as $row){
				$cp_bid_amount = DB::table('user_bit_transaction')->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$cp_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalCpAmount+= $cp_bid_amount;
				
				$cpBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$cp_bid_count,
					'amount'=>$cp_bid_amount
				);
				
			}
			
			$cp_bid_win_amount = DB::table('user_bit_transaction')->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('win_status', 'win')->sum('amount');
		}
		
		
		$return['singleBidResult']	    = $singleBidResult;
		$return['totalSingleAmount']    = $totalSingleAmount;
		$return['singleWinAmount']      = $single_bid_win_amount;
		$return['totalSingleWinAmount'] = $single_bid_win_amount*$calculation_single_value;
		
		$return['pattiBidResult'] 	    = $pattiBidResult;
		$return['totalPattiAmount']     = $totalPattiAmount;
		$return['pattiWinAmount']       = $patti_bid_win_amount;
		$return['totalPattiWinAmount']  = $patti_bid_win_amount*$calculation_patti_value;
		
		$return['jodiBidResult'] 	    = $jodiBidResult;
		$return['totalJodiAmount'] 	    = $totalJodiAmount;
		$return['jodiWinAmount'] 	    = $jodi_bid_win_amount;
		$return['totalJodiWinAmount'] 	= $jodi_bid_win_amount*$calculation_jodi_value;
		
		$return['cpBidResult'] 		    = $cpBidResult;
		$return['totalCpAmount'] 	    = $totalCpAmount;
		$return['cpWinAmount'] 	        = $cp_bid_win_amount;
		$return['totalCpWinAmount'] 	= $cp_bid_win_amount*$calculation_cp_value;
		return $return;
			
	}
	
	public static function getTotalSingleBidResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		$slot_id 		= $param['slot_id'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$result=[];
		
		
		$singleBidResult	= [];
		$totalSingleAmount	= 0;
		
		
		$distinct_single_win_numbers = DB::table('win_period')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('win_number', 'asc')->first();
		
		//print_r($distinct_single_win_numbers);exit;
		
		$single_win_number=isset($distinct_single_win_numbers->win_number)?$distinct_single_win_numbers->win_number:'0';
		
		
		
		if($cat_id!='' && $current_date!='' && $slot_id!=''){
			$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->orderby('number', 'asc')->get();
			foreach($distinct_single_bid_numbers as $row){
				$single_bid_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
				$single_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
				$totalSingleAmount+= $single_bid_amount;
				
				$singleBidResult[]=array(
					'digit'=>$row->number,
					'totalBid'=>$single_bid_count,
					'amount'=>$single_bid_amount
				);
			}
		}
		
		$return['singleBidResult']	 = $singleBidResult;
		$return['totalSingleAmount'] = $totalSingleAmount;
		$return['single_win_number'] = $single_win_number;
		
		
		return $return;
			
	}
	
	public static function getHistoryResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$totalSingleAmount	= 0;
		$totalPattiAmount	= 0;
		$totalJodiAmount	= 0;
		$totalCpAmount		= 0;
		$totalWinAmount		= 0;
		
		$result=[];
		
		
		
		
		if($cat_id!=''){
			$game_result	= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->get();
			
			foreach($game_result as $row){
				$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date)->first();
				$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
				$single_win_amount='';
				if($single_win_digit!=''){
					$single_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $single_win_digit)->where('play_type', 1)->first();
					$single_win_amount=isset($single_result->total_amount)?$single_result->total_amount:'';
					
					if($single_win_amount!=''){
						$totalSingleAmount+= $single_win_amount;
					}
					
					
				}
				
				$patti_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date)->first();
				$patti_win_digit=isset($patti_win_result->win_number)?$patti_win_result->win_number:'';
				$patti_win_amount='';
				if($patti_win_digit!=''){
					$patti_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $patti_win_digit)->where('play_type', 2)->first();
					$patti_win_amount=isset($patti_result->total_amount)?$patti_result->total_amount:'';
					if($patti_win_amount!=''){
						$totalPattiAmount+= $patti_win_amount;
					}
				}
				
				$jodi_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date)->first();
				$jodi_win_digit=isset($jodi_win_result->win_number)?$jodi_win_result->win_number:'';
				$jodi_win_amount='';
				if($jodi_win_digit!=''){
					$jodi_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $jodi_win_digit)->where('play_type', 3)->first();
					$jodi_win_amount=isset($jodi_result->total_amount)?$jodi_result->total_amount:'';
					if($jodi_win_amount!=''){
						$totalJodiAmount+= $jodi_win_amount;
					}
				}
				
				$cp_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date)->first();
				$cp_win_digit=isset($cp_win_result->win_number)?$cp_win_result->win_number:'';
				$cp_win_amount='';
				if($cp_win_digit!=''){
					$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $cp_win_digit)->where('play_type', 4)->first();
					$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
					if($cp_win_amount!=''){
						$totalCpAmount+= $cp_win_amount;
					}
				}
				
				$result[]=array(
					'id'				=> $row->id,
					'name'				=> $row->name,
					'from_time'			=> $row->from_time,
					'single_win_digit'	=> $single_win_digit,
					'single_win_amount'	=> $single_win_amount,
					'patti_win_digit'	=> $patti_win_digit,
					'patti_win_amount'	=> $patti_win_amount,
					'jodi_win_digit'	=> $jodi_win_digit,
					'jodi_win_amount'	=> $jodi_win_amount,
					'cp_win_digit'		=> $cp_win_digit,
					'cp_win_amount'		=> $cp_win_amount,
				);
			}
		}
		
		$return['record']=$result;
		
		$return['total_single_win_amount']	= $totalSingleAmount;
		$return['total_patti_win_amount']	= $totalPattiAmount;
		$return['total_jodi_win_amount']	= $totalJodiAmount;
		$return['total_cp_win_amount']		= $totalCpAmount;
		$return['total_win_amount']			= $totalSingleAmount+$totalPattiAmount+$totalJodiAmount+$totalCpAmount;
		
		
		
		return $return;
			
	}
	
	/*public static function getHistoryResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$slot_id 		= $param['slot_id'];
		$play_type_id 	= $param['play_type_id'];
		$current_date 	= $param['current_date'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		//$result	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','category.label','game_type.name','users.name as customer_name','users.phone')->leftJoin('category', 'category.id', 'user_bit_transaction.category_id')->leftJoin('game_type', 'game_type.id', 'user_bit_transaction.type_id')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id');
		
		$result	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','category.label','game_type.name','users.name as customer_name','users.phone','time_slots.from_time',DB::raw('count(user_bit_transaction.id) as total_bet'),DB::raw('sum(user_bit_transaction.amount) as total_amount'))->leftJoin('category', 'category.id', 'user_bit_transaction.category_id')->leftJoin('game_type', 'game_type.id', 'user_bit_transaction.type_id')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->leftJoin('time_slots', 'time_slots.id', 'user_bit_transaction.time_slot_id');
		
		if($cat_id!=''){
			$result = $result->where('user_bit_transaction.category_id', $cat_id);
		}
		if($slot_id!=''){
			$result = $result->where('user_bit_transaction.time_slot_id', $slot_id);
		}
		if($play_type_id!=''){
			$result = $result->where('user_bit_transaction.play_type', $play_type_id);
		}
		if($current_date!=''){
			$result = $result->where('user_bit_transaction.date_slot', $current_date);
		}
		
		$result	= $result->orderby('user_bit_transaction.id', 'DESC')->groupBy('user_bit_transaction.user_id')->get();
		
		$return['records'] = $result;
		return $return;
			
	}*/
	
	public static function getIndivisualResult($param = array()) {
		$return['records']			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$number 		= $param['number'];
		$current_date 	= $param['current_date'];
		$todate 		= $param['todate'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		if($cat_id!='' || $number!='' || $current_date!=''){
			$result	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','game_type.name','users.name as customer_name','users.phone','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'user_bit_transaction.time_slot_id')->leftJoin('game_type', 'game_type.id', 'user_bit_transaction.type_id')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id');
			
			if($cat_id!=''){
				$result = $result->where('user_bit_transaction.category_id', $cat_id);
			}
			if($number!=''){
				$result = $result->where('users.phone', $number);
			}
			if($current_date!='' && $todate!=''){
				$result = $result->where('user_bit_transaction.date_slot', '>=', $current_date)->where('user_bit_transaction.date_slot', '<=', $todate);
			}else{
				if($current_date!=''){
					$result = $result->where('user_bit_transaction.date_slot', $current_date);
				}
			}
			
			$result	= $result->orderby('user_bit_transaction.id', 'DESC')->get();
			$return['records'] = $result;
		}
		return $return;
			
	}
	
	public static function getDailyHistoryResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$current_date 	= $param['current_date'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$totalSingleAmount	= 0;
		$totalPattiAmount	= 0;
		$totalJodiAmount	= 0;
		$totalCpAmount		= 0;
		$totalWinAmount		= 0;
		
		$result=[];
		
		$total_bit_amount_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('date_slot', $current_date)->first();
		
		$total_bit_amount=isset($total_bit_amount_result->total_amount)?$total_bit_amount_result->total_amount:'0';
		
		//echo '<pre>';print_r($total_bit_amount);exit;
		
		
		
		
		if($cat_id!=''){
			
			$total_bit_amount_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('date_slot', $current_date)->first();
			$total_bit_amount=isset($total_bit_amount_result->total_amount)?$total_bit_amount_result->total_amount:'0';
		
		
			$single_price_calculation	= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',1)->first();
			$patti_price_calculation	= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',2)->first();
			$jodi_price_calculation		= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',3)->first();
			
			
			
			$single_calculation_value	= isset($single_price_calculation->value)?$single_price_calculation->value:'9.5';
			$patti_calculation_value	= isset($patti_price_calculation->value)?$patti_price_calculation->value:'120';
			$jodi_calculation_value		= isset($jodi_price_calculation->value)?$jodi_price_calculation->value:'80';
			
			
			//print_r($single_calculation_value);exit;
			
			
			
			
			
			$game_result	= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->get();
			
			foreach($game_result as $row){
				$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date)->first();
				$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
				$single_win_amount='';
				if($single_win_digit!=''){
					$single_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $single_win_digit)->where('play_type', 1)->first();
					$single_win_amount=isset($single_result->total_amount)?$single_result->total_amount:'';
					
					if($single_win_amount!=''){
						$totalSingleAmount+= $single_win_amount;
					}
					
					
				}
				
				$patti_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date)->first();
				$patti_win_digit=isset($patti_win_result->win_number)?$patti_win_result->win_number:'';
				$patti_win_amount='';
				if($patti_win_digit!=''){
					$patti_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $patti_win_digit)->where('play_type', 2)->first();
					$patti_win_amount=isset($patti_result->total_amount)?$patti_result->total_amount:'';
					if($patti_win_amount!=''){
						$totalPattiAmount+= $patti_win_amount;
					}
				}
				
				$jodi_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date)->first();
				$jodi_win_digit=isset($jodi_win_result->win_number)?$jodi_win_result->win_number:'';
				$jodi_win_amount='';
				if($jodi_win_digit!=''){
					$jodi_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $jodi_win_digit)->where('play_type', 3)->first();
					$jodi_win_amount=isset($jodi_result->total_amount)?$jodi_result->total_amount:'';
					if($jodi_win_amount!=''){
						$totalJodiAmount+= $jodi_win_amount;
					}
				}
				
				$cp_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date)->first();
				$cp_win_digit=isset($cp_win_result->win_number)?$cp_win_result->win_number:'';
				$cp_win_amount='';
				if($cp_win_digit!=''){
					$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date)->where('number', $cp_win_digit)->where('play_type', 4)->first();
					$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
					if($cp_win_amount!=''){
						$totalCpAmount+= $cp_win_amount;
					}
				}
				
				$single_total_win_amount =0;
				if($single_win_amount>0){
					$single_total_win_amount=$single_win_amount * $single_calculation_value;
				}
				
				$patti_total_win_amount =0;
				if($patti_win_amount>0){
					$patti_total_win_amount=$patti_win_amount * $patti_calculation_value;
				}
				
				$jodi_total_win_amount =0;
				if($jodi_win_amount>0){
					$jodi_total_win_amount=$jodi_win_amount * $jodi_calculation_value;
				}
				
				$cp_total_win_amount =0;
				if($cp_win_amount>0){
					$cp_total_win_amount=$cp_win_amount * $patti_calculation_value;
				}
				
				
				
				
				$result[]=array(
					'id'				=> $row->id,
					'name'				=> $row->name,
					'from_time'			=> $row->from_time,
					'single_win_digit'	=> $single_win_digit,
					'single_win_amount'	=> $single_win_amount,
					'single_total_win_amount'	=> $single_total_win_amount,
					'patti_win_digit'	=> $patti_win_digit,
					'patti_win_amount'	=> $patti_win_amount,
					'patti_total_win_amount' => $patti_total_win_amount,
					'jodi_win_digit'	=> $jodi_win_digit,
					'jodi_win_amount'	=> $jodi_win_amount,
					'jodi_total_win_amount'=> $jodi_total_win_amount,
					'cp_win_digit'		=> $cp_win_digit,
					'cp_win_amount'		=> $cp_win_amount,
					'cp_total_win_amount'=>$cp_total_win_amount
				);
			}
		}
		
		$return['record']=$result;
		
		$return['total_single_win_amount']	= $totalSingleAmount;
		$return['total_patti_win_amount']	= $totalPattiAmount;
		$return['total_jodi_win_amount']	= $totalJodiAmount;
		$return['total_cp_win_amount']		= $totalCpAmount;
		$return['total_win_amount']			= $totalSingleAmount+$totalPattiAmount+$totalJodiAmount+$totalCpAmount;
		$return['total_bit_amount']			= $total_bit_amount;
		
		
		
		return $return;
			
	}
	
	public static function getMonthlyHistoryResult_new($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$fromdate 		= $param['fromdate'];
		$todate 		= $param['todate'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$totalSingleAmount	= 0;
		$totalPattiAmount	= 0;
		$totalJodiAmount	= 0;
		$totalCpAmount		= 0;
		$totalWinAmount		= 0;
		
		$total_bit_amount	= 0;
		
		$result=[];
		
		
		
		$sDate		= strtotime($fromdate);
		$eDate 		= strtotime($todate);
		$datediff 	= $eDate - $sDate;
		$totalday	= round($datediff / (60 * 60 * 24));
		
		if($cat_id!='' && $fromdate!='' && $todate!='' ){
			$game_result	= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->get();
			
			if($totalday>=0){
				
				for($i=0;($totalday+1)>$i;$i++){
					$current_date_slot=date('Y-m-d', strtotime($fromdate. ' + '.$i.' days'));
					foreach($game_result as $row){
						
						$total_bit_amount_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('date_slot', $current_date_slot)->first();
						
						$bit_amount=isset($total_bit_amount_result->total_amount)?$total_bit_amount_result->total_amount:'';
						if($bit_amount!=''){
							$total_bit_amount+= $bit_amount;
						}
						
						
						
						$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date_slot)->first();
						$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
						$single_win_amount='';
						//if($single_win_digit!=''){
							$single_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('play_type', 1)->first();
							$single_win_amount=isset($single_result->total_amount)?$single_result->total_amount:'';
							if($single_win_amount!=''){
								$totalSingleAmount+= $single_win_amount;
							}
						//}
				
						$patti_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date_slot)->first();
						$patti_win_digit=isset($patti_win_result->win_number)?$patti_win_result->win_number:'';
						$patti_win_amount='';
						//if($patti_win_digit!=''){
							$patti_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('play_type', 2)->first();
							$patti_win_amount=isset($patti_result->total_amount)?$patti_result->total_amount:'';
							if($patti_win_amount!=''){
								$totalPattiAmount+= $patti_win_amount;
							}
						//}
				
						$jodi_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date_slot)->first();
						$jodi_win_digit=isset($jodi_win_result->win_number)?$jodi_win_result->win_number:'';
						$jodi_win_amount='';
						//if($jodi_win_digit!=''){
							$jodi_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('play_type', 3)->first();
							$jodi_win_amount=isset($jodi_result->total_amount)?$jodi_result->total_amount:'';
							if($jodi_win_amount!=''){
								$totalJodiAmount+= $jodi_win_amount;
							}
						//}
				
						$cp_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date_slot)->first();
						$cp_win_digit=isset($cp_win_result->win_number)?$cp_win_result->win_number:'';
						$cp_win_amount='';
						//if($cp_win_digit!=''){
							$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('play_type', 4)->first();
							$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
							if($cp_win_amount!=''){
								$totalCpAmount+= $cp_win_amount;
							}
						//}
				
						$result[]=array(
							'id'				=> $row->id,
							'date_slot'			=> $current_date_slot,
							'name'				=> $row->name,
							'from_time'			=> $row->from_time,
							'single_win_digit'	=> $single_win_digit,
							'single_win_amount'	=> $single_win_amount,
							'patti_win_digit'	=> $patti_win_digit,
							'patti_win_amount'	=> $patti_win_amount,
							'jodi_win_digit'	=> $jodi_win_digit,
							'jodi_win_amount'	=> $jodi_win_amount,
							'cp_win_digit'		=> $cp_win_digit,
							'cp_win_amount'		=> $cp_win_amount,
						);
					}
				}
			}
		}
		
		$return['record']=$result;
		
		$total_win_amount=$totalSingleAmount+$totalPattiAmount+$totalJodiAmount+$totalCpAmount;
		$return['total_single_win_amount']	= $totalSingleAmount;
		$return['total_patti_win_amount']	= $totalPattiAmount;
		$return['total_jodi_win_amount']	= $totalJodiAmount;
		$return['total_cp_win_amount']		= $totalCpAmount;
		$return['total_win_amount']			= number_format($total_win_amount,2);
		$return['total_bit_amount']			= $total_bit_amount;
		
		
		
		
		return $return;
			
	}
	
	public static function getMonthlyHistoryResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$fromdate 		= $param['fromdate'];
		$todate 		= $param['todate'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		$totalSingleAmount	= 0;
		$totalPattiAmount	= 0;
		$totalJodiAmount	= 0;
		$totalCpAmount		= 0;
		$totalWinAmount		= 0;
		
		$total_bit_amount	= 0;
		
		$result=[];
		
		
		
		$sDate		= strtotime($fromdate);
		$eDate 		= strtotime($todate);
		$datediff 	= $eDate - $sDate;
		$totalday	= round($datediff / (60 * 60 * 24));
		
		if($cat_id!='' && $fromdate!='' && $todate!='' ){
			$single_price_calculation	= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',1)->first();
			$patti_price_calculation	= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',2)->first();
			$jodi_price_calculation		= DB::table('win_price_calculation')->where('category_id',$cat_id)->where('play_type',3)->first();
			
			
			
			$single_calculation_value	= isset($single_price_calculation->value)?$single_price_calculation->value:'9.5';
			$patti_calculation_value	= isset($patti_price_calculation->value)?$patti_price_calculation->value:'120';
			$jodi_calculation_value		= isset($jodi_price_calculation->value)?$jodi_price_calculation->value:'80';
			
			
			//print_r($single_calculation_value);exit;
			
			
			
			
			
			$game_result	= DB::table('game_type')->select('game_type.*','time_slots.from_time')->leftJoin('time_slots', 'time_slots.id', 'game_type.time_slot_id')->where('game_type.category_id', $cat_id)->orderby('game_type.time_slot_id', 'ASC')->get();
			
			
			
			
			$total_bit_amount_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->whereBetween('date_slot', [$fromdate, $todate])->first();
			$bit_amount=isset($total_bit_amount_result->total_amount)?$total_bit_amount_result->total_amount:'';
			if($bit_amount!=''){
				$total_bit_amount+= $bit_amount;
			}
			
			if($totalday>=0){
				
				for($i=0;($totalday+1)>$i;$i++){
					$current_date_slot=date('Y-m-d', strtotime($fromdate. ' + '.$i.' days'));
					foreach($game_result as $row){
						
						/*$total_bit_amount_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('date_slot', $current_date_slot)->first();
						
						$bit_amount=isset($total_bit_amount_result->total_amount)?$total_bit_amount_result->total_amount:'';
						if($bit_amount!=''){
							$total_bit_amount+= $bit_amount;
						}*/
						
						
						
						$single_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date_slot)->first();
						$single_win_digit=isset($single_win_result->win_number)?$single_win_result->win_number:'';
						$single_win_amount='';
						if($single_win_digit!=''){
							$single_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $single_win_digit)->where('play_type', 1)->first();
							$single_win_amount=isset($single_result->total_amount)?$single_result->total_amount:'';
							if($single_win_amount!=''){
								$totalSingleAmount+= $single_win_amount;
							}
						}
				
						$patti_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date_slot)->first();
						$patti_win_digit=isset($patti_win_result->win_number)?$patti_win_result->win_number:'';
						$patti_win_amount='';
						if($patti_win_digit!=''){
							$patti_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $patti_win_digit)->where('play_type', 2)->first();
							$patti_win_amount=isset($patti_result->total_amount)?$patti_result->total_amount:'';
							if($patti_win_amount!=''){
								$totalPattiAmount+= $patti_win_amount;
							}
						}
				
						$jodi_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date_slot)->first();
						$jodi_win_digit=isset($jodi_win_result->win_number)?$jodi_win_result->win_number:'';
						$jodi_win_amount='';
						if($jodi_win_digit!=''){
							$jodi_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $jodi_win_digit)->where('play_type', 3)->first();
							$jodi_win_amount=isset($jodi_result->total_amount)?$jodi_result->total_amount:'';
							if($jodi_win_amount!=''){
								$totalJodiAmount+= $jodi_win_amount;
							}
						}
				
						$cp_win_result = DB::table('win_period')->where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date_slot)->first();
						$cp_win_digit=isset($cp_win_result->win_number)?$cp_win_result->win_number:'';
						$cp_win_amount='';
						if($cp_win_digit!=''){
							$cp_result = DB::table('user_bit_transaction')->select(DB::raw('sum(amount) as total_amount'))->where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $cp_win_digit)->where('play_type', 4)->first();
							$cp_win_amount=isset($cp_result->total_amount)?$cp_result->total_amount:'';
							if($cp_win_amount!=''){
								$totalCpAmount+= $cp_win_amount;
							}
						}
						
						$single_total_win_amount =0;
						if($single_win_amount>0){
							$single_total_win_amount=$single_win_amount * $single_calculation_value;
						}
						
						$patti_total_win_amount =0;
						if($patti_win_amount>0){
							$patti_total_win_amount=$patti_win_amount * $patti_calculation_value;
						}
						
						$jodi_total_win_amount =0;
						if($jodi_win_amount>0){
							$jodi_total_win_amount=$jodi_win_amount * $jodi_calculation_value;
						}
						
						$cp_total_win_amount =0;
						if($cp_win_amount>0){
							$cp_total_win_amount=$cp_win_amount * $patti_calculation_value;
						}
				
						$result[]=array(
							'id'				=> $row->id,
							'date_slot'			=> $current_date_slot,
							'name'				=> $row->name,
							'from_time'			=> $row->from_time,
							'single_win_digit'	=> $single_win_digit,
							'single_win_amount'	=> $single_win_amount,
							'single_total_win_amount'=>$single_total_win_amount,
							'patti_win_digit'	=> $patti_win_digit,
							'patti_win_amount'	=> $patti_win_amount,
							'patti_total_win_amount'=>$patti_total_win_amount,
							'jodi_win_digit'	=> $jodi_win_digit,
							'jodi_win_amount'	=> $jodi_win_amount,
							'jodi_total_win_amount'=>$jodi_total_win_amount,
							'cp_win_digit'		=> $cp_win_digit,
							'cp_win_amount'		=> $cp_win_amount,
							'cp_total_win_amount'=>$cp_total_win_amount
						);
					}
				}
			}
		}
		
		$return['record']=$result;
		
		$return['total_single_win_amount']	= number_format($totalSingleAmount,2);
		$return['total_patti_win_amount']	= number_format($totalPattiAmount,2);
		$return['total_jodi_win_amount']	= number_format($totalJodiAmount,2);
		$return['total_cp_win_amount']		= number_format($totalCpAmount,2);
		$return['total_win_amount']			= $totalSingleAmount+$totalPattiAmount+$totalJodiAmount+$totalCpAmount;
		$return['total_bit_amount']			= number_format($total_bit_amount,2);
		
		
		//echo '<pre>';print_r($return);exit;
		
		
		
		
		return $return;
			
	}
	
	public static function getCurrentGame($param = array()) {
		$return			= array();
		
		$current_date 		= $param['current_date'];
		$current_time 		= $param['current_time'];
		
		$time_slots_result = DB::table('time_slots')
			->where('to_time', '>=', $current_time)
			->orderby('from_time', 'asc')
			->first();
		
		$time_slot_id = isset($time_slots_result->id)?$time_slots_result->id:'';
		
		//echo '<pre>';print_r($time_slots_result);exit;
		
		$time_slot_result=[];
		
		if($time_slot_id!=''){
			$avality_slots	= DB::table('avality_time_date_slots')->select('avality_time_date_slots.*','game_type.slug','game_type.name')->leftJoin('game_type', 'game_type.id', 'avality_time_date_slots.game_type')->where('avality_time_date_slots.date', $current_date)->whereRaw('FIND_IN_SET('.$time_slot_id.',time_id)');
			$avality_slots	= $avality_slots->orderby('avality_time_date_slots.date', 'asc')->get();
			
			foreach($avality_slots as $row){
				$period_id			= Helpers::getPeriod($current_date,$time_slot_id,$row->game_type);
				$total_bid		 	= DB::table('user_bit_transaction')->where('period_id',$period_id)->where('status',1)->count();
				$total_bid_amount 	= DB::table('user_bit_transaction')->where('period_id',$period_id)->where('status',1)->sum('amount');
				$time_slot_result[]=array(
					'date_slot_id'	=> $row->id,
					'time_slot_id'	=> $time_slot_id,
					'type_slug'		=> $row->slug,
					'game'			=> $row->name,
					'time_slot'		=> $time_slots_result->from_time.'-'.$time_slots_result->to_time,
					'total_bid'		=> $total_bid,
					'total_amount'	=> $total_bid_amount,
					'period_id'		=> $period_id
				);
			}	
			
		}
		
		$return['records'] = $time_slot_result;
		return $return;
	}
	public static function getChartCurrentGame($param = array()) {
		$return = array();
		
		$current_date 		= $param['current_date'];
		$category_result 	= DB::table('category')->where('status',1)->get();
		
		foreach($category_result as $row){
			$total_bid	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('status',1)->count();
			$total_bid_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('status',1)->sum('amount');
			
			$total_win_amount=0;
			
			
			$single_price_calculation	= Win_price_calculation::where('category_id',$row->id)->where('play_type',1)->first();
			$single_calculation_value	= isset($single_price_calculation->value)?$single_price_calculation->value:'9.6';
			
			
			$patti_price_calculation	= Win_price_calculation::where('category_id',$row->id)->where('play_type',2)->first();
			$patti_calculation_value	= isset($patti_price_calculation->value)?$patti_price_calculation->value:'130';
			
			$jodi_price_calculation		= Win_price_calculation::where('category_id',$row->id)->where('play_type',3)->first();
			$jodi_calculation_value	= isset($jodi_price_calculation->value)?$jodi_price_calculation->value:'96';
			
			//echo $single_calculation_value.'-'.$patti_calculation_value.'-'.$jodi_calculation_value;exit;
			
			
			
			$total_single_win_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('win_status','win')->where('game_type','single')->sum('amount');
			$total_win_amount +=$total_single_win_amount*$single_calculation_value;
			
			$total_jodi_win_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('win_status','win')->where('game_type','jodi')->sum('amount');
			$total_win_amount +=$total_jodi_win_amount*$jodi_calculation_value;
			
			
			$total_patti_win_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('win_status','win')->where('game_type','patti')->sum('amount');
			$total_win_amount +=$total_patti_win_amount*$patti_calculation_value;
			
			
			$total_cp_win_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('win_status','win')->where('game_type','cp')->sum('amount');
			$total_win_amount +=$total_cp_win_amount*$patti_calculation_value;
			
			
			
			//echo $total_single_win_amount.'-'.$total_jodi_win_amount.'-'.$total_patti_win_amount.'-'.$total_cp_win_amount.'-';
			
			
			//echo $total_single_win_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('win_status','win')->sum('amount');
			
			
			
			$return[]=array(
				'id'				=> $row->id,
				'title'				=> $row->name,
				'total_bid'			=> $total_bid,
				'total_amount'		=> $total_bid_amount,
				'total_win_amount'	=> $total_win_amount,
				'color'				=> '#' . str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT)
			);
		}
		return $return;
	}
	
	public static function getChartCurrentGame_old($param = array()) {
		$return = array();
		
		$current_date 		= $param['current_date'];
		$category_result 	= DB::table('category')->where('status',1)->get();
		
		foreach($category_result as $row){
			$total_bid	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('status',1)->count();
			$total_bid_amount	= DB::table('user_bit_transaction')->where('category_id',$row->id)->where('date_slot',$current_date)->where('status',1)->sum('amount');
			$return[]=array(
				'id'			=> $row->id,
				'title'			=> $row->name,
				'total_bid'		=> $total_bid,
				'total_amount'	=> $total_bid_amount,
				'color'			=> '#' . str_pad(dechex(mt_rand(0, 0xFFFFFF)), 6, '0', STR_PAD_LEFT)
			);
		}
		return $return;
	}
	
	
	
	public static function getCurrentTransactions($param = array()) {
		$return			= array();
		
		$type 			= $param['type'];
		$play_type 		= isset($param['play_type'])?$param['play_type']:'1';
		$date_slot 		= $param['date_slot'];
		$time_slot 		= $param['time_slot'];
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		$game_type_info = DB::table('game_type')->where('slug',$type)->first();
		$date_slot_info = DB::table('avality_time_date_slots')->where('id',$date_slot)->first();
		$time_slot_info = DB::table('time_slots')->where('id',$time_slot)->first();
		
		//echo '<pre>';print_r($date_slot_info);exit;
		
		$game_type_title	= isset($game_type_info->name)?$game_type_info->name:'';
		$game_type_id		= isset($game_type_info->id)?$game_type_info->id:'';
		$time_slot_title	= isset($time_slot_info->from_time)?$time_slot_info->from_time.' - '.$time_slot_info->to_time:'';
		
		$transactions = DB::table('user_bit_transaction')->select('user_bit_transaction.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->where('user_bit_transaction.type_id', $game_type_id)->where('user_bit_transaction.play_type', $play_type)->where('user_bit_transaction.date_slot_id', $date_slot)->where('user_bit_transaction.time_slot_id', $time_slot)->where('user_bit_transaction.status',1);
		
		$transactions = $transactions->orderby('user_bit_transaction.id', 'DESC')->get();
		//$transactions = $transactions->orderby('transactions.id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		
		
		//echo '<pre>';print_r($transactions);exit;
		
		
		
		$period_id = Helpers::getPeriod($date_slot_info->date,$time_slot,$game_type_id,$play_type);
		
		$win_result_info=array();
		if($period_id!=''){
			$win_period_info = DB::table('win_period')->where('period',$period_id)->first();
		}
		
		
		
		
		$return['records']			= $transactions;
		$return['total_records']	= count($transactions);
		$return['game_type_title']	= $game_type_title;
		$return['time_slot_title']	= $time_slot_title;
		$return['win_period_info']	= $win_period_info;
		$return['period_id']		= $period_id;
		$return['type_id']			= $game_type_id;
		$return['play_type']		= $play_type;
		$return['date_slot_id']		= $date_slot_info->id;
		$return['date_slot']		= $date_slot_info->date;
		$return['time_slot_id']		= $time_slot;
		return $return;
	}
	
	public static function getCurrentBidTransactions($param = array()) {
		$return			= array();
		
		$type 			= $param['type'];
		$play_type 		= isset($param['play_type'])?$param['play_type']:'1';
		$date_slot 		= $param['date_slot'];
		$time_slot 		= $param['time_slot'];
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		$game_type_info = DB::table('game_type')->where('slug',$type)->first();
		$date_slot_info = DB::table('avality_time_date_slots')->where('id',$date_slot)->first();
		$time_slot_info = DB::table('time_slots')->where('id',$time_slot)->first();
		
		//echo '<pre>';print_r($date_slot_info);exit;
		
		$game_type_title	= isset($game_type_info->name)?$game_type_info->name:'';
		$game_type_id		= isset($game_type_info->id)?$game_type_info->id:'';
		$time_slot_title	= isset($time_slot_info->from_time)?$time_slot_info->from_time.' - '.$time_slot_info->to_time:'';
		
		$transactions = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('type_id', $game_type_id)->where('play_type', $play_type)->where('date_slot_id', $date_slot)->where('time_slot_id', $time_slot)->where('status',1)->orderby('number', 'asc')->groupBy('number')->get();
		
		$period_id = Helpers::getPeriod($date_slot_info->date,$time_slot,$game_type_id,$play_type);
		
		$win_result_info=array();
		if($period_id!=''){
			$win_period_info = DB::table('win_period')->where('period',$period_id)->first();
		}
		
		
		
		
		$return['records']			= $transactions;
		$return['total_records']	= count($transactions);
		$return['game_type_title']	= $game_type_title;
		$return['time_slot_title']	= $time_slot_title;
		$return['win_period_info']	= $win_period_info;
		$return['period_id']		= $period_id;
		$return['type_id']			= $game_type_id;
		$return['play_type']		= $play_type;
		$return['date_slot_id']		= $date_slot_info->id;
		$return['date_slot']		= $date_slot_info->date;
		$return['time_slot_id']		= $time_slot;
		return $return;
	}
	
	public static function getUserResult($param = array()) {
		
		$user_id 		= $param['user_id'];
		$type_id 		= $param['type'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		$baji_slot_arr=array('1'=>1,'2'=>2,'3'=>3,'4'=>4,'5'=>5,'6'=>6,'7'=>7,'8'=>8,'9'=>1,'10'=>2,'11'=>3,'12'=>4,'13'=>5,'14'=>6,'15'=>7,'16'=>8,'17'=>1,'18'=>2,'19'=>1,'20'=>2);
		
		//print_r($baji_slot_arr);exit;
		
		$avality_date_slots	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','avality_time_date_slots.id','avality_time_date_slots.date')->leftJoin('avality_time_date_slots', 'avality_time_date_slots.id', 'user_bit_transaction.date_slot_id')
		->where('user_bit_transaction.user_id',$user_id)
		->where('user_bit_transaction.type_id',$type_id)
		->where('user_bit_transaction.status',1)
		->orderBy('user_bit_transaction.created_at', 'desc')
		->get();
		$result=[];
		
		foreach($avality_date_slots as $row){
			$date_slot_id	= $row->date_slot_id;
			$date_slot		= $row->date;
			$time_slot_id	= $row->time_slot_id;
			$baji_slot_id	= isset($baji_slot_arr[$row->time_slot_id])?$baji_slot_arr[$row->time_slot_id]:'';
			$time_slot_info = DB::table('time_slots')->where('id',$time_slot_id)->first();
			$time_slot_from	= isset($time_slot_info->from_time)?$time_slot_info->from_time:'';
			$time_slot_to	= isset($time_slot_info->to_time)?$time_slot_info->to_time:'';
			$time_slot		= $time_slot_from.'-'.$time_slot_to;
			$win_number    	= $row->number;
			$amount    		= $row->amount;
			
			$play_type 		= 'SINGLE';
			if($row->play_type!=1){
				$play_type = 'PATTI';
			}
			
			$winResult = DB::table('win_period')->where('type_id',$type_id)->where('play_type',$row->play_type)->where('date_slot_id',$date_slot_id)->where('time_slot_id',$time_slot_id)->where('is_active','Y')->first();
						
			$win_status='Pending';
			if(isset($winResult)){
				if($winResult->win_number==$win_number){
					$win_status='Win';
				}else{
					$win_status='Loss';
				}
			}
			
			$result[]=array(
				'date_slot'		=> $date_slot,
				'time_slot_id'	=> $time_slot_id,
				'baji_no'		=> $baji_slot_id,
				'time_slot'		=> $time_slot,
				'play_type'		=> $play_type,
				'number'		=> $win_number,
				'win_status'	=> $win_status,
				'amount'		=> $amount,
			);
		}
		
		return $result;
		
	}
	
	
	public static function getUserBetHistoryResult($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		
		$cat_id 		= $param['cat_id'];
		$slot_id 		= $param['slot_id'];
		$play_type_id 	= $param['play_type_id'];
		$phone_number 	= $param['phone_number'];
		$current_date 	= $param['current_date'];
		
		$cur_page 		= $param['cur_page'];
		$per_page 		= $param['per_page'];
		$limit_start 	= $param['limit_start'];
		
		
		if($cat_id!='' || $slot_id!='' || $play_type_id!='' || $phone_number!=''){
			
		
			$result	= DB::table('user_bit_transaction')->select('user_bit_transaction.*','category.label','game_type.name','users.name as customer_name','users.phone')->leftJoin('category', 'category.id', 'user_bit_transaction.category_id')->leftJoin('game_type', 'game_type.id', 'user_bit_transaction.type_id')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id');
			
			if($cat_id!=''){
				$result = $result->where('user_bit_transaction.category_id', $cat_id);
			}
			if($slot_id!=''){
				$result = $result->where('user_bit_transaction.time_slot_id', $slot_id);
			}
			if($play_type_id!=''){
				$result = $result->where('user_bit_transaction.play_type', $play_type_id);
			}
			if($phone_number!=''){
				$result = $result->where('users.phone', $phone_number);
			}
			if($current_date!=''){
				$result = $result->where('user_bit_transaction.date_slot', $current_date);
			}
			
			$result	= $result->orderby('user_bit_transaction.id', 'DESC')->get();
			$return['records'] = $result;
		}else{
			$return['records'] = [];
		}
		
		
		return $return;
			
	}
	
	
	
}
