<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB AS DB;

use Helpers;

class Transactions extends Model
{
    protected $table = 'transactions';

	protected $guarded=[];
	
	public static function get_transactions($param = array()) {
		
		$user_id 			= $param['user_id'];
		$transaction_type	= $param['transaction_type'];
		$cur_page 			= $param['cur_page'];
        $per_page 			= $param['per_page'];
        $limit_start 		= $param['limit_start'];
		
		//print_r($param);exit;
		
		$transactions_result = DB::table('transactions')->where('user_id',$user_id)->where('type',$transaction_type)
		->orderBy('id', 'desc')
		->get();
		
		$result=[];
		
		foreach($transactions_result as $row){
			$type='';
			if($row->type==1){
				$type='Add Bit';
			}elseif($row->type==3){
				$type='Deposit Request';
			}elseif($row->type==4){
				$type='Withdrawal Request';
			}
			
			$result[]=array(
				'date'		=> date('Y-m-d',strtotime($row->date_slot)),
				'status'	=> $row->status,
				'amount'	=> $row->amount,
				'type'		=> $type
			);
		}
		return $result;
	}
	
	public static function getWithdrawDepositTransactions($param = array()) {
		
		$user_id 			= $param['user_id'];
		$transaction_type	= $param['transaction_type'];
		$cur_page 			= $param['cur_page'];
        $per_page 			= $param['per_page'];
        $limit_start 		= $param['limit_start'];
		
		
		
		if($transaction_type==3){
			$type='Deposit Request';
			$transactions_result = DB::table('balance_request')->where('user_id',$user_id)->orderBy('id', 'desc')->get();
		}else{
			$type='Withdrawal Request';
			$transactions_result = DB::table('withdraw_request')->where('user_id',$user_id)->orderBy('id', 'desc')->get();
		}
		
		$result=[];
		
		foreach($transactions_result as $row){
			$status='Pending';
			if($row->status=='completed'){
				$status='Paid';
			}elseif($row->status=='rejected'){
				$status='Rejected';
			}
			$result[]=array(
				'date'		=> date('Y-m-d',strtotime($row->created_at)),
				'status'	=> $status,
				'amount'	=> $row->amount,
				'type'		=> $type
			);
		}
		return $result;
	}
	
	public static function get_transaction_history($param = array()) {
		$number		= isset($param['number'])?$param['number']:'';		
		$user_id	= isset($param['user_id'])?$param['user_id']:'';
		$result=[];
		if($number!='' || $user_id!=''){
			$transactions_result = DB::table('transactions')->select('transactions.*')->leftJoin('users', 'users.id', 'transactions.user_id')->where('transactions.is_transaction_view',1);
			if($user_id!=''){
				$transactions_result =	$transactions_result->where('users.id',$user_id);
			}
			if($number!=''){
				$transactions_result =	$transactions_result->where('users.phone',$number);
			}
			
			$transactions_result = $transactions_result->orderBy('transactions.id', 'desc')->get();
			foreach($transactions_result as $row){
			$desc='';
			if($row->description!=''){
				$desc=str_replace(',',', ',$row->description);
			}
			
			$result[]=array(
				'user_id'		=> $row->user_id,
				'type'			=> $row->type,
				'category_id'	=> $row->category_id,
				'game_id'		=> $row->game_id,
				'play_type'		=> $row->play_type,
				'date_slot'		=> $row->date_slot,
				'time_slot_id'	=> $row->time_slot_id,
				'date'			=> date('Y-m-d H:i a',strtotime($row->created_at)),
				'desc'			=> $desc,
				'point'			=> $row->amount,
				'available_bal'	=> $row->available_bal,
			);
		}
		}
		return $result;
	}
}
