<?php
namespace App;
use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;
use Helpers;
class Time_slots extends Model
{
	protected $table 	= 'time_slots';
	protected $guarded	= [];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('time_slots')->join('category','category.id','=','time_slots.category_id');
        if($search != '') {
            $total_records = $total_records->where(function($total_records) use ($search) {
                $total_records->where(DB::raw("from_time"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$total_records = $total_records->count();
		
		$records = DB::table('time_slots')->select('time_slots.*','category.name','category.label')->join('category','category.id','=','time_slots.category_id');
		if($search != '') {
            $records = $records->where(function($records) use ($search) {
				$records->where(DB::raw("from_time"), 'LIKE', '%' . $search . '%');
            });
        }
		//->offset($limit_start)->limit($per_page)
		$records = $records->orderby('category_id', 'ASC')->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
	
	
	
	public static function getTimeSlotResultTest($param = array()) {
		
		$cat_id 		= $param['cat_id'];
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		
		$current_date 	= date('Y-m-d');
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -1 day'));
		
		$category_info 	= Category::where('id',$cat_id)->first();
		$category_name 	= isset($category_info->name)?$category_info->name:'';
		
		
		
		$slot_result	= DB::table('time_slots')->where('category_id',$cat_id)->get();
		
		
		$play_type_title='';
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$play_type_title .=' & '.$row->name;
		}
		$play_type_title = ltrim($play_type_title, ' &');
		
		/*Prev Date*/
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$next_result_btn_status='Y';
			
			if($i!=0){
				$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $row->id)->max('id');
				$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $game_id)->max('id');
				
				$checkPrevResult		= DB::table('win_period')->where('category_id',$cat_id)->where('game_id',$prev_game_id)->where('date_slot',$prev_date)->count();
				$next_result_btn_status='N';
				if($checkPrevResult>0){
					$next_result_btn_status='Y';
				}
			}
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'next_result_btn_status'=> $next_result_btn_status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		
		/*Current Date*/
		
		$currentSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$slot_row->id,$game_id,$row->id);
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			}
			$currentSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
				
			);	
		}
		
		$current_time_slot_result = [];
		$status	= 'N';
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$next_result_btn_status='Y';
			
			if($i!=0){
				$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $row->id)->max('id');
				$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $game_id)->max('id');
				
				$checkPrevResult		= DB::table('win_period')->where('category_id',$cat_id)->where('game_id',$prev_game_id)->where('date_slot',$current_date)->count();
				$next_result_btn_status='N';
				if($checkPrevResult>0){
					$next_result_btn_status='Y';
				}
			}
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$row->id,$game_id,$ptrow->id);
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($current_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			$current_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'next_result_btn_status'=> $next_result_btn_status,
				'play_result'	=> $play_result
			);
			
		 $i++;	
		}
		
		/*Current Date*/
		$result[]=array(
			'id'			=> 2,
			'date'			=> $current_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $current_time_slot_result,
			'slot_result' 	=> $currentSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$result[]=array(
			'id'			=> 1,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		
		
		return $result;
	}
	
	public static function getTimeSlotResult($param = array()) {
		
		$cat_id 		= $param['cat_id'];
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		
		$current_date 	= date('Y-m-d');
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -1 day'));
		
		$category_info 	= Category::where('id',$cat_id)->first();
		$category_name 	= isset($category_info->name)?$category_info->name:'';
		
		
		
		$slot_result	= DB::table('time_slots')->where('category_id',$cat_id)->get();
		
		
		$play_type_title='';
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$play_type_title .=' & '.$row->name;
		}
		$play_type_title = ltrim($play_type_title, ' &');
		
		/*Prev Date*/
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$next_result_btn_status='Y';
			
			if($i!=0){
				$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $row->id)->max('id');
				$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $game_id)->max('id');
				
				$checkPrevResult		= DB::table('win_period')->where('category_id',$cat_id)->where('game_id',$prev_game_id)->where('date_slot',$prev_date)->count();
				$next_result_btn_status='N';
				if($checkPrevResult>0){
					$next_result_btn_status='Y';
				}
			}
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'next_result_btn_status'=> $next_result_btn_status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		
		/*Current Date*/
		
		$currentSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$slot_row->id,$game_id,$row->id);
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			}
			$currentSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
				
			);	
		}
		
		$current_time_slot_result = [];
		$status	= 'N';
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$next_result_btn_status='Y';
			
			if($i!=0){
				$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $row->id)->max('id');
				$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $game_id)->max('id');
				
				$checkPrevResult		= DB::table('win_period')->where('category_id',$cat_id)->where('game_id',$prev_game_id)->where('date_slot',$current_date)->count();
				$next_result_btn_status='N';
				if($checkPrevResult>0){
					$next_result_btn_status='Y';
				}
			}
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$row->id,$game_id,$ptrow->id);
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('category_id', $cat_id)->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('category_id', $cat_id)->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($current_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			$current_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'next_result_btn_status'=> $next_result_btn_status,
				'play_result'	=> $play_result
			);
			
		 $i++;	
		}
		
		/*Current Date*/
		$result[]=array(
			'id'			=> 2,
			'date'			=> $current_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $current_time_slot_result,
			'slot_result' 	=> $currentSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$result[]=array(
			'id'			=> 1,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		
		
		return $result;
	}
	
	public static function getPrevTimeSlotResult($param = array()) {
		
		$cat_id 		= $param['cat_id'];
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		
		$current_date 	= date('Y-m-d');
		
		
		$category_info 	= Category::where('id',$cat_id)->first();
		$category_name 	= isset($category_info->name)?$category_info->name:'';
		
		
		
		$slot_result	= DB::table('time_slots')->where('category_id',$cat_id)->get();
		
		
		$play_type_title='';
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$play_type_title .=' & '.$row->name;
		}
		$play_type_title = ltrim($play_type_title, ' &');
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -12 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 1,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -11 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 2,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -10 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 3,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -9 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 4,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -8 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 5,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -7 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 6,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -6 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 7,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -5 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 8,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -4 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 9,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -3 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 10,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		
		
		/*Prev Date*/
		$prev_date 		= date('Y-m-d', strtotime($current_date .' -2 day'));
		$prevSlotWiseTypeResult=[];
		$play_type_result = DB::table('play_type')->where('status',1)->get();
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$slot_row->id,$game_id,$row->id);
				
				
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			$i++;
			}
			$prevSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
			);	
		}
		
		$prev_time_slot_result = [];
		$status	= 'N';
		
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = DB::table('play_type')->where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($prev_date,$cat_id,$row->id,$game_id,$ptrow->id);
				
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($prev_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				
				
				$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'type_slug'		=> $ptrow->slug,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			
			
			
			
			$prev_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;
		}
		/*Prev Date*/
		$result[]=array(
			'id'			=> 11,
			'date'			=> $prev_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'time_slot'		=> $prev_time_slot_result,
			'slot_result' 	=> $prevSlotWiseTypeResult
		);
		
		return $result;
	}
}
