<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Telescope_entries extends Model
{
    protected $table = 'telescope_entries';
	protected $fillable = ['ip','url','created_at'];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('telescope_entries');
		$total_records = $total_records->count();
		
		$records = DB::table('telescope_entries')->select('telescope_entries.*');
		$records = $records->orderby('id', 'DESC')->offset($limit_start)->limit(500)->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
	
	public static function get_user_bet_history($param = array()) {
		$return = array();
		
		$ph_array	= $param['search'];
		$cat_id 	= $param['cat_id'];
		$date_slot 	= $param['date_slot'];
		$time_slot 	= $param['time_slot'];
		
		if(isset($ph_array)){
			if(count($ph_array)>0){
				$records = DB::table('user_bit_transaction')->select('user_bit_transaction.number')->distinct()->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->where('user_bit_transaction.category_id', $cat_id)->where('user_bit_transaction.date_slot', $date_slot)->where('user_bit_transaction.time_slot_id', $time_slot)->where('user_bit_transaction.play_type', 1)->whereIn('users.phone', $ph_array)->orderby('user_bit_transaction.number', 'asc')->get();
				
				$win_period_result = DB::table('win_period')->select('win_number')->where('category_id', $cat_id)->where('date_slot', $date_slot)->where('time_slot_id', $time_slot)->where('play_type', 1)->first();
				$win_number=isset($win_period_result->win_number)?$win_period_result->win_number:'';
				
				
				
				foreach($records as $row){
					$digit=$row->number;
					$total_record = DB::table('user_bit_transaction')->select('user_bit_transaction.number')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->where('user_bit_transaction.number', $digit)->where('user_bit_transaction.category_id', $cat_id)->where('user_bit_transaction.date_slot', $date_slot)->where('user_bit_transaction.time_slot_id', $time_slot)->where('user_bit_transaction.play_type', 1)->whereIn('users.phone', $ph_array)->orderby('user_bit_transaction.number', 'asc')->count();
					
					$total_amount = DB::table('user_bit_transaction')->leftJoin('users', 'users.id', 'user_bit_transaction.user_id')->where('user_bit_transaction.number', $digit)->where('user_bit_transaction.category_id', $cat_id)->where('user_bit_transaction.date_slot', $date_slot)->where('user_bit_transaction.time_slot_id', $time_slot)->where('user_bit_transaction.play_type', 1)->whereIn('users.phone', $ph_array)->orderby('user_bit_transaction.number', 'asc')->sum('user_bit_transaction.amount');
					
					$is_win='P';
					if($win_number!=''){
						if($win_number==$digit){
							$is_win='Y';
						}else{
							$is_win='N';
						}
					}
					
					$return[]=array(
						'digit'			=> $digit,
						'total_bit'		=> $total_record,
						'total_amount'	=> $total_amount,
						'status'		=> $is_win,
						
					);
				}
			}
		}
		
		//echo '<pre>';print_r($return);exit;
		
		return $return;
		
		
	}
}
