<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\User;
use App\Common;
use App\User_wallet;

use Input;
use Session;
use Carbon;
use Auth;
use Image;
use DB;
use Helpers;
use Hash;
class UserController extends Controller {
	
	protected $userModel;
	
	 public function __construct(){
		$this->userModel	= new User;
		Helpers::set_elescope_entries();
    }
	
   
	public function user(){
		$title 			= "Users";
        $breadcumbs 	= "Users";
        $active 		= "user";
		
		$meta_data 		= array();
        $search 		= request()->input('s');
        $cur_page 		= request()->input('pg');
        $cur_page 		= $cur_page == '' ? 1 : $cur_page;
        $per_page		= 20;
        $limit_start	= ($cur_page - 1) * $per_page;
        $param = array();
        $param['search'] 		= $search;
		$param['name']		 	= request()->input('name');
		$param['email']		 	= request()->input('email');
		$param['user_status']	= request()->input('user_status');
        $param['cur_page'] 		= $cur_page;
        $param['per_page'] 		= $per_page;
        $param['limit_start']	= $limit_start;
		
		$user_list = $this->userModel->get_users($param);
		
		//echo '<pre>';print_r($user_list);exit;
		
		return view('admin.users', compact('title','active','breadcumbs','user_list'));
    }
	
	public function addUser(){
		$title 			= "Add User";
        $breadcumbs 	= "Add User";
        $active 		= "add_user";
		$data			= [];
		return view('admin.user_form', compact('title','active','breadcumbs','data'));
    }
	
	public function saveUserRequest(Request $request){
		$user_id		= $request->input('user_id');
		$name 			= $request->input('name');
		$phone			= $request->input('phone');
		$password 		= $request->input('password');
		
		$validator = Validator::make($request->all(), [
			'name'		=> 'required',
			'phone' 	=> 'required',
			'password' 	=> 'required',
        ]);
		
		

		if($validator->fails()){
			$errors=$validator->errors()->all();
			$error_html='';
			foreach($errors as $er){
				$error_html .='<span>'.$er.'</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
        }else{
			$user = new User;
			$user->user_type	= 2;
			$user->name 		= $name;
			$user->password		= Hash::make($password);
			$user->raw_password	= $password;
			$user->phone 		= $phone;
			$user->save();
			
			User_wallet::create([
				'user_id' => $user->id,
            	'balance' => 0
			]);
			
			
			
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/user');
	}
	
	public function user_show($slug){
		 $title 		= "User Details";
		 $breadcumbs 	= "User Details";
		 $active 		= 'user';
		 
		 $param['user_id']	= $slug;
		 $user_info 		= $this->userModel->get_user($param);
		 
		 //echo '<pre>';print_r($user_info['records']['name']);exit;
		 
		 return view('admin.user_details', compact('title','breadcumbs','active','user_info'));	  
    }
	
	public function deleteUser() {
		$user_id = request()->input('id');
		if ($user_id != null) {
			Common::deleteData('users','id',$user_id);
			Common::deleteData('user_wallet','user_id',$user_id);
			Common::deleteData('user_bit_transaction','user_id',$user_id);
			Common::deleteData('user_bank','user_id',$user_id);
			Common::deleteData('transactions','user_id',$user_id);
			Common::deleteData('balance_request','user_id',$user_id);
			Common::deleteData('withdraw_request','user_id',$user_id);
			Session::flash('success', 'User deleted successfully.');
			}else{
				Session::flash('error', 'Something wrong please try again !');
			}
			
		return redirect::back();
    }
	
	public function userInactive() {
		$user_id = request()->input('id');
		if ($user_id != null) {
			Common::updateData($table="users", "id", $user_id, array('status'=>0,'updated_at'=>date('Y-m-d H:i:s')));

			/*$user_data 		= Common::getSingelData($where=['id'=>$user_id],$table='users',$data=['device_token'],'id','ASC');
			$device_token 	= isset($user_data->device_token)? $user_data->device_token:'';
			

			Common::deleteData('user_device_token_status','user_id',$user_id);
			
			$userData=array(
				'user_id'   	=> $user_id,
				'device_token'	=> $device_token,
				'status'		=> 'inactive',
			);
			UserDeviceTokenStatus::create($userData);*/

			Session::flash('success', 'User In-active successfully.');
			}else{
				Session::flash('error', 'Something wrong please try again !');
			}
			
		return redirect::back();
    }

	public function userActive() {
		$user_id = request()->input('id');
		if ($user_id != null) {
			Common::updateData($table="users", "id", $user_id, array('status'=>1,'updated_at'=>date('Y-m-d H:i:s')));
			//Common::deleteData('user_device_token_status','user_id',$user_id);
			Session::flash('success', 'User Active successfully.');
			}else{
				Session::flash('error', 'Something wrong please try again !');
			}
			
		return redirect::back();
    }
 
	
}