<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\User;
use Input;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

use Session;
use Carbon;
use Auth;
use Image;
use DB;
use Helpers;
use Hash;
use App\Common;
use App\User_wallet;
use App\Payments;
use App\Withdraw_request;
use App\Balance_request;
use App\Time_slots;
use App\Category;
use App\Play_type;
use App\Game_type;
use App\Transactions;
use App\User_bit_transaction;
use App\Avality_time_date_slots;
use App\Win_price_calculation;
use App\AppNotifications;
use App\Win_period;
use Config;
class ResultController extends Controller
{
	protected $paymentsModel;
	protected $withdrawRequestModel;
	protected $balanceRequestModel;
	protected $timeSlotsModel;
	protected $userBitTransactionModel;
	protected $avalityTimeDateSlotsModel;
	protected $userTransactionsModel;
	public function __construct()
	{
		$this->paymentsModel = new Payments;
		$this->withdrawRequestModel = new Withdraw_request;
		$this->balanceRequestModel = new Balance_request;
		$this->timeSlotsModel = new Time_slots;
		$this->userBitTransactionModel = new User_bit_transaction;
		$this->avalityTimeDateSlotsModel = new Avality_time_date_slots;
		$this->userTransactionsModel = new Transactions;
		Helpers::set_elescope_entries();
	}

	/*+++++++++++++++++++++++ Notification +++++++++++++++++++++++++++++++++++*/

	public function sendNotificationToAll($title, $content)
	{
		$topic = 'ff2-notification'; // Topic to send the notification to

		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json'; // Path to service account file

		// Initialize Firebase with the service account credentials
		$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
		$messaging = $factory->createMessaging();

		// Create the message to send
		$message = CloudMessage::withTarget('topic', $topic)
			->withNotification([
					'title' => strtoupper($title), // Using dynamic title
					'body' => $content, // Using dynamic content
				])
			->withData([
					'title' => strtoupper($title),
					'body' => $content,
					'notification_foreground' => 'true',
					'notification_status' => 'true',
					'show_status' => 'true',
					'head_title' => 'success',
					'is_notification' => 'true',
				]); // Custom data

		// Send the notification to the topic
		$messaging->send($message);

		return true;
	}

	public function sendNotificationToSingle($userId, $title, $content)
	{
		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json'; // Path to service account file

		$user = User::find($userId);
		$device_token = $user->fcm_token ?? '';

		if ($device_token != '') {
			// Initialize Firebase with the service account credentials
			$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
			$messaging = $factory->createMessaging();

			$message = CloudMessage::withTarget('token', $device_token)
				->withNotification([
						'title' => strtoupper($title),
						'body' => $content,
					])
				->withData([
						'title' => strtoupper($title),
						'body' => $content,
						'notification_foreground' => 'true',
						'notification_status' => 'true',
						'show_status' => 'true',
						'head_title' => 'success',
						'is_notification' => 'true',
						'priceRefresh' => '1'
					]);

			//echo '<pre>';print_r($message);exit;
			$messaging->send($message);
		}

		return true;
	}

	/*+++++++++++++++++++++++End+++++++++++++++++++++++++++++++++++*/


	/*+++++++++++++++++++++++Dev+++++++++++++++++++++++++++++++++++*/
	public function dev_game_result()
	{
		$title = 'Total Bet';
		$breadcumbs = 'Total Bet';
		$active = 'showbid';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$slot_id = request()->input('slot_id');
		$play_type_id = request()->input('type_id');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['slot_id'] = $slot_id;
		$param['play_type_id'] = $play_type_id;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getDevTotalSingleBidResult($param);


		echo '<pre>';
		print_r($param);
		exit;
		return view('admin.playhistory/showbid2', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date'));



	}

	/*+++++++++++++++++++++++Dev+++++++++++++++++++++++++++++++++++*/





	public function showbiddetails()
	{
		$title = 'Total Bet';
		$breadcumbs = 'Total Bet';
		$active = 'showbid';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$slot_id = request()->input('slot_id');
		$play_type_id = request()->input('type_id');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['slot_id'] = $slot_id;
		$param['play_type_id'] = $play_type_id;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getTotalSingleBidResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}
		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/showbid2', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date'));



	}
	public function showbid()
	{
		$title = 'Total Bet';
		$breadcumbs = 'Total Bet';
		$active = 'showbid';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$slot_id = request()->input('slot_id');
		$play_type_id = request()->input('type_id');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['slot_id'] = $slot_id;
		$param['play_type_id'] = $play_type_id;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getTotalBidResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}
		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/showbid', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date'));
	}
	public function history()
	{
		$title = 'Bet History';
		$breadcumbs = 'Bet History';
		$active = 'history';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		} else {
			$current_date = date('Y-m-d');
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getHistoryResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}
		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/history', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date'));
	}

	/*public function history(){
		$title 			= 'Bet History';
		$breadcumbs 	= 'Bet History';
		$active 		= 'history';
		$meta_data 		= array();
		$search 		= request()->input('s');
		$cat_id 		= request()->input('cat_id');
		$slot_id 		= request()->input('slot_id');
		$play_type_id 	= request()->input('type_id');
		$date 			= request()->input('date');
		$cur_page 		= request()->input('pg');
		$current_date 	= '';
		if(isset($_GET['date'])){
			if($date!=''){
				$current_date = $date;
			}
		}else{
			$current_date = date('Y-m-d');
		}
		$cur_page 		= $cur_page == '' ? 1 : $cur_page;
		$per_page		= 20;
		$limit_start	= ($cur_page - 1) * $per_page;
		$param 					= array();
		$param['search'] 		= $search;
		$param['cat_id'] 		= $cat_id;
		$param['slot_id'] 		= $slot_id;
		$param['play_type_id'] 	= $play_type_id;
		$param['current_date'] 	= $current_date;
		$param['cur_page'] 		= $cur_page;
		$param['per_page'] 		= $per_page;
		$param['limit_start']	= $limit_start;
		$result 				= $this->userBitTransactionModel->getHistoryResult($param);
		$category_list 			= Category::get();
		$type_list     			= Play_type::get();
		$time_slots				= [];
		if($cat_id!=''){
			$time_slots	= Time_slots::where('category_id',$cat_id)->get();
		}
		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/history', compact('title','active','breadcumbs','category_list','type_list','time_slots','result','current_date'));
	}*/
	public function indivisual()
	{
		$title = 'Indivisual Bet History';
		$breadcumbs = 'Indivisual Bet History';
		$active = 'indivisual';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$number = request()->input('number');
		$date = request()->input('date');
		$todate = request()->input('todate');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['number'] = $number;
		$param['current_date'] = $current_date;
		$param['todate'] = $todate;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getIndivisualResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}

		//$userWalletInfo=User_wallet::where('user_id',2)->first();
		//$walletBalance=isset($userWalletInfo->balance)?$userWalletInfo->balance:'0';


		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/indivisual', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date', 'todate'));
	}

	public function userBetHistory()
	{
		$title = 'User Bet History';
		$breadcumbs = 'User Bet History';
		$active = 'user_bet_history';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$slot_id = request()->input('slot_id');
		$play_type_id = request()->input('type_id');
		$phone_number = request()->input('phone_number');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		} else {
			$current_date = date('Y-m-d');
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['slot_id'] = $slot_id;
		$param['play_type_id'] = $play_type_id;
		$param['phone_number'] = $phone_number;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getUserBetHistoryResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}

		$game_status_login = Session::get('game_bet_history_login');
		$is_login = 'Y';
		if ($game_status_login == 'Y') {
			$is_login = 'Y';
		}
		//echo '<pre>';print_r($is_login);exit;

		return view('admin.playhistory/userBetHistory', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date', 'is_login'));
	}

	public function deleteUserBet()
	{
		//echo 'ff';exit;
		$bet_id = request()->input('id');
		if ($bet_id != null) {
			$check = Common::getSingelData($where = ['id' => $bet_id], $table = 'user_bit_transaction', $data = ['*'], 'id', 'ASC');
			$bid_number = isset($check->number) ? $check->number : '';
			$user_id = isset($check->user_id) ? $check->user_id : '';
			$amount = isset($check->amount) ? $check->amount : '';

			$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount += $amount;

			Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));
			Common::deleteData('user_bit_transaction', 'id', $bet_id);

			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Cancel bid request, no.' . $bid_number,
				'amount' => $amount,
				'type' => 1,
				'status' => 'paid',
				'is_transaction_view' => 1,
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);


			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Amount Created',
				'amount' => $amount,
				'available_bal' => $wallet_amount,
				'type' => 4,
				'status' => 'paid',
				'is_transaction_view' => 1,
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);


			$title = strtoupper('Accepted cancel bid request');
			$content = 'Amount-' . $amount . " .Tap to refresh.";

			$this->sendNotificationToSingle($user_id, $title, $content);

			Session::flash('success', 'Date deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}



	public function dailyReport()
	{
		$title = 'Daily Report';
		$breadcumbs = 'Daily Report';
		$active = 'daily';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$date = request()->input('date');
		$cur_page = request()->input('pg');
		$current_date = '';
		if (isset($_GET['date'])) {
			if ($date != '') {
				$current_date = $date;
			}
		} else {
			$current_date = date('Y-m-d');
		}
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['current_date'] = $current_date;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getDailyHistoryResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}

		//Session::put('game_status_login', 'N');

		$game_status_login = Session::get('game_status_login');

		$is_login = 'Y';
		if ($game_status_login == 'Y') {
			$is_login = 'Y';
		}

		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/daily_history', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'current_date', 'is_login'));
	}

	public function monthlyReport_old()
	{
		$title = 'Monthly Report';
		$breadcumbs = 'Monthly Report';
		$active = 'monthly';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$cur_page = request()->input('pg');


		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $cat_id;
		$param['fromdate'] = $fromdate;
		$param['todate'] = $todate;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = $this->userBitTransactionModel->getMonthlyHistoryResult($param);
		$category_list = Category::where('is_deleted', 0)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}
		$game_status_login = Session::get('game_status_login');

		$is_login = 'Y';
		if ($game_status_login == 'Y') {
			$is_login = 'Y';
		}
		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/monthly_history', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'fromdate', 'todate', 'is_login'));
	}
	public function monthlyReport()
	{
		$title = 'Monthly Report';
		$breadcumbs = 'Monthly Report';
		$active = 'monthly';
		$meta_data = array();
		$search = request()->input('s');
		$cat_id = request()->input('cat_id');
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$cur_page = request()->input('pg');

		$category_list = Category::where('status', 1)->orderby('sort', 'ASC')->get();
		$type_list = Play_type::get();
		$time_slots = [];
		if ($cat_id != '') {
			$time_slots = Time_slots::where('category_id', $cat_id)->get();
		}

		$is_login = 'Y';

		$bid_result = [];



		$totalSingleAmount = 0;
		$totalPattiAmount = 0;
		$totalJodiAmount = 0;
		$totalCpAmount = 0;
		$totalWinAmount = 0;
		$total_bit_amount = 0;

		if ($cat_id != '' && $fromdate != '' && $todate != '') {
			$sDate = strtotime($fromdate);
			$eDate = strtotime($todate);
			$datediff = $eDate - $sDate;
			$totalday = round($datediff / (60 * 60 * 24));

			$single_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 1)->first();
			$patti_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 2)->first();
			$jodi_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 3)->first();

			$single_calculation_value = isset($single_price_calculation->value) ? $single_price_calculation->value : '9.5';
			$patti_calculation_value = isset($patti_price_calculation->value) ? $patti_price_calculation->value : '120';
			$jodi_calculation_value = isset($jodi_price_calculation->value) ? $jodi_price_calculation->value : '80';

			$game_result = Game_type::where('category_id', $cat_id)->orderby('time_slot_id', 'ASC')->get();

			$bit_amount = User_bit_transaction::where('category_id', $cat_id)->whereBetween('date_slot', [$fromdate, $todate])->sum('amount');
			if ($bit_amount != '') {
				$total_bit_amount += $bit_amount;
			}

			//echo '<pre>';print_r($total_bit_amount);exit;



			if ($totalday >= 0) {

				for ($i = 0; ($totalday + 1) > $i; $i++) {
					$current_date_slot = date('Y-m-d', strtotime($fromdate . ' + ' . $i . ' days'));
					$bid_result[] = array(
						'id' => '',
						'date_slot' => $current_date_slot,
						'name' => '',
						'from_time' => '',
						'single_win_digit' => '',
						'single_win_amount' => '',
						'single_total_win_amount' => '',
						'patti_win_digit' => '',
						'patti_win_amount' => '',
						'patti_total_win_amount' => '',
						'jodi_win_digit' => '',
						'jodi_win_amount' => '',
						'jodi_total_win_amount' => '',
						'cp_win_digit' => '',
						'cp_win_amount' => '',
						'cp_total_win_amount' => ''
					);
					foreach ($game_result as $row) {

						$single_win_result = Win_period::where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('date_slot', $current_date_slot)->first();
						$single_win_digit = isset($single_win_result->win_number) ? $single_win_result->win_number : '';
						$single_win_amount = '';
						if ($single_win_digit != '') {
							$single_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $single_win_digit)->where('play_type', 1)->sum('amount');
							if ($single_win_amount != '') {
								$totalSingleAmount += $single_win_amount;
							}
						}


						$patti_win_result = Win_period::where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('date_slot', $current_date_slot)->first();
						$patti_win_digit = isset($patti_win_result->win_number) ? $patti_win_result->win_number : '';
						$patti_win_amount = '';
						if ($patti_win_digit != '') {
							$patti_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $patti_win_digit)->where('play_type', 2)->sum('amount');
							if ($patti_win_amount != '') {
								$totalPattiAmount += $patti_win_amount;
							}
						}

						$jodi_win_result = Win_period::where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('date_slot', $current_date_slot)->first();
						$jodi_win_digit = isset($jodi_win_result->win_number) ? $jodi_win_result->win_number : '';
						$jodi_win_amount = '';
						if ($jodi_win_digit != '') {
							$jodi_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $jodi_win_digit)->where('play_type', 3)->sum('amount');
							if ($jodi_win_amount != '') {
								$totalJodiAmount += $jodi_win_amount;
							}
						}

						$cp_win_result = Win_period::where('category_id', $cat_id)->where('game_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('date_slot', $current_date_slot)->first();
						$cp_win_digit = isset($cp_win_result->win_number) ? $cp_win_result->win_number : '';
						$cp_win_amount = '';
						if ($cp_win_digit != '') {
							$cp_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('type_id', $row->id)->where('time_slot_id', $row->time_slot_id)->where('date_slot', $current_date_slot)->where('number', $cp_win_digit)->where('play_type', 4)->sum('amount');
							if ($cp_win_amount != '') {
								$totalCpAmount += $cp_win_amount;
							}
						}

						$single_total_win_amount = 0;
						if ($single_win_amount > 0) {
							$single_total_win_amount = $single_win_amount * $single_calculation_value;
						}

						$patti_total_win_amount = 0;
						if ($patti_win_amount > 0) {
							$patti_total_win_amount = $patti_win_amount * $patti_calculation_value;
						}

						$jodi_total_win_amount = 0;
						if ($jodi_win_amount > 0) {
							$jodi_total_win_amount = $jodi_win_amount * $jodi_calculation_value;
						}

						$cp_total_win_amount = 0;
						if ($cp_win_amount > 0) {
							$cp_total_win_amount = $cp_win_amount * $patti_calculation_value;
						}


						$bid_result[] = array(
							'id' => $row->id,
							'date_slot' => $current_date_slot,
							'name' => $row->name,
							'from_time' => '',
							'single_win_digit' => $single_win_digit,
							'single_win_amount' => $single_win_amount,
							'single_total_win_amount' => $single_total_win_amount,
							'patti_win_digit' => $patti_win_digit,
							'patti_win_amount' => $patti_win_amount,
							'patti_total_win_amount' => $patti_total_win_amount,
							'jodi_win_digit' => $jodi_win_digit,
							'jodi_win_amount' => $jodi_win_amount,
							'jodi_total_win_amount' => $jodi_total_win_amount,
							'cp_win_digit' => $cp_win_digit,
							'cp_win_amount' => $cp_win_amount,
							'cp_total_win_amount' => $cp_total_win_amount
						);

						//echo '<pre>';print_r($bid_result);exit;
					}

				}
			}
		}

		$result = [];
		$result['record'] = $bid_result;

		$result['total_single_win_amount'] = number_format($totalSingleAmount, 2);
		$result['total_patti_win_amount'] = number_format($totalPattiAmount, 2);
		$result['total_jodi_win_amount'] = number_format($totalJodiAmount, 2);
		$result['total_cp_win_amount'] = number_format($totalCpAmount, 2);
		$result['total_win_amount'] = $totalSingleAmount + $totalPattiAmount + $totalJodiAmount + $totalCpAmount;
		$result['total_bit_amount'] = number_format($total_bit_amount, 2);



		//echo '<pre>';print_r($result);exit;
		return view('admin.playhistory/monthly_history_new', compact('title', 'active', 'breadcumbs', 'category_list', 'type_list', 'time_slots', 'result', 'fromdate', 'todate', 'is_login'));
	}

	public function gameStatusLogin(Request $request)
	{
		$password = $request->input('password');
		$oldPass = 'ff96@789';
		if ($password == $oldPass) {
			Session::put('game_status_login', 'Y');
			$return_data['success'] = 1;
		} else {
			$return_data['success'] = 0;
		}
		echo json_encode($return_data);
	}

	public function gameBetStatusLogin(Request $request)
	{
		$password = $request->input('password');
		$oldPass = 'ff96@789';
		if ($password == $oldPass) {
			Session::put('game_bet_history_login', 'Y');
			$return_data['success'] = 1;
		} else {
			$return_data['success'] = 0;
		}
		echo json_encode($return_data);
	}


	public function currentTimeSlotResultTest($id)
	{
		$title = 'Result';
		$breadcumbs = 'Result';
		$category_info = Category::where('id', $id)->first();
		$active = isset($category_info->slug) ? $category_info->slug : 'result';
		$category_id = $id;
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $id;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = Time_slots::getTimeSlotResultTest($param);
		$type_list = Play_type::get();

		$totalSlot = isset($result[0]['time_slot']) ? count($result[0]['time_slot']) : '0';

		//echo '<pre>';print_r($result);exit;
		return view('admin.set_result/index', compact('title', 'active', 'breadcumbs', 'result', 'type_list', 'category_id'));
	}


	public function currentTimeSlotResult($id)
	{
		$title = 'Result';
		$breadcumbs = 'Result';
		$category_info = Category::where('id', $id)->first();
		$active = isset($category_info->slug) ? $category_info->slug : 'result';
		$category_id = $id;
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $id;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = Time_slots::getTimeSlotResult($param);
		$type_list = Play_type::get();

		$totalSlot = isset($result[0]['time_slot']) ? count($result[0]['time_slot']) : '0';

		//echo '<pre>';print_r($result);exit;
		return view('admin.set_result/index', compact('title', 'active', 'breadcumbs', 'result', 'type_list', 'category_id'));
	}
	public function save_result_request(Request $request)
	{

		$category_id = $request->input('category_id');
		$win_number = $request->input('win_number');
		$slot_period = $request->input('period_id');
		$type = $request->input('type_id');
		$game_id = $request->input('game_id');
		$date_slot = $request->input('date_slot');
		$time_slot_id = $request->input('time_slot_id');
		$time_id = $request->input('time_id');
		//echo '<pre>';print_r($_POST);exit;
		/*$validator = Validator::make($request->all(), [
			"win_number.*"=> "required|string|min:0"
		]);*/
		$validator = Validator::make($request->all(), [
			'category_id' => 'required',
			'time_slot_id' => 'required',
		]);

		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {

			$baziResult = Game_type::where('id', $game_id)->where('category_id', $category_id)->first();
			$bazi_title = isset($baziResult->name) ? $baziResult->name : '';
			$categotyResult = Category::where('id', $category_id)->first();
			$played_game_title = isset($categotyResult->name) ? $categotyResult->name : '';

			$description = 'Won ' . $played_game_title . ' ' . $bazi_title;




			//echo '<pre>';print_r($description);exit;
			for ($i = 0; count($slot_period) > $i; $i++) {
				$period_id = $slot_period[$i];
				$type_id = $type[$i];
				$number = $win_number[$i];

				if ($number != '') {
					$price_calculation = Win_price_calculation::where('category_id', $category_id)->where('play_type', $type_id)->first();

					if ($type_id == 4) {
						$price_calculation = Win_price_calculation::where('category_id', $category_id)->where('play_type', 2)->first();
					}

					$calculation_type = isset($price_calculation->calculation_type) ? $price_calculation->calculation_type : 1;
					$calculation_value = isset($price_calculation->value) ? $price_calculation->value : '9.5';
					$userBitTransactionResult = $this->userBitTransactionModel->select('*', DB::raw('SUM(amount) as total_amount'))->where('period_id', $period_id)->where('number', $number)->where('status', 1)->groupBy('user_id')->get();
					foreach ($userBitTransactionResult as $row) {
						$payment_gross = $row->total_amount;
						$total_win_amount = 0;
						if ($payment_gross != '') {
							if ($payment_gross > 0) {
								if ($calculation_type == 1) {
									$total_win_amount = $payment_gross * $calculation_value;
								} elseif ($calculation_type == 2) {
									$percent = $calculation_value;
									$discount_value = ($payment_gross / 100) * $percent;
									$total_win_amount = $payment_gross + $discount_value;
								}
							}
						}

						$play_type_result = Play_type::where('id', $type_id)->first();
						$play_type_title = isset($play_type_result->name) ? $play_type_result->name : '';

						$description = 'Won ' . $played_game_title . ' ' . $bazi_title . ' ' . $play_type_title . ' ' . $number . '(' . $total_win_amount . ')';
						//print_r($description);exit;

						$user_id = $row->user_id;
						$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
						$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
						$wallet_amount = 0;
						$wallet_amount += $balance_gross;
						$wallet_amount += $total_win_amount;
						Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));

						$transactionsData = array(
							'user_id' => $user_id,
							'description' => $description,
							'amount' => $total_win_amount,
							'available_bal' => $wallet_amount,
							'type' => 1,
							'status' => 'paid',
							'is_transaction_view' => 1,
							'date_slot' => date('Y-m-d')
						);

						Transactions::create($transactionsData);

					}
					$check = Common::getSingelData($where = ['period' => $period_id], $table = 'win_period', $data = ['id', 'win_number'], 'id', 'ASC');
					if (!empty($check)) {
						$userBitTransactionResult = $this->userBitTransactionModel->select('*', DB::raw('SUM(amount) as total_amount'))->where('period_id', $period_id)->where('number', $check->win_number)->where('status', 1)->groupBy('user_id')->get();
						foreach ($userBitTransactionResult as $row) {
							$payment_gross = $row->total_amount;
							$total_win_amount = 0;
							if ($payment_gross != '') {
								if ($payment_gross > 0) {
									if ($calculation_type == 1) {
										$total_win_amount = $payment_gross * $calculation_value;
									} elseif ($calculation_type == 2) {
										$percent = $calculation_value;
										$discount_value = ($payment_gross / 100) * $percent;
										$total_win_amount = $payment_gross + $discount_value;
									}
								}
							}
							$user_id = $row->user_id;
							$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
							$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
							$wallet_amount = 0;
							$wallet_amount += $balance_gross;
							$wallet_amount -= $total_win_amount;
							Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));


							$transactionsData = array(
								'user_id' => $user_id,
								'description' => 'Amount Debited',
								'amount' => $total_win_amount,
								'available_bal' => $wallet_amount,
								'type' => 1,
								'is_transaction_view' => 1,
								'date_slot' => date('Y-m-d')
							);
							Transactions::create($transactionsData);



						}
						$win_data = array(
							'win_number' => $number,
							'updated_at' => date('Y-m-d H:i:s')
						);
						Common::updateData($table = "win_period", "period", $period_id, $win_data);
					} else {

						if ($type_id == '3') {
							$cctime_slot_id = DB::table('time_slots')->where('id', '<', $time_slot_id)->max('id');
							$ccgame_id = DB::table('game_type')->where('id', '<', $game_id)->max('id');
							$win_data = array(
								'period' => $period_id,
								'category_id' => $category_id,
								'game_id' => $ccgame_id,
								'play_type' => $type_id,
								'date_slot' => $date_slot,
								'time_slot_id' => $cctime_slot_id,
								'win_number' => $number,
								'created_at' => date('Y-m-d H:i:s')
							);
							Common::insertData($table = "win_period", $win_data);
						} else {
							$win_data = array(
								'period' => $period_id,
								'category_id' => $category_id,
								'game_id' => $game_id,
								'play_type' => $type_id,
								'date_slot' => $date_slot,
								'time_slot_id' => $time_slot_id,
								'win_number' => $number,
								'created_at' => date('Y-m-d H:i:s')
							);
							Common::insertData($table = "win_period", $win_data);
						}


					}
					$this->userBitTransactionModel::where('period_id', $period_id)->update(['win_status' => 'loss']);
					$this->userBitTransactionModel::where('period_id', $period_id)->where('number', $number)->update(['win_status' => 'win']);
				}
			}


			$game = Game_type::where('id', $game_id)->first();
			$category = Category::where('id', $category_id)->first();
			$title = $category->name . ' ' . $game->name;


			$title = strtoupper($title);
			$content = '';

			if ($win_number[2] != '') {
				$content = " Single ~ " . $win_number[0] . " Patti ~ " . $win_number[1] . " Jodi ~ " . $win_number[2] . " CP ~ " . $win_number[3];
			} else {
				$content = " Single ~ " . $win_number[0] . " Patti ~ " . $win_number[1] . " CP ~ " . $win_number[3];
			}

			$notification = AppNotifications::create([
				'title' => $title,
				'message' => $content,
				'type' => 'common',
			]);


			$this->sendNotificationToAll($title, $content);
		}
		Session::flash('success', 'Successfully Saved data.');
		return redirect::back();
	}

	public function prevTimeSlotResult($id)
	{
		$title = 'Result';
		$breadcumbs = 'Result';
		$category_info = Category::where('id', $id)->first();
		$active = isset($category_info->slug) ? $category_info->slug : 'result';
		$category_id = $id;
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cat_id'] = $id;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$result = Time_slots::getPrevTimeSlotResult($param);
		$type_list = Play_type::get();

		$totalSlot = isset($result[0]['time_slot']) ? count($result[0]['time_slot']) : '0';

		//echo '<pre>';print_r($result);exit;
		return view('admin.set_result/prev_index', compact('title', 'active', 'breadcumbs', 'result', 'type_list', 'category_id'));
	}
	public function save_prev_result_request(Request $request)
	{

		$category_id = $request->input('category_id');
		$win_number = $request->input('win_number');
		$slot_period = $request->input('period_id');
		$type = $request->input('type_id');
		$game_id = $request->input('game_id');
		$date_slot = $request->input('date_slot');
		$time_slot_id = $request->input('time_slot_id');
		$time_id = $request->input('time_id');
		//echo '<pre>';print_r($_POST);exit;
		/*$validator = Validator::make($request->all(), [
			"win_number.*"=> "required|string|min:0"
		]);*/
		$validator = Validator::make($request->all(), [
			'category_id' => 'required',
			'time_slot_id' => 'required',
		]);

		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {

			$baziResult = Game_type::where('id', $game_id)->where('category_id', $category_id)->first();
			$bazi_title = isset($baziResult->name) ? $baziResult->name : '';
			$categotyResult = Category::where('id', $category_id)->first();
			$played_game_title = isset($categotyResult->name) ? $categotyResult->name : '';

			$description = 'Won ' . $played_game_title . ' ' . $bazi_title;




			//echo '<pre>';print_r($description);exit;
			for ($i = 0; count($slot_period) > $i; $i++) {
				$period_id = $slot_period[$i];
				$type_id = $type[$i];
				$number = $win_number[$i];

				$check = Common::getSingelData($where = ['period' => $period_id], $table = 'win_period', $data = ['id', 'win_number'], 'id', 'ASC');
				if (!empty($check)) {
					$win_data = array(
						'win_number' => $number,
						'updated_at' => date('Y-m-d H:i:s')
					);
					Common::updateData($table = "win_period", "period", $period_id, $win_data);
				} else {

					if ($type_id == '3') {
						$cctime_slot_id = DB::table('time_slots')->where('id', '<', $time_slot_id)->max('id');
						$ccgame_id = DB::table('game_type')->where('id', '<', $game_id)->max('id');
						$win_data = array(
							'period' => $period_id,
							'category_id' => $category_id,
							'game_id' => $ccgame_id,
							'play_type' => $type_id,
							'date_slot' => $date_slot,
							'time_slot_id' => $cctime_slot_id,
							'win_number' => $number,
							'created_at' => $date_slot . ' ' . date('H:i:s')
						);

						//echo '<pre>';print_r($win_data);exit;
						Common::insertData($table = "win_period", $win_data);
					} else {
						$win_data = array(
							'period' => $period_id,
							'category_id' => $category_id,
							'game_id' => $game_id,
							'play_type' => $type_id,
							'date_slot' => $date_slot,
							'time_slot_id' => $time_slot_id,
							'win_number' => $number,
							'created_at' => $date_slot . ' ' . date('H:i:s')
						);
						//echo '<pre>';print_r($win_data);exit;
						Common::insertData($table = "win_period", $win_data);
					}


				}
			}
		}


		Session::flash('success', 'Successfully Saved data.');
		return redirect::back();
	}

}