<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Input;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Session;
use Carbon;
use Auth;
use Image;
use DB;
use Helpers;
use Hash;
use Config;
use App\User;
use App\Common;
use App\Payments;
use App\Withdraw_request;
use App\Balance_request;
use App\Win_price_calculation;
use App\User_bit_transaction;
use App\Transactions;
use App\Category;
use App\Game_type;
use Google_Client;

class PaymentController extends Controller
{
	protected $paymentsModel;
	protected $withdrawRequestModel;
	protected $balanceRequestModel;
	protected $userTransactionsModel;
	protected $client;
	public function __construct()
	{
		$this->paymentsModel = new Payments;
		$this->withdrawRequestModel = new Withdraw_request;
		$this->balanceRequestModel = new Balance_request;
		$this->userTransactionsModel = new Transactions;

		$credentialsFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json';
		$this->client = new Google_Client();
		$this->client->setAuthConfig($credentialsFilePath);
		$this->client->addScope('https://www.googleapis.com/auth/firebase.messaging');
		$this->client->refreshTokenWithAssertion();

		Helpers::set_elescope_entries();
	}

	/*+++++++++++++++++++++++ Notification +++++++++++++++++++++++++++++++++++*/

	public function sendNotificationToSingle($userId, $title, $content)
	{
		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json'; // Path to service account file

		$user = User::find($userId);
		$device_token = $user->fcm_token ?? '';

		if ($device_token != '') {
			// Initialize Firebase with the service account credentials
			$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
			$messaging = $factory->createMessaging();

			$message = CloudMessage::withTarget('token', $device_token)
				->withNotification([
						'title' => strtoupper($title),
						'body' => $content,
					])
				->withData([
						'title' => strtoupper($title),
						'body' => $content,
						'notification_foreground' => 'true',
						'notification_status' => 'true',
						'show_status' => 'true',
						'head_title' => 'success',
						'is_notification' => 'true',
						'priceRefresh' => '1'
					]);

			//echo '<pre>';print_r($message);exit;
			$messaging->send($message);
		}

		return true;
	}

	/*+++++++++++++++++++++++End+++++++++++++++++++++++++++++++++++*/

	public function profitableUserReport()
	{
		$title = "User List";
		$breadcumbs = "User List";
		$active = "profitable_user";

		$balanceData = [];
		$balance_request_result = Balance_request::select('user_id', DB::raw('SUM(amount) as totalAmount'))->where('status', 'completed')->groupBy('user_id')->get();
		foreach ($balance_request_result as $row) {
			$balanceData[$row['user_id']] = $row['totalAmount'];
		}

		$withdrawData = [];
		$withdrawlUserNameData = [];
		$withdrawlUserNumberData = [];
		$withdraw_request_result = Withdraw_request::select('user_id', DB::raw('SUM(amount) as totalAmount'))->where('status', 'completed')->groupBy('user_id')->get();
		foreach ($withdraw_request_result as $row) {
			$withdrawData[$row['user_id']] = $row['totalAmount'];
			$withdrawlUserNameData[$row['user_id']] = $row->getUser->name;
			$withdrawlUserNumberData[$row['user_id']] = $row->getUser->phone;
		}

		//echo '<pre>';print_r($withdrawlUserNumberData);exit;

		// Merge both arrays user_id-wise
		$mergedData = [];
		$userIds = array_unique(array_merge(array_keys($balanceData), array_keys($withdrawData)));

		foreach ($userIds as $userId) {
			$total_balance = $balanceData[$userId] ?? 0;
			$total_withdraw = $withdrawData[$userId] ?? 0;
			$total_profit = $total_withdraw - $total_balance;

			if ($total_withdraw > $total_balance) {
				$mergedData[] = [
					'user_id' => $userId,
					'customer_name' => $withdrawlUserNameData[$userId] ?? '',
					'customer_phone' => $withdrawlUserNumberData[$userId] ?? '',
					'total_balance' => $total_balance,
					'total_withdraw' => $total_withdraw,
					'total_profit' => $total_profit,
				];
			}
		}



		// echo '<pre>';
		// print_r($mergedData);
		// exit;

		return view('admin.profitable_user', compact('title', 'active', 'breadcumbs', 'mergedData'));
	}

	public function withdraw_request()
	{
		$title = "Withdraw List";
		$breadcumbs = "Withdraw List";
		$active = "withdraw_request";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		//$withdraw_request_list = $this->withdrawRequestModel->get_data2($param);
		$withdraw_request_list = $this->withdrawRequestModel->orderby('id', 'DESC')->offset(0)->limit(500)->get();
		//echo '<pre>';print_r($withdraw_request_list);exit;
		return view('admin.withdraw_request2', compact('title', 'active', 'breadcumbs', 'withdraw_request_list'));

	}

	public function withdraw_request2()
	{
		$title = "Withdraw List";
		$breadcumbs = "Withdraw List";
		$active = "withdraw_request";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$withdraw_request_list = $this->withdrawRequestModel->get_data($param);
		//echo '<pre>';print_r($withdraw_request_list);exit;
		return view('admin.withdraw_request', compact('title', 'active', 'breadcumbs', 'withdraw_request_list'));
	}
	public function withdraw_accept_request()
	{
		$withdraw_id = request()->input('id');
		if ($withdraw_id != null) {
			$withdraw_result = $this->withdrawRequestModel->where('id', $withdraw_id)->first();
			$user_id = isset($withdraw_result->user_id) ? $withdraw_result->user_id : '';
			$amount = isset($withdraw_result->amount) ? $withdraw_result->amount : '';
			Common::updateData($table = "withdraw_request", "id", $withdraw_id, array('status' => 'completed', 'updated_at' => date('Y-m-d H:i:s')));
			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Withdraw successfully',
				'amount' => $amount,
				'type' => 4,
				'status' => 'paid',
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);

			$title = strtoupper('Withdraw successfully');
			$content = 'Amount-' . $amount . " .Tap to refresh.";

			$this->sendNotificationToSingle($user_id, $title, $content);

			Session::flash('success', 'Paid successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function withdraw_reject_request()
	{
		$withdraw_id = request()->input('id');
		if ($withdraw_id != null) {
			$withdraw_result = $this->withdrawRequestModel->where('id', $withdraw_id)->first();
			$user_id = isset($withdraw_result->user_id) ? $withdraw_result->user_id : '';
			$amount = isset($withdraw_result->amount) ? $withdraw_result->amount : '';

			$payment_status = isset($withdraw_result->status) ? $withdraw_result->status : '';

			if ($payment_status == 'rejected') {
				Session::flash('success', 'Already rejected Withdraw request.');
				return redirect::back();
			}

			$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount += $amount;
			Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));

			Common::updateData($table = "withdraw_request", "id", $withdraw_id, array('status' => 'rejected', 'updated_at' => date('Y-m-d H:i:s')));
			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Withdraw request rejected',
				'amount' => $amount,
				'type' => 4,
				'status' => 'cancel',
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);


			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Amount Created',
				'amount' => $amount,
				'available_bal' => $wallet_amount,
				'type' => 3,
				'status' => 'paid',
				'is_transaction_view' => 1,
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);

			$title = strtoupper('Withdraw request rejected');
			$content = 'Amount-' . $amount . " .Tap to refresh.";

			$this->sendNotificationToSingle($user_id, $title, $content);

			Session::flash('success', 'Withdraw request rejected successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}


	public function balance_request_test()
	{
		$title = "Transfer List";
		$breadcumbs = "Transfer List";
		$active = "balance_request";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request = $this->balanceRequestModel->get_data($param);

		//echo '<pre>';print_r($balance_request_list);exit;

		$meta_data['pagination'] = array('per_page' => $per_page, 'cur_page' => $cur_page, 'total_data' => $balance_request['total_orders'], 'page_url' => url('administrator/balance_request_test'), 'additional_params' => '');

		//echo '<pre>';print_r($meta_data);exit;
		return view('admin.balance_request_test', compact('title', 'active', 'breadcumbs', 'meta_data', 'balance_request'));
	}


	public function balance_request()
	{
		$title = "Transfer List";
		$breadcumbs = "Transfer List";
		$active = "balance_request";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_data($param);
		//echo '<pre>';print_r($balance_request_list);exit;
		return view('admin.balance_request', compact('title', 'active', 'breadcumbs', 'balance_request_list'));
	}

	public function upi_balance_request()
	{
		$title = "Transfer List";
		$breadcumbs = "Transfer List";
		$active = "upi_balance_request";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_upi_data($param);
		//echo '<pre>';print_r($balance_request_list);exit;
		return view('admin.balance_upi_request', compact('title', 'active', 'breadcumbs', 'balance_request_list'));
	}

	public function balance_accept_request()
	{
		$balance_id = request()->input('id');
		if ($balance_id != null) {
			$payment_data = Common::getSingelData($where = ['id' => $balance_id], $table = 'balance_request', $data = ['amount', 'user_id', 'status'], 'id', 'ASC');
			$payment_gross = isset($payment_data->amount) ? $payment_data->amount : '0';
			$payment_status = isset($payment_data->status) ? $payment_data->status : '';

			//print_r($payment_status);exit;

			if ($payment_status == 'completed') {
				Session::flash('success', 'Already Balance added successfully.');
				return redirect::back();
			}
			$user_id = isset($payment_data->user_id) ? $payment_data->user_id : '0';
			$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount += $payment_gross;
			Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));
			Common::updateData($table = "balance_request", "id", $balance_id, array('status' => 'completed', 'updated_at' => date('Y-m-d H:i:s')));
			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Amount Credited',
				'amount' => $payment_gross,
				'available_bal' => $wallet_amount,
				'is_transaction_view' => 1,
				'type' => 3,
				'status' => 'paid',
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);


			$title = strtoupper('Balance added successfully');
			$content = 'Amount-' . $payment_gross . " .Tap to refresh.";

			$this->sendNotificationToSingle($user_id, $title, $content);

			//echo '<pre>';print_r($result);exit;

			Session::flash('success', 'Balance added successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function balance_reject_request()
	{
		$balance_id = request()->input('id');
		if ($balance_id != null) {
			$payment_data = Common::getSingelData($where = ['id' => $balance_id], $table = 'balance_request', $data = ['amount', 'user_id'], 'id', 'ASC');
			$payment_gross = isset($payment_data->amount) ? $payment_data->amount : '0';
			//$offer_data 	= Common::getSingelData($where=['price'=>$payment_gross],$table='discount',$data=['discount_amount'],'id','ASC');
			//$offer_gross 	= isset($offer_data->discount_amount)? $offer_data->discount_amount:'0';
			$user_id = isset($payment_data->user_id) ? $payment_data->user_id : '0';
			$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			//$wallet_amount+= $payment_gross;
			//$wallet_amount+= $offer_gross;
			//print_r($wallet_amount);exit;
			//Common::updateData($table="user_wallet", "user_id", $user_id, array('balance'=>$wallet_amount,'updated_at'=>date('Y-m-d H:i:s')));
			Common::updateData($table = "balance_request", "id", $balance_id, array('status' => 'rejected', 'updated_at' => date('Y-m-d H:i:s')));
			$transactionsData = array(
				'user_id' => $user_id,
				'description' => 'Balance rejected',
				'amount' => $payment_gross,
				'available_bal' => $wallet_amount,
				'type' => 3,
				'status' => 'rejected',
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);

			$title = strtoupper('Balance rejected');
			$content = 'Amount-' . $payment_gross . " .Tap to refresh.";

			$this->sendNotificationToSingle($user_id, $title, $content);

			Session::flash('success', 'Balance rejected successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function payment_cancel_request()
	{
		$title = "";
		$breadcumbs = "Recharge Account";
		$active = "payment";
		return view('admin.payment_cancel', compact('title', 'active', 'breadcumbs'));
	}
	public function payment_success_request()
	{
		$title = "";
		$breadcumbs = "Payment method";
		$active = "payment";
		$payment_unique_id = Session::get('payment_unique_id');
		if ($payment_unique_id != '') {
			$payment_data = Common::getSingelData($where = ['unique_id' => $payment_unique_id], $table = 'payments', $data = ['payment_gross'], 'payment_id', 'ASC');
			$payment_gross = isset($payment_data->payment_gross) ? $payment_data->payment_gross : '0';

			Common::updateData($table = "payments", "unique_id", $payment_unique_id, array('status' => 'paid', 'updated_at' => date('Y-m-d H:i:s')));
			$user_id = Session::get('adminId');
			$wallet_data = Common::getSingelData($where = ['user_id' => $user_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount += $payment_gross;
			Common::updateData($table = "user_wallet", "user_id", $user_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));
		}
		return redirect('administrator/pay-success');
	}
	public function payment_success_view()
	{
		$title = "Payment method";
		$breadcumbs = "Payment method";
		$active = "payment";
		return view('admin.payment_success', compact('title', 'active', 'breadcumbs'));
	}
	public function balance_request_report()
	{
		$title = "Transfer List";
		$breadcumbs = "Transfer List";
		$active = "balance_request_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$param['fromdate'] = request()->input('fromdate');
		$param['todate'] = request()->input('todate');
		$param['status'] = 'completed';
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_report_data($param);

		$totalAmount = 0;
		foreach ($balance_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($totalAmount);exit;
		return view('admin.balance_request_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'todate', 'totalAmount', 'balance_request_list'));
	}
	public function withdraw_request_report()
	{
		$title = "Withdraw List";
		$breadcumbs = "Withdraw List";
		$active = "withdraw_request_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$param['fromdate'] = request()->input('fromdate');
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$withdraw_request_list = $this->withdrawRequestModel->get_report_data($param);
		$totalAmount = 0;
		foreach ($withdraw_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($withdraw_request_list);exit;
		return view('admin.withdraw_request_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'totalAmount', 'withdraw_request_list'));
	}

	public function upi_request_report()
	{
		$title = "UPI Transfer List";
		$breadcumbs = "UPI Transfer List";
		$active = "upi_request_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$param['fromdate'] = request()->input('fromdate');
		$param['todate'] = request()->input('todate');
		$param['status'] = 'completed';
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_upi_report_data($param);

		$totalAmount = 0;
		foreach ($balance_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($totalAmount);exit;
		return view('admin.upi_request_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'todate', 'totalAmount', 'balance_request_list'));
	}

	public function upi_request_details_report()
	{
		$title = "UPI Transfer List";
		$breadcumbs = "UPI Transfer List";
		$active = "upi_request_details_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$param['fromdate'] = request()->input('fromdate');
		$param['todate'] = request()->input('todate');
		$param['status'] = 'completed';
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_upi_report_data($param);

		$totalAmount = 0;
		foreach ($balance_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($totalAmount);exit;
		return view('admin.upi_request_details_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'todate', 'totalAmount', 'balance_request_list'));
	}

	public function transferReport()
	{
		$title = "Transfer List";
		$breadcumbs = "Transfer List";
		$active = "transfer_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');
		$param['fromdate'] = request()->input('fromdate');
		$param['todate'] = request()->input('todate');
		$param['status'] = 'completed';
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$balance_request_list = $this->balanceRequestModel->get_transfer_report($param);

		$totalAmount = 0;
		foreach ($balance_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($balance_request_list);exit;
		return view('admin.transfer_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'todate', 'totalAmount', 'balance_request_list'));
	}

	public function withdrawReport()
	{
		$title = "Withdraw List";
		$breadcumbs = "Withdraw List";
		$active = "withdraw_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('fromdate');
		$param['fromdate'] = request()->input('fromdate');
		$todate = request()->input('todate');
		$param['todate'] = request()->input('todate');
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$withdraw_request_list = $this->withdrawRequestModel->get_transfer_report($param);
		$totalAmount = 0;
		foreach ($withdraw_request_list['records'] as $row) {
			$totalAmount += $row->amount;
		}
		//echo '<pre>';print_r($withdraw_request_list);exit;
		return view('admin.withdraw_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'todate', 'totalAmount', 'withdraw_request_list'));
	}

	public function transactions_history_report()
	{
		$title = "Transactions history";
		$breadcumbs = "Transactions history";
		$active = "transactions_history_report";
		$meta_data = array();
		$user_id = request()->input('user_id');
		$number = request()->input('number');
		$param = array();
		$param['user_id'] = '';
		$param['number'] = $number;
		$transactions_request_list = Transactions::get_transaction_history($param);

		$total_withdraw = 0;
		$total_diposit = 0;

		if ($number != '') {
			$userInfo = User::where('phone', $number)->first();
			$user_id = isset($userInfo->id) ? $userInfo->id : '';
			if ($user_id != '') {
				$total_withdraw = Withdraw_request::where('user_id', $user_id)->where('status', 'completed')->sum('amount');
				$total_diposit = Balance_request::where('user_id', $user_id)->where('status', 'completed')->sum('amount');
			}
		}

		//echo '<pre>';print_r($transactions_request_list);exit;


		return view('admin.transactions_history', compact('title', 'active', 'breadcumbs', 'transactions_request_list', 'total_withdraw', 'total_diposit'));
	}

	public function suspected_report()
	{
		$title = "Suspected List";
		$breadcumbs = "Suspected List";
		$active = "suspected_report";
		$meta_data = array();
		$fromdate = request()->input('fromdate');
		$todate = request()->input('todate');

		$result = [];


		if ($fromdate != '' && $todate != '') {
			$fromdate = $fromdate . ' 00:00:00';
			$todate = $todate . ' 23:59:59';

			$withdraw_result = Withdraw_request::where('status', 'completed')->where('created_at', '>=', $fromdate)->where('created_at', '<=', $todate)->groupBy('user_id')->selectRaw('*, sum(amount) as sum')->orderby('created_at', 'DESC')->orderby('id', 'DESC')->get();

			//echo '<pre>';print_r($withdraw_result);exit;

			foreach ($withdraw_result as $row) {
				$total_withdraw = $row->sum;
				$total_addmoney = Balance_request::where('status', 'completed')->where('created_at', '>=', $fromdate)->where('created_at', '<=', $todate)->where('user_id', $row->user_id)->sum('amount');
				if ($total_withdraw > $total_addmoney) {
					$total_profit = $total_withdraw - $total_addmoney;
					$result[] = array(
						'user_id' => $row->user_id,
						'customer_name' => $row->getUser->name,
						'customer_phone' => $row->getUser->phone,
						'total_withdraw' => $total_withdraw,
						'total_addmoney' => $total_addmoney,
						'total_profit' => $total_profit,
					);
				}
			}

			//echo '<pre>';print_r($result);exit;

		} else {
			$withdraw_result = Withdraw_request::where('status', 'completed')->groupBy('user_id')->selectRaw('*, sum(amount) as sum')->orderby('created_at', 'DESC')->orderby('id', 'DESC')->get();

			foreach ($withdraw_result as $row) {
				$total_withdraw = $row->sum;
				$total_addmoney = Balance_request::where('status', 'completed')->where('user_id', $row->user_id)->sum('amount');
				if ($total_withdraw > $total_addmoney) {
					$total_profit = $total_withdraw - $total_addmoney;
					$result[] = array(
						'user_id' => $row->user_id,
						'customer_name' => $row->getUser->name,
						'customer_phone' => $row->getUser->phone,
						'total_withdraw' => $total_withdraw,
						'total_addmoney' => $total_addmoney,
						'total_profit' => $total_profit,
					);
				}
			}
		}




		//echo '<pre>';print_r($result);exit;

		return view('admin.suspected_report', compact('title', 'active', 'breadcumbs', 'result', 'fromdate', 'todate'));
	}

	public function gameReport()
	{
		$title = "Game Report";
		$breadcumbs = "Game Report";
		$active = "game_report";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$fromdate = request()->input('date');
		$cat_id = request()->input('cat_id');
		$category_list = Category::where('status', 1)->get();


		$game_report_result = [];

		$gross_total_played_amount = 0;
		$gross_total_played_win_amount = 0;
		$gross_total_win_amount = 0;

		if ($cat_id != '' && $fromdate != '') {
			$single_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 1)->first();
			$patti_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 2)->first();
			$jodi_price_calculation = Win_price_calculation::where('category_id', $cat_id)->where('play_type', 3)->first();

			$single_calculation_value = isset($single_price_calculation->value) ? $single_price_calculation->value : '9.5';
			$patti_calculation_value = isset($patti_price_calculation->value) ? $patti_price_calculation->value : '120';
			$jodi_calculation_value = isset($jodi_price_calculation->value) ? $jodi_price_calculation->value : '80';

			//echo 'single_calculation_value'.$single_calculation_value.'-patti_calculation_value-'.$patti_calculation_value.'-jodi_calculation_value-'.$jodi_calculation_value;exit;




			$game_result = Game_type::where('category_id', $cat_id)->where('status', 1)->orderBy('id', 'asc')->get();
			foreach ($game_result as $row) {
				$total_played_win_amount = 0;
				$total_win_amount = 0;
				$played_amount = User_bit_transaction::where('category_id', $cat_id)->where('date_slot', $fromdate)->where('time_slot_id', $row->time_slot_id)->orderBy('id', 'desc')->sum('amount');
				$gross_total_played_amount += $played_amount;

				$single_played_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('date_slot', $fromdate)->where('time_slot_id', $row->time_slot_id)->where('play_type', 1)->where('win_status', 'win')->sum('amount');
				$total_played_win_amount += $single_played_win_amount;

				$patti_played_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('date_slot', $fromdate)->where('time_slot_id', $row->time_slot_id)->where('play_type', 2)->where('win_status', 'win')->sum('amount');
				$total_played_win_amount += $patti_played_win_amount;

				$jodi_played_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('date_slot', $fromdate)->where('time_slot_id', $row->time_slot_id)->where('play_type', 3)->where('win_status', 'win')->sum('amount');
				$total_played_win_amount += $jodi_played_win_amount;

				$cp_played_win_amount = User_bit_transaction::where('category_id', $cat_id)->where('date_slot', $fromdate)->where('time_slot_id', $row->time_slot_id)->where('play_type', 4)->where('win_status', 'win')->sum('amount');
				$total_played_win_amount += $cp_played_win_amount;

				$gross_total_played_win_amount += $total_played_win_amount;

				$single_total_win_amount = 0;
				$patti_total_win_amount = 0;
				$jodi_total_win_amount = 0;
				$cp_total_win_amount = 0;

				if ($single_played_win_amount > 0) {
					$single_total_win_amount = $single_played_win_amount * $single_calculation_value;
					$total_win_amount += $single_total_win_amount;
				}
				if ($patti_played_win_amount > 0) {
					$patti_total_win_amount = $patti_played_win_amount * $patti_calculation_value;
					$total_win_amount += $patti_total_win_amount;
				}
				if ($jodi_played_win_amount > 0) {
					$jodi_total_win_amount = $jodi_played_win_amount * $jodi_calculation_value;
					$total_win_amount += $jodi_total_win_amount;
				}
				if ($cp_played_win_amount > 0) {
					$cp_total_win_amount = $cp_played_win_amount * $patti_calculation_value;
					$total_win_amount += $cp_total_win_amount;
				}

				$gross_total_win_amount += $total_win_amount;






				//echo 'cat_id'.$cat_id.'-date_slot-'.$fromdate.'-time_slot_id-'.$row->time_slot_id;exit;;


				$from_time = isset($row->getTimeslots->from_time) ? $row->getTimeslots->from_time : '';
				$to_time = isset($row->getTimeslots->to_time) ? $row->getTimeslots->to_time : '-';

				if ($from_time != '') {
					//echo '<pre>';print_r($user_bit_transaction_result);exit;
					$game_report_result[] = array(
						'cat_name' => $row->getCategory->name,
						'name' => $row->name,
						'time_slot' => $from_time . '-' . $to_time,
						'played_amount' => $played_amount,
						'total_played_win_amount' => $total_played_win_amount,
						'total_win_amount' => $total_win_amount,
						'played_win_result' => array(
							'single_played_win_amount' => $single_played_win_amount,
							'patti_played_win_amount' => $patti_played_win_amount,
							'jodi_played_win_amount' => $jodi_played_win_amount,
							'cp_played_win_amount' => $cp_played_win_amount
						),
						'total_win_result' => array(
							'single_total_win_amount' => $single_total_win_amount,
							'patti_total_win_amount' => $patti_total_win_amount,
							'jodi_total_win_amount' => $jodi_total_win_amount,
							'cp_total_win_amount' => $cp_total_win_amount
						),
					);
				}

				//echo '<pre>';print_r($game_report_result);exit;	
			}
		}



		//echo '<pre>';print_r($game_report_result);exit;
		return view('admin.game_report', compact('title', 'active', 'breadcumbs', 'fromdate', 'category_list', 'game_report_result', 'gross_total_played_amount', 'gross_total_played_win_amount', 'gross_total_win_amount'));
	}
}