<?php

namespace App\Http\Controllers;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;
use App\User;
use App\Common;
use App\Avality_time_date_slots;
use App\Time_slots;
use App\Play_type;
use App\Game_type;
use App\News_board;
use App\User_bit_transaction;
use App\Discount;
use App\User_discount;
use App\Balance_request;
use App\Withdraw_request;
use App\Transactions;
use App\News;
use App\Category;
use App\Slider;
use App\User_wallet;
use App\Win_price_calculation;

use Input;
use Session;
use Carbon;
use Image;
use DB;
use Helpers;
use Hash;
use Config;


class AjaxController extends Controller {

	public function checkEmailExist(){
		$to      = 'sdev75661@gmail.com';
    	$subject = 'the subject';
    	$message = 'hello';
		$randomString = '123456789';
		$resetPasswordEmail = [
			'to' 		=> $to,
            'subject' 	=> $subject,
			'userName' 	=> $to,
            'token' 	=> $randomString,
            'view' 		=> 'mail_templates/reset_password_tempalte',
       ];
	   $view = view($resetPasswordEmail['view'], $resetPasswordEmail)->render();
	   print_r($resetPasswordEmail);
	  Helpers::SendEmail($resetPasswordEmail);
	  
	  
	  $headers = 'From: test@aqualeafitsol.com'       . "\r\n" .
                 'Reply-To: test@aqualeafitsol.com' . "\r\n" .
                 'X-Mailer: PHP/' . phpversion();

    //mail($to, $subject, $message, $headers);exit;

	}
	public function checkphoneExist(){
		$type = request()->input('type');
		
		
	}
	
	public function ajaxpost(Request $request) {
		$action = $request->input('action');
		$this->{'ajaxpost_' . $action}($request);
	}
	
	public function ajaxpost_get_slot($request) {
		if (request()->isMethod('post')) {
			$category_id = request()->input('category_id');
			$result = Common::listingData(['category_id' => $category_id], 'time_slots', ['*'], 'id', 'ASC');
			$html='';
			if(count($result)>0){
				$html .='<option value="">--Select Time slot--</option>';
				foreach($result as $row){
					$html .='<option value="'.$row->id.'">'.$row->from_time.'-'.$row->to_time.'</option>';
				}
			}
			
			echo $html;exit;
		}
	}

	public function ajaxpost_delete_userBids($request) {
		if (request()->isMethod('post')) {

			$bidIds = request()->input('bidIds');

			for($i=0;count($bidIds)>$i;$i++){
				$bet_id = $bidIds[$i];

				$check = Common::getSingelData($where=['id'=>$bet_id],$table='user_bit_transaction',$data=['*'],'id','ASC');
				$bid_number	= isset($check->number)? $check->number:'';
				$user_id	= isset($check->user_id)? $check->user_id:'';
				$amount		= isset($check->amount)? $check->amount:'';
				
				$wallet_data 	= Common::getSingelData($where=['user_id'=>$user_id],$table='user_wallet',$data=['balance'],'id','ASC');
				$balance_gross 	= isset($wallet_data->balance)? $wallet_data->balance:'0';
				$wallet_amount = 0;
				$wallet_amount+= $balance_gross;
				$wallet_amount+= $amount;

				//print_r($wallet_data);exit;
				
				Common::updateData($table="user_wallet", "user_id", $user_id, array('balance'=>$wallet_amount,'updated_at'=>date('Y-m-d H:i:s')));
				Common::deleteData('user_bit_transaction','id',$bet_id);

				$transactionsData=array(
					'user_id'   	=> $user_id,
					'description'   => 'Cancel bid request, no.' .$bid_number,
					'amount'		=> $amount,
					'type'			=> 1,
					'status'		=> 'paid',
					'is_transaction_view'	=> 1,
					'date_slot'		=> date('Y-m-d')
				);
				Transactions::create($transactionsData);
	
	
				$transactionsData=array(
					'user_id'   	=> $user_id,
					'description'   => 'Amount Created',
					'amount'		=> $amount,
					'available_bal'	=> $wallet_amount,
					'type'			=> 4,
					'status'		=> 'paid',
					'is_transaction_view'	=> 1,
					'date_slot'		=> date('Y-m-d')
				);
				Transactions::create($transactionsData);

			}
			
			
			// $result = Common::listingData(['category_id' => $category_id], 'time_slots', ['*'], 'id', 'ASC');
			// $html='';
			// if(count($result)>0){
			// 	$html .='<option value="">--Select Time slot--</option>';
			// 	foreach($result as $row){
			// 		$html .='<option value="'.$row->id.'">'.$row->from_time.'-'.$row->to_time.'</option>';
			// 	}
			// }
			
			//echo $html;exit;
		}
		$return_data['status']	= 1;
		echo json_encode($return_data);
	}





	
	public function ajaxpost_get_account($request) {
		if (request()->isMethod('post')) {
			$mobile = request()->input('mobile');
			$result = User::where('phone',$mobile)->first();
			$return_data=[];
			if(isset($result)){
				$wallet_data 	= Common::getSingelData($where=['user_id'=>$result->id],$table='user_wallet',$data=['balance'],'id','ASC');
				$balance_gross 	= isset($wallet_data->balance)? $wallet_data->balance:'0';
				$wallet_amount = 0;
				$wallet_amount+= $balance_gross;
				
				$return_data['status'] 			= 1;
				$return_data['customer_name']	= $result->name;
				$return_data['customer_id']		= $result->id;
				$return_data['current_amount']	= $wallet_amount;
			}else{
				$return_data['status']	= 0;
			}
			echo json_encode($return_data);
		}
	}
	
	public function ajaxpost_get_transaction_history($request) {
		if (request()->isMethod('post')) {
			$user_id = request()->input('user_id');

			$withdraw_request_result 	= Withdraw_request::where('user_id',$user_id)->where('status','completed')->orderby('id', 'DESC')->offset(0)->limit(10)->get();
			$balance_request_result 	= Balance_request::where('user_id',$user_id)->where('status','completed')->orderby('id', 'DESC')->offset(0)->limit(10)->get();

			$total_addmoney	= Balance_request::where('status','completed')->where('user_id',$user_id)->sum('amount');
			$total_withdraw	= Withdraw_request::where('status','completed')->where('user_id',$user_id)->sum('amount');
			
			$user_wallet_result	= User_wallet::where('user_id',$user_id)->first();
			$user_wallet		= isset($user_wallet_result->balance)?$user_wallet_result->balance:0;
			
			$total_profit	= (($total_withdraw + $user_wallet) - $total_addmoney);

			$return_data=[];
			$withdraw_html='';
			$deposite_html='';
			$report_html='';
			
			$w=1;foreach($withdraw_request_result as $wRow){
				$withdraw_html .='<tr><td>'.$w.'</td><td>'.$wRow->amount.'</td><td>'.$wRow->payment_method.'</td><td>'.\Carbon\Carbon::parse($wRow->created_at)->format('M d Y h:i a').'</td></tr>';
			$w++;}
			
			$d=1;foreach($balance_request_result as $dRow){
				$deposite_html .='<tr><td>'.$d.'</td><td>'.$dRow->amount.'</br>TXN:'.$dRow->txn.'</td><td>'.$dRow->payment_method.'</td><td>'.\Carbon\Carbon::parse($dRow->created_at)->format('M d Y h:i a').'</td></tr>';
			$d++;}

			$report_html .='<tr><td>'.$total_withdraw.'</td><td>'.$total_addmoney.'</td><td>'.$user_wallet.'</td><td>'.$total_profit.'</td></tr>';
			
			$return_data['withdraw_html']	= $withdraw_html;
			$return_data['deposite_html']	= $deposite_html;
			$return_data['report_html']		= $report_html;
			
			echo json_encode($return_data);

		}

	}
	public function ajaxpost_get_userbid_transaction_history($request) {
		if (request()->isMethod('post')) {
			$user_id = request()->input('user_id');

			$bid_transaction_history = Transactions::where('user_id', $user_id)->orderby('id', 'DESC')->offset(0)->limit(250)->get();

			//echo '<pre>';print_r($bid_transaction_history);exit;
			
			$return_data=[];
			$history_html='';
			
			
			$w=1;foreach($bid_transaction_history as $row){
				$history_html .='<tr><td><span class="badge badge-warning">'.\Carbon\Carbon::parse($row->created_at)->format('M d Y h:i a').'</span></br>'.$row->description.'</td><td>'.$row->amount.'</td></tr>';
			$w++;}
			$return_data['history_html']	= $history_html;
			echo json_encode($return_data);

		}

	}
	
	public function ajaxpost_get_user_bid_history($request) {
		if (request()->isMethod('post')) {
			$user_id 		= request()->input('user_id');
			$category_id 	= request()->input('category_id');
			$game_id 		= request()->input('game_id');
			$date_slot		= request()->input('date_slot');
			$time_slot_id 	= request()->input('time_slot_id');
			
			$totalPlayedAmount	    = 0;
			
			$totalSingleAmount	    = 0;
			$totalPattiAmount	    = 0;
			$totalJodiAmount	    = 0;
			$totalCpAmount	        = 0;
			
			$categoryResult = DB::table('category')->select('name')->where('id', $category_id)->first();
			$categoryTitle  = $categoryResult->name;
			
			$gameResult = DB::table('game_type')->select('name')->where('id', $game_id)->first();
			$gameTitle  = $categoryTitle.' '.$gameResult->name;
			
		
			
			
			
			//echo '<pre>';print_r($gameResult);exit;
			
			/*Single*/
			$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->where('play_type', 1);
			$distinct_single_bid_numbers = $distinct_single_bid_numbers->groupBy('number')->get();
			
			$single_bid_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->sum('amount');
			$totalSingleAmount+= $single_bid_amount;
			$totalPlayedAmount+= $single_bid_amount;
			
			/*Patti*/
			$distinct_patti_bid_numbers = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->where('play_type', 2);
			$distinct_patti_bid_numbers = $distinct_patti_bid_numbers->groupBy('number')->get();
			
			$patti_bid_amount = DB::table('user_bit_transaction')->where('play_type', 2)->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->sum('amount');
			$totalPattiAmount+= $patti_bid_amount;
			$totalPlayedAmount+= $patti_bid_amount;
			
			/*Jodi*/
			$distinct_jodi_bid_numbers = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->where('play_type', 3);
			$distinct_jodi_bid_numbers = $distinct_jodi_bid_numbers->groupBy('number')->get();
			
			$jodi_bid_amount = DB::table('user_bit_transaction')->where('play_type', 3)->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->sum('amount');
			$totalJodiAmount+= $jodi_bid_amount;
			$totalPlayedAmount+= $jodi_bid_amount;
			
			/*Cp*/
			$distinct_cp_bid_numbers = DB::table('user_bit_transaction')->select('number', DB::raw('SUM(amount) as total_amount'),DB::raw('count(id) as total_bid'))->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->where('play_type', 4);
			$distinct_cp_bid_numbers = $distinct_cp_bid_numbers->groupBy('number')->get();
			
			$cp_bid_amount = DB::table('user_bit_transaction')->where('play_type', 4)->where('date_slot', $date_slot)->where('time_slot_id', $time_slot_id)->where('user_id', $user_id)->sum('amount');
			$totalCpAmount+= $cp_bid_amount;
			$totalPlayedAmount+= $cp_bid_amount;
			
			
			
			//echo '<pre>';print_r($distinct_single_bid_numbers);exit;

			$return_data=[];
			$single_bid_html='';
			foreach($distinct_single_bid_numbers as $row){
				$single_bid_html .='<tr><td>'.$row->number.'</td><td>'.$row->total_amount.'</td><td>'.\Carbon\Carbon::parse($date_slot)->format('M d Y').'</td></tr>';
			}
			
			$patti_bid_html='';
			foreach($distinct_patti_bid_numbers as $row){
				$patti_bid_html .='<tr><td>'.$row->number.'</td><td>'.$row->total_amount.'</td><td>'.\Carbon\Carbon::parse($date_slot)->format('M d Y').'</td></tr>';
			}
			
			$jodi_bid_html='';
			foreach($distinct_jodi_bid_numbers as $row){
				$jodi_bid_html .='<tr><td>'.$row->number.'</td><td>'.$row->total_amount.'</td><td>'.\Carbon\Carbon::parse($date_slot)->format('M d Y').'</td></tr>';
			}
			
			$cp_bid_html='';
			foreach($distinct_cp_bid_numbers as $row){
				$cp_bid_html .='<tr><td>'.$row->number.'</td><td>'.$row->total_amount.'</td><td>'.\Carbon\Carbon::parse($date_slot)->format('M d Y').'</td></tr>';
			}
			
			$return_data['gameTitle']	        = $gameTitle.' - <small class="badge badge-warning">Played Amount:- (₹) '.$totalPlayedAmount.'</small>';
			$return_data['totalPlayedAmount']	= $totalPlayedAmount;
			$return_data['single_bid_html']	    = $single_bid_html;
			$return_data['totalSingleAmount']	= $totalSingleAmount;
			
			$return_data['patti_bid_html']	    = $patti_bid_html;
			$return_data['totalPattiAmount']    = $totalPattiAmount;
			
			$return_data['jodi_bid_html']	    = $jodi_bid_html;
			$return_data['totalJodiAmount']	    = $totalJodiAmount;
			
			$return_data['cp_bid_html']	        = $cp_bid_html;
			$return_data['totalCpAmount']	    = $totalCpAmount;
			
			//echo '<pre>';print_r($return_data);exit;
			//$return_data['deposite_html']	= $deposite_html;
			
			echo json_encode($return_data);

		}

	}
	
}