<?php
namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Input;
use Image;
use DB;
use Helpers;
use App\User;
use App\Common;
use App\Category;
use App\Avality_time_date_slot_status;
use App\Avality_time_date_slots;
use App\User_bit_transaction;
use App\Win_period;
use App\Transactions;
use App\Balance_request;
use App\Withdraw_request;
use App\User_wallet;
use App\User_bank;
use App\Game_type;
use App\Time_slots;
use App\Avality_time_slots;
use App\News_board;
use App\Slider;

class ApiController extends Controller
{
	protected $avalityTimeDateSlotsModel;
	protected $avalityTimeDateSlotStatusModel;
	protected $userBitTransactionModel;
	protected $winPeriodModel;
	protected $userTransactionsModel;
	protected $balanceRequestModel;
	protected $withdrawRequestModel;
	protected $userWalletModel;
	protected $userBankModel;
	protected $gameTypeModel;
	protected $timeSlotsModel;
	protected $avalityTimeSlotsModel;
	protected $newsBoardModel;
	public function __construct(){
		$this->avalityTimeDateSlotsModel= new Avality_time_date_slots;
		$this->avalityTimeDateSlotStatusModel= new Avality_time_date_slot_status;
		$this->userBitTransactionModel	= new User_bit_transaction;
		$this->winPeriodModel			= new Win_period;
		$this->userTransactionsModel	= new Transactions;
		$this->balanceRequestModel		= new Balance_request;
		$this->withdrawRequestModel 	= new Withdraw_request;
		$this->userWalletModel 			= new User_wallet;
		$this->userBankModel 			= new User_bank;
		$this->gameTypeModel			= new Game_type;
		$this->timeSlotsModel 			= new Time_slots;
		$this->avalityTimeSlotsModel 	= new Avality_time_slots;
		$this->newsBoardModel 			= new News_board;
    }
	public function game_list(){
		$result=[];
		$slider_list = Slider::where('status',1)->orderBy('id','ASC')->get();
		$slider_data=[];
		if(count($slider_list)>0){
			foreach($slider_list as $row){
				$slider_thumb	= isset($row->image)?Helpers::slider_thumb($row->image): asset('public/images/no_image-150x150.png');
				$slider_data[]=array(
					'id'		=> $row->id,
					'thumb'		=> $slider_thumb,
					'status'	=> $row->status,
					
				);
			}
		}
				
		$result = array(
			'statusCode'		=> '200',
			'slider'			=> $slider_data,
			'message'			=> 'Success',
		);
		
		return response()->json($result);
	}
	
	
	
	
	

	public function getContact(){
		$result=[];
		$phone		= Common::get_settings($where=['option_name'=>'phone']);
		$whatsapp	= Common::get_settings($where=['option_name'=>'whatsapp']);
		$result = array(
			'statusCode'=> '200',
			'phone'		=> $phone,
			'whatsapp'	=> $whatsapp,
			'message'	=> 'Success'
		);
		return response()->json($result);
	}

	public function welcomeMessage(){
		$result=[];
		$welcome_message = Common::get_settings($where=['option_name'=>'welcome_message']);
		$result = array(
			'statusCode'		=> '200',
			'welcome_message'	=> $welcome_message,
			'message'			=> 'Success'
		);
		return response()->json($result);
	}
	public function gameRule(){
		$result=[];
		$rules = Common::get_settings($where=['option_name'=>'rules']);
		$result = array(
			'statusCode'	=> '200',
			'rules'			=> $rules,
			'message'		=> 'Success'
		);
		return response()->json($result);
	}
	public function adminPhone(){
		$result=[];
		$phone 		= Common::get_settings($where=['option_name'=>'phone']);
		$whatsapp 	= Common::get_settings($where=['option_name'=>'whatsapp']);
		$result = array(
			'statusCode'	=> '200',
			'phone'			=> $phone,
			'whatsapp'		=> $whatsapp,
			'message'		=> 'Success'
		);
		return response()->json($result);
	}
	public function newsBoard(){
		$result=[];
		$newsBoardResult = $this->newsBoardModel->where('status',1)->get();
		$newsBoardList=[];
		foreach($newsBoardResult as $row){
			$newsBoardList[]=array(
				'title'		=> $row->title,
				'content'	=> $row->content
			);
		}
		$result = array(
			'statusCode'	=> '200',
			'newsBoardList'	=> $newsBoardList,
			'message'		=> 'Success'
		);
		return response()->json($result);
	}
	public function checkAvailableGame(Request $request){
		$game_id			= Input::get('game_id');
		$category_id		= Input::get('category_id');
		$time_slot_id		= Input::get('time_slot_id');
		$current_time		= Input::get('current_time');
		$current_date		= date('Y-m-d');
		$current_day		= date("l",strtotime($current_date));
		$current_time		= isset($current_time)?$current_time:date('H:i');
		$avality			= 'N';
		$status				= 'N';
		$time_left			= '';
		$game_min_bid		= '';
		$result	= [];
		$data	= [];

		$avalityTimeSlotResult	= $this->timeSlotsModel->where('id', $time_slot_id)->where('category_id', $category_id)->where('status',1)->first();
		//$avalityTimeSlotResult	= $this->timeSlotsModel->where('category_id', $category_id)->where('from_time_slug', '<=', $current_time)->where('to_time_slug', '>=', $current_time)->where('status',1)->first();
		if(isset($avalityTimeSlotResult->id)){
			$time_slot_id	= $avalityTimeSlotResult->id;
			$time_slot		= $avalityTimeSlotResult->from_time.'-'.$avalityTimeSlotResult->to_time;
			$start	= strtotime($current_time);
			$stop	= strtotime($avalityTimeSlotResult->to_time);
			$diff = ($stop - $start);
			$temp=$diff/3600;
			// hours
			$hours=floor($temp);
			$temp=60*($temp-$hours);
			// minutes
			$minutes=floor($temp);
			$temp=60*($temp-$minutes);
			// seconds
			$seconds=floor($temp);
			$time_left		= $hours.' hr '.$minutes.' min';
			$gameResult		= $this->gameTypeModel->where('id', $game_id)->where('category_id', $category_id)->where('time_slot_id', $time_slot_id)->where('status',1)->first();
			$game_id		= isset($gameResult->id)?$gameResult->id:'';
			$game_name		= isset($gameResult->name)?$gameResult->name:'';
			$game_thumb		= isset($gameResult->image)?Helpers::category_image($gameResult->image): asset('public/images/no_image-150x150.png');
			$game_day		= isset($gameResult->day)?$gameResult->day:'';
			$game_min_bid	= isset($gameResult->min_bid_amount)?$gameResult->min_bid_amount:'';
			if($game_day!=''){
				$dayarr=explode(',',$game_day);
				if (in_array($current_day, $dayarr)) {
					$avality = 'Y';
				}
			}
			if($game_id!=''){
				$status 		= 'Y';
			}
		}
		if($avality=='Y'){
			$data=array(
				'game_id'		=> $game_id,
				'category_id'	=> $category_id,
				'time_slot_id'	=> $time_slot_id,
				'time_slot'		=> $time_slot,
				'game_name'		=> $game_name,
				'thumb'			=> $game_thumb,
				'min_bid'		=> $game_min_bid,
				'status'		=> $status,
				'time_left'		=> $time_left
			);
			$result = array(
				'statusCode'	=> '200',
				'status'		=> $avality,
				'result'		=> $data,
				'message'		=> 'Success',
			);
		}else{
			$result = array(
				'statusCode'	=> '404',
				'status'		=> $avality,
				'result'		=> [],
				'message'		=> 'Error',
			);
		}
		return response()->json($result);
	}
	public function getList3(){
		$result=[];

		$game_status 	= Common::get_settings($where=['option_name'=>'game_status']);
		
		$user_id		= Auth::user()->id;
		$check_wallet_balance = $this->userWalletModel::select('balance')->where('user_id', $user_id)->first();
		$balance = isset($check_wallet_balance->balance) ? $check_wallet_balance->balance : '0';




		$welcome_message 	= Common::get_settings($where=['option_name'=>'welcome_message']);
		$welcome_message2 	= Common::get_settings($where=['option_name'=>'welcome_message2']);

		$slider_list = Slider::where('status',1)->orderBy('id','ASC')->get();
		$slider_data=[];
		if(count($slider_list)>0){
			foreach($slider_list as $row){
				$slider_thumb	= isset($row->image)?Helpers::slider_thumb($row->image): asset('public/images/no_image-150x150.png');
				$slider_data[]=array(
					'id'		=> $row->id,
					'title'		=> $row->title,
					'title2'	=> $row->title2,
					'title3'	=> $row->title3,
					'desc'		=> $row->desc,
					'status'	=> $row->status,
					'thumb'		=> $slider_thumb
				);
			}
		}

		$result_list = Category::where('status',1)->orderBy('sort','ASC')->get();
		$data=[];

		$game_status='on';
		if($game_status!='off'){
			if(count($result_list)>0){
				foreach($result_list as $row){
					$current_date	= date('Y-m-d');
					$current_day	= date("l",strtotime($current_date));
					$current_time	= date('H:i');
					$status 		= 'Y';
					$status_title	= 'play';
					$status_btn		= 'playBtn';
					$time_slot		= '';
					$category_thumb	= isset($row->image)?Helpers::thumb($row->image): asset('public/images/no_image-150x150.png');
					$data[]=array(
						'category_id'	=> $row->id,

						'name'			=> $row->name,
						'label'			=> $row->label,
						'slug'			=> $row->slug,
						'time_slot'		=> $time_slot,
						'status'		=> $status,
						'status_title'	=> $status_title,
						'status_btn'	=> $status_btn,
						'thumb'			=> $category_thumb
					);
				}
			}
		}
		
		$result = array(
			'statusCode'		=> '200',
			'result'			=> $data,
			'slider'			=> $slider_data,
			'welcome_message'	=> $welcome_message,
			'welcome_message2'	=> $welcome_message2,
			'balance'			=> $balance,
			'message'			=> 'Success',
		);
		
		return response()->json($result);
	}
	public function getList(){
		$result=[];
		
		$welcome_message 	= Common::get_settings($where=['option_name'=>'welcome_message']);
		$welcome_message2 	= Common::get_settings($where=['option_name'=>'welcome_message2']);
		$slider_data=[];
		$data=[];
		
		$user_id		= Auth::user()->id;
		$check_wallet_balance = $this->userWalletModel::select('balance')->where('user_id', $user_id)->first();
		$balance = isset($check_wallet_balance->balance) ? $check_wallet_balance->balance : '0';
		
		
		
		if (file_exists('public/json/game_list.json')) {
			$json = file_get_contents('public/json/game_list.json');
			$json_data = json_decode($json,true);
			foreach($json_data['result'] as $row){
				$data[]=array(
					'category_id'	=> $row['category_id'],
					'name'			=> $row['name'],
					'label'			=> $row['label'],
					'slug'			=> $row['slug'],
					'time_slot'		=> $row['time_slot'],
					'status'		=> $row['status'],
					'status_title'	=> $row['status_title'],
					'status_btn'	=> $row['status_btn'],
					'thumb'			=> $row['thumb'],
				);
			}
			foreach($json_data['slider'] as $row){
				$slider_data[]=array(
					'id'		=> $row['id'],
					'title'		=> $row['title'],
					'title2'	=> $row['title2'],
					'title3'	=> $row['title3'],
					'desc'		=> $row['desc'],
					'status'	=> $row['status'],
					'thumb'		=> $row['thumb'],
				);
			}
		}
		
		$result = array(
			'statusCode'		=> '200',
			'result'			=> $data,
			'slider'			=> $slider_data,
			'welcome_message'	=> $welcome_message,
			'welcome_message2'	=> $welcome_message2,
			'balance'			=> $balance,
			'message'			=> 'Success',
		);
		
		return response()->json($result);
	}

	public function getList_old(){
		$result=[];

		$welcome_message 	= Common::get_settings($where=['option_name'=>'welcome_message']);

		$slider_list = Slider::where('status',1)->orderBy('id','ASC')->get();
		$slider_data=[];
		if(count($slider_list)>0){
			foreach($slider_list as $row){
				$slider_thumb	= isset($row->image)?Helpers::slider_thumb($row->image): asset('public/images/no_image-150x150.png');
				$slider_data[]=array(
					'id'		=> $row->id,
					'title'		=> $row->title,
					'title2'	=> $row->title2,
					'title3'	=> $row->title3,
					'desc'		=> $row->desc,
					'status'	=> $row->status,
					'thumb'		=> $slider_thumb
				);
			}
		}

		$result_list = Category::where('status',1)->orderBy('id','ASC')->get();
		$data=[];
		if(count($result_list)>0){
			foreach($result_list as $row){
				$current_date	= date('Y-m-d');
				$current_day	= date("l",strtotime($current_date));
				$current_time	= date('H:i');
				$date_slot_id	= '';
				$time_slot_id	= '';
				$avality		= 'N';
				$status			= 'N';
				$status_title	= 'close';
				$status_btn		= 'closeBtn';
				$time_slot		= '';
				$game_id		= '';
				$game_name		= '';
				$game_thumb		= asset('public/images/no_image-150x150.png');
				$game_day		= '';
				$game_min_bid	= '';

				$avalityTimeSlotResult	= $this->timeSlotsModel->where('category_id', $row->id)->where('from_time_slug', '<=', $current_time)->where('to_time_slug', '>=', $current_time)->where('status',1)->get();

				if(count($avalityTimeSlotResult)>0){
					foreach($avalityTimeSlotResult as $rtimeSlot){
						if(isset($rtimeSlot->id)){
							$time_slot_id	= $rtimeSlot->id;
							$time_slot		= $rtimeSlot->from_time.'-'.$rtimeSlot->to_time;

							$gameResult		= $this->gameTypeModel->where('category_id', $row->id)->where('time_slot_id', $time_slot_id)->where('status',1)->first();
							$game_id		= isset($gameResult->id)?$gameResult->id:'';
							$game_name		= isset($gameResult->name)?$gameResult->name:'';
							$game_thumb		= isset($gameResult->image)?Helpers::thumb($gameResult->image): asset('public/images/no_image-150x150.png');
							$game_day		= isset($gameResult->day)?$gameResult->day:'';
							$game_min_bid	= isset($gameResult->min_bid_amount)?$gameResult->min_bid_amount:'';
							//$game_thumb_type = pathinfo($game_thumb, PATHINFO_EXTENSION);
							//$game_thumb_data = file_get_contents($game_thumb);
							//$game_thumb_base64 = 'data:image/' . $game_thumb_type . ';base64,' . base64_encode($game_thumb_data);
							$avality = 'N';
							if($game_day!=''){
								$dayarr=explode(',',$game_day);
								if (in_array($current_day, $dayarr)) {
									$avality = 'Y';
								}
							}

							$status 		= 'N';
							$status_title	= 'close';
							$status_btn		= 'closeBtn';
							if($game_id!=''){
								$status 		= 'Y';
								$status_title	= 'play';
								$status_btn		= 'playBtn';
							}

							if($avality=='Y'){
								$category_thumb	= isset($row->image)?Helpers::thumb($row->image): asset('public/images/no_image-150x150.png');
								$data[]=array(
									'game_id'		=> $game_id,
									'category_id'	=> $row->id,
									'time_slot_id'	=> $time_slot_id,
									'name'			=> $row->name,
									'label'			=> $row->label,
									'slug'			=> $row->slug,
									'time_slot'		=> $time_slot,
									'game_name'		=> $game_name,
									'game_thumb'	=> $game_thumb,
									//'game_thumb_base64'=> $game_thumb_base64,
									'game_day'		=> $game_day,
									'min_bid'		=> $game_min_bid,
									'status'		=> $status,
									'status_title'	=> $status_title,
									'status_btn'	=> $status_btn,
									'thumb'			=> $category_thumb
								);
							}
						}
					}
				}
			}

			$result = array(
				'statusCode'	=> '200',
				'result'		=> $data,
				'slider'		=> $slider_data,
				'welcome_message'=>$welcome_message,
				'message'		=> 'Success',
			);
		}else{
			$result = array(
				'statusCode'	=> '404',
				'result'		=> [],
				'message'		=> 'Error',
			);
		}
		//echo '<pre>';print_r($result);exit;
		return response()->json($result);
	}

	public function gameWiseTimeList(){
		$result=[];
		$category_id	= Input::get('category_id');
		$current_date	= date('Y-m-d');
		$current_day	= date("l",strtotime($current_date));
		$current_time	= date('H:i');

		$avality 		= 'N';
		$status 		= 'N';
		$status_title	= 'close';
		$status_btn		= 'closeBtn';
		
		$game_status 	= Common::get_settings($where=['option_name'=>'game_status']);





		$time_slot_arr=[];
		$avalityTimeSlotResult	= $this->timeSlotsModel->where('category_id', $category_id)->where('from_time_slug', '<=', $current_time)->where('to_time_slug', '>=', $current_time)->where('status',1)->get();
		if(count($avalityTimeSlotResult)>0){
			foreach($avalityTimeSlotResult as $row){
				$time_slot_arr[]=$row->id;
			}
		}






		$gameResult = DB::table('game_type')->select('game_type.*','time_slots.from_time','time_slots.to_time')->join('time_slots','time_slots.id','=','game_type.time_slot_id')->where('game_type.category_id', $category_id)->where('game_type.status', 1)->orderby('id', 'ASC')->get();

		$gameEndResult	= DB::table('game_type')->select('game_type.id')->where('game_type.category_id', $category_id)->where('game_type.status', 1)->orderby('id', 'DESC')->first();
		$endGameId		= isset($gameEndResult->id)?$gameEndResult->id:'';

		//echo $endGameId;exit;

		//echo '<pre>';print_r($current_day);exit;
		//Monday

		if(count($gameResult)>0){
			foreach($gameResult as $row){
				$time_slot_id	= $row->time_slot_id;
				$time_slot		= $row->from_time.'-'.$row->to_time;
				$game_id		= isset($row->id)?$row->id:'';
				$game_name		= isset($row->name)?$row->name:'';
				$game_thumb		= isset($row->image)?Helpers::thumb($row->image): asset('public/images/no_image-150x150.png');
				$game_day		= isset($row->day)?$row->day:'';
				$game_min_bid	= isset($row->min_bid_amount)?$row->min_bid_amount:'';

				$avality 		= 'N';
				if($game_day!=''){
					$dayarr=explode(',',$game_day);
					if (in_array($current_day, $dayarr)) {
						$avality = 'Y';
					}
				}

				if (in_array($time_slot_id, $time_slot_arr)) {
					$status 		= 'Y';
					$status_title	= 'play';
					$status_btn		= 'gotoPlayBtn';
				}

				$selectedtime_slot_id=isset($time_slot_arr[0])?$time_slot_arr[0]:'';

				if($selectedtime_slot_id<$time_slot_id){
					$status 		= 'N';
					$status_title	= 'OFF';
					$status_btn		= 'closeBtn upcommingBtn';
				}

				if($avality=='N'){
					$status 		= 'N';
					$status_title	= 'OFF';
					$status_btn		= 'closeBtn upcommingBtn';
				}

				//print_r($selectedtime_slot_id);exit;



				$isLastRow='N';
				if($game_id==$endGameId){
					$isLastRow='Y';
				}
				
				if($game_status=='off'){
					$status 		= 'N';
					$status_title	= 'OFF';
					$status_btn		= 'closeBtn upcommingBtn';
				}
				
				/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/
				//$status 		= 'N';
				//$status_title	= 'OFF';
				//$status_btn		= 'closeBtn upcommingBtn';
				/*++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++*/

				$data[]=array(
					'avality'		=> $avality,
					'game_id'		=> $game_id,
					'name'			=> $game_name,
					'category_id'	=> $category_id,
					'time_slot_id'	=> $time_slot_id,
					'time_slot'		=> $time_slot,
					'game_day'		=> $game_day,
					'min_bid'		=> $game_min_bid,
					'status'		=> $status,
					'status_title'	=> $status_title,
					'status_btn'	=> $status_btn,
					'thumb'			=> $game_thumb,
					'islastrow'		=> $isLastRow
				);
			}
		}

		$result = array(
			'statusCode'	=> '200',
			'result'		=> $data,
			'message'		=> 'Success'
		);

		return response()->json($result);

	}

	public function gameCategotyList(){
		$result=[];
		$result_list = Category::where('status',1)->orderBy('sort','ASC')->get();
		$data=[];
		if(count($result_list)>0){
			foreach($result_list as $row){
				$thumb	= isset($row->image)?Helpers::thumb($row->image): asset('public/images/no_image-150x150.png');
				//$thumb_type = pathinfo($thumb, PATHINFO_EXTENSION);
				//$thumb_data = file_get_contents($thumb);
				//$thumb_base64 = 'data:image/' . $thumb_type . ';base64,' . base64_encode($thumb_data);

				$data[]=array(
					'category_id'	=> $row->id,
					'name'			=> $row->name,
					'label'			=> $row->label,
					'slug'			=> $row->slug,
					//'thumb_base64'	=> $thumb_base64,
					'thumb'			=> $thumb
				);
			}

			$result = array(
				'statusCode'	=> '200',
				'result'		=> $data,
				'message'		=> 'Success',
			);
		}else{
			$result = array(
				'statusCode'	=> '404',
				'result'		=> [],
				'message'		=> 'Error',
			);
		}
		//print_r($result);exit;
		return response()->json($result);
	}

	public function getRulesList(){
		$result_list = $this->gameTypeModel->where('status',1)->orderBy('name','ASC')->get();
		$result=[];
		foreach($result_list as $row){
			$rules=[];
			if($row->rules!=''){
				$rulesDOM	= htmlspecialchars(trim(strip_tags($row->rules)));
				$rulesDOM	= nl2br($rulesDOM);
				$rule_list	= explode('<br />',$rulesDOM);
				if(count($rule_list)>0){
					for($i=0;count($rule_list)>$i;$i++){
						$rules[]=trim($rule_list[$i]);
					}
				}
			}
			$result[]=array(
				'id'	=> $row->id,
				'name'	=> $row->name,
				'slug'	=> $row->slug,
				'rules'	=> $rules
			);
		}
		if(count($result)>0){
			$result = array(
				'statusCode'	=> '200',
				'result'		=> $result,
				'message'		=> 'Success',
			);
		}else{
			$result = array(
				'statusCode'	=> '404',
				'result'		=> [],
				'message'		=> 'Success',
			);
		}
		return response()->json($result);
	}
	public function getTimeTableList(){
		$result_list = $this->avalityTimeDateSlotsModel->get_time_table();
		$result = array(
			'statusCode'	=> '200',
			'result'		=> $result_list,
			'message'		=> 'Success',
		);
		return response()->json($result);
	}
}