<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Discount extends Model
{
    protected $table = 'discount';
	protected $fillable = ['price','discount_amount','game_type_id','status','created_at'];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('discount');
        if($search != '') {
            $total_records = $total_records->where(function($total_records) use ($search) {
                $total_records->where(DB::raw("price"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$total_records = $total_records->count();
		
		$records = DB::table('discount')->select('discount.*');
		if($search != '') {
            $records = $records->where(function($records) use ($search) {
				$records->where(DB::raw("name"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$records = $records->orderby('id', 'DESC')->get();
		//$records = $records->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
	
	public static function getUserResult($param = array()) {
		$return			= array();
		
		$type 			= $param['type'];
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$game_type_info 	= DB::table('game_type')->where('slug',$type)->first();
		$date_slots_info 	= DB::table('avality_time_date_slots')->where('date',date('Y-m-d'))->first();
		$date_slot_id		= isset($date_slots_info->id)?$date_slots_info->id:'';
		
		$result=[];
		if(!empty($game_type_info)){
			$game_type_id		= $game_type_info->id;
			$game_type_title	= $game_type_info->name;
			
			$transactions = DB::table('user_bit_transaction')->join('users','users.id','=','user_bit_transaction.user_id')->select('users.name','user_bit_transaction.user_id', DB::raw('SUM(user_bit_transaction.amount) as total_amount'),DB::raw('count(user_bit_transaction.id) as total_bid'))->where('user_bit_transaction.type_id', $game_type_id)->where('user_bit_transaction.date_slot_id', $date_slot_id)->where('user_bit_transaction.status',1)->orderby('user_bit_transaction.user_id', 'asc')->groupBy('user_bit_transaction.user_id')->get();
			
			
			foreach($transactions as $row){ 
				if($row->total_amount>=1000){
					$user_discount_info = DB::table('user_discount')->where('user_id',$row->user_id)->where('date_slot_id',$date_slot_id)->where('game_type_id',$game_type_id)->first();
					$status				= isset($user_discount_info->status)?$user_discount_info->status:'N';
					
					$result[]=array(
						'user_id' 		=> $row->user_id,
						'user_name' 	=> $row->name,
						'total_amount' 	=> $row->total_amount,
						'total_bid' 	=> $row->total_bid,
						'status' 		=> $status
					);
				}
			}	
		}
		
		$return['records'] 			= $result;
		$return['total_records'] 	= count($result);
		$return['date_slot_id'] 	= $date_slot_id;
		$return['game_type_id'] 	= $game_type_id;
		
		//echo '<pre>';print_r($return);exit;
		
		
		return $return;
		
		
	}
}
