<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Balance_request extends Model
{
    protected $table = 'balance_request';
	protected $guarded	= [];

	public function customer_details(){
        return $this->hasOne(User::class,'id','user_id');
    }
	
	public function getBankDesc() {
		return $this->hasOne('App\User_bank', 'user_id', 'user_id');
	}
	public function getUser() {
        return $this->hasOne('App\User', 'id', 'user_id');
    }

	public static function get_data($param = array()) {
		$return			= array();

		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate']:'';
		$todate 		= isset($param['todate'])?$param['todate']:'';
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];

		//print_r($param);exit;

		$total_payments = DB::table('balance_request');
        if($search != '') {
            $total_payments = $total_payments->where(function($total_payments) use ($search) {
                $total_payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }


		$total_payments = $total_payments->count();

		$payments = DB::table('balance_request')->select('balance_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'balance_request.user_id');
		if($search != '') {
            $payments = $payments->where(function($payments) use ($search) {
				$payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
		if($fromdate!='' && $todate!=''){
			$payments = $payments->where('balance_request.created_at', '>=', $fromdate)->where('balance_request.created_at', '<=', $todate);
		}else{
			if($fromdate!=''){
				$payments = $payments->where('balance_request.created_at', $fromdate);
			}
		}



		$payments = $payments->orderby('id', 'DESC')->offset(0)->limit(1000)->get();
		//$payments = $payments->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] 		= $payments;
		$return['total_orders'] = $total_payments;
		return $return;
	}
	public static function get_upi_data($param = array()) {
		$return			= array();

		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate']:'';
		$todate 		= isset($param['todate'])?$param['todate']:'';
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];

		//print_r($param);exit;

		$total_payments = DB::table('balance_request')->where('type','U');
        if($search != '') {
            $total_payments = $total_payments->where(function($total_payments) use ($search) {
                $total_payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }


		$total_payments = $total_payments->count();

		$payments = DB::table('balance_request')->select('balance_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'balance_request.user_id')->where('type','U');
		if($search != '') {
            $payments = $payments->where(function($payments) use ($search) {
				$payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
		if($fromdate!='' && $todate!=''){
			//$payments = $payments->where('balance_request.created_at', '>=', $fromdate)->where('balance_request.created_at', '<=', $todate);
			$payments = $payments->whereDate('balance_request.created_at', '>=', $fromdate)->whereDate('balance_request.created_at', '<=', $todate);
		}else{
			if($fromdate!=''){
				$payments = $payments->where('balance_request.created_at', $fromdate);
			}
		}



		$payments = $payments->orderby('id', 'DESC')->offset(0)->limit(500)->get();
		//$payments = $payments->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] 		= $payments;
		$return['total_orders'] = $total_payments;
		return $return;
	}

	public static function get_report_data($param = array()) {
		$payments		= array();

		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate']:'';
		$todate 		= isset($param['todate'])?$param['todate']:'';
		$status 		= isset($param['status'])?$param['status']:'';

		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];




		if($fromdate!=''){
			$payments = DB::table('balance_request')->select('balance_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'balance_request.user_id')->where('balance_request.status', $status);
			$payments = $payments->whereDate('balance_request.created_at',$fromdate);
			$payments = $payments->orderby('id', 'ASC')->get();
		}

		$return['records'] 		= $payments;
		return $return;
	}

	public static function get_upi_report_data($param = array()) {
		$payments		= array();

		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate']:'';
		$todate 		= isset($param['todate'])?$param['todate']:'';
		$status 		= isset($param['status'])?$param['status']:'';

		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];

		if($fromdate!=''){
			$payments = DB::table('balance_request')->select('balance_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'balance_request.user_id')->where('balance_request.status', $status)->where('balance_request.type', 'U');

			if($fromdate!='' && $todate!=''){

				//$payments = $payments->where('balance_request.created_at', '>=', $fromdate)->where('balance_request.created_at', '<=', $todate);
				//$payments = $payments->whereBetween('balance_request.created_at', [$fromdate, $todate]);
				$payments = $payments->whereDate('balance_request.created_at', '>=', $fromdate)->whereDate('balance_request.created_at', '<=', $todate);
			}else{
				if($fromdate!=''){
					$payments = $payments->whereDate('balance_request.created_at',$fromdate);
				}
			}

			$payments = $payments->orderby('id', 'ASC')->get();
		}

		$return['records'] 		= $payments;
		return $return;
	}
	
	public static function get_transfer_report($param = array()) {
		$payments		= array();
		
		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate'].' 00:00:00':'';
		$todate 		= isset($param['todate'])?$param['todate'].' 23:59:59':'';
		$status 		= isset($param['status'])?$param['status']:'';
		
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		//print_r($fromdate.'-'.$todate);exit;
		
		
		if($fromdate!='' || $todate!='' ){
			$payments = DB::table('balance_request')->select('balance_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'balance_request.user_id')->where('balance_request.status', $status);
			if($fromdate!='' && $todate!=''){
				$payments = $payments->where('balance_request.created_at', '>=', $fromdate)->where('balance_request.created_at', '<=', $todate);
			}else{
				if($fromdate!=''){
					$payments = $payments->where('balance_request.created_at', '>=', $fromdate)->where('balance_request.created_at', '<=', $param['fromdate'].' 23:59:59');
				}
			}
			//$result = ModelName::whereBetween('created_at', [$dateS->format('Y-m-d')." 00:00:00", $dateE->format('Y-m-d')." 23:59:59"])->get();
			
			$payments = $payments->orderby('id', 'DESC')->get();
		}
		$return['records'] 		= $payments;
		return $return;
	}
}