<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Addition extends Model
{
    protected $table = 'addition';
	protected $guarded	= [];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('addition')->join('users','users.id','=','addition.user_id');
        if($search != '') {
            $total_records = $total_records->where(function($total_records) use ($search) {
                $total_records->where(DB::raw("users.phone"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$total_records = $total_records->count();
		
		$records = DB::table('addition')->select('addition.*','users.name','users.phone')->join('users','users.id','=','addition.user_id');
		if($search != '') {
            $records = $records->where(function($records) use ($search) {
				$records->where(DB::raw("users.phone"), 'LIKE', '%' . $search . '%');
            });
        }
		//->offset($limit_start)->limit($per_page)
		$records = $records->orderby('id', 'DESC')->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
}
