<?php $__env->startSection('dashboardContent'); ?>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0"><?php echo e($title ?? ''); ?></h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('administrator/dashboard')); ?>">Home</a></li>
                        <li class="breadcrumb-item active"><?php echo e($breadcumbs ?? 'No title'); ?></li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> <?php echo $__env->make('messages.flash_messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="row">
                <div class="col-md-12">
                    <div class="card">
                        <div class="card-header"> <a href="javascript:;" class="btn btn-dark add_news_board"> <i
                                    class="fa fa-plus" aria-hidden="true"></i> Add</a> </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="example1" class="table table-bordered table-striped text-nowrap tableMd">
                                    <thead>
                                        <tr>
                                            <th>ID</th>
                                            <th>Title</th>
                                            <th>Desc</th>
                                            <th>Date</th>
                                        </tr>
                                    </thead>
                                    <tbody>

                                        <?php $i=1;?>
                                        <?php $__currentLoopData = $news_list['records']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <tr>
                                            <td><?php echo e($i); ?></td>
                                            <td><?php echo e($row->title); ?></td>
                                            <td><?php echo e($row->content); ?></td>
                                            <td><?php echo e($row->created_at); ?></td>
                                        </tr>
                                        <?php $i++;?>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </tbody>

                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
</div>
<div class="example-modal">
    <div class="modal" id="set_result_modal">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header">
                    <h4 class="modal-title" id="modal-title">Add news board</h4>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span
                            aria-hidden="true">×</span></button>
                </div>
                <?php echo Form::open(['url'=>'administrator/news_board/save', 'class'=>'news_board-form', 'id'
                =>'news_board-form', 'autocomplete' => 'off']); ?>

                <div class="modal-body">
                    <div class="form-group">
                        <label for="" class="control-label">Title:</label>
                        <input type="text" name="title" id="title" class="form-control" />
                    </div>
                    <div class="form-group">
                        <label for="" class="control-label">Desc:</label>
                        <input type="text" name="content" id="content" class="form-control" />

                    </div>
                </div>
                <div class="modal-footer justify-content-between">
                    <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
                    <button type="submit" class="btn btn-primary btn-save">Save changes</button>
                </div>
                </form>
            </div>
        </div>
    </div>
</div>
<?php $__env->startPush('stylesheet'); ?>

<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
$(function() {
    $('#example1').DataTable()
});
$(document).on('click', '.add_news_board', function() {
    $('#set_result_modal').modal('show');
});
$(function() {
    $("#news_board-form").validate({
        errorElement: "span",
        rules: {
            "title": "required",
            "content": "required",
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.adminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ff4k/public_html/resources/views/admin/news_board/index.blade.php ENDPATH**/ ?>