<?php $__env->startSection('dashboardContent'); ?>
<style>
.tableMd small.label.bg-red {
    padding: 0.2rem 0.5rem;
    border-radius: 0.2rem;
}
.dark-mode .bg-red, .dark-mode .bg-red>a {
    color: #fff!important;
}
</style>

<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0"><?php echo e($title ?? ''); ?></h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="<?php echo e(url('administrator/dashboard')); ?>">Home</a></li>
            <li class="breadcrumb-item active"><?php echo e($breadcumbs ?? 'No title'); ?></li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"><?php echo $__env->make('messages.flash_messages', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>Date:</label>
                      <div class="input-group date" id="reservationdate" data-target-input="nearest">
                        <input type="text" name="fromdate" class="form-control form-control-sm datetimepicker-input" value="<?php echo e($fromdate ?: date('Y-m-d')); ?>" data-target="#reservationdate" required="required"/>
                        <div class="input-group-append" data-target="#reservationdate" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-lg-3 col-md-3 col-sm-6 col-12">
                    <div class="form-group">
                      <label>To Date:</label>
                      <div class="input-group date" id="reservationdate2" data-target-input="nearest">
                        <input type="text" name="todate" class="form-control form-control-sm datetimepicker-input" value="<?php echo e($todate ? $todate : date('Y-m-d')); ?>" data-target="#reservationdate"/>
                        <div class="input-group-append" data-target="#reservationdate2" data-toggle="datetimepicker">
                          <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                        </div>
                      </div>
                    </div>
                  </div>
                  <div class="col-12">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
          <div class="card-header">
              <h3 class="card-title">Total Amount: Rs.<?php echo e((new NumberFormatter('en_IN', NumberFormatter::DECIMAL))->format($totalAmount)); ?></h3>
            </div>
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table tableMd table-bordered table-striped text-nowrap">
                  <thead>
                    <tr>
                      <th>S.n</th>
                      <th>Name</th>
                      <th>Mobile No</th>
                      <th>Amount</th>
                      <th>TXN</th>
                      <th>Othersvid</th> 
                      <th>Date</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  <?php $i=1; ?>
                  <?php $__currentLoopData = $balance_request_list['records']; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td><?php echo e($i); ?></td>
                    <td><?php echo e($row->customer_name); ?></td>
                    <td><?php echo e($row->customer_phone); ?></td>
                  <td style="text-align:center"><i class="fa fa-inr"></i> <?php echo e((new NumberFormatter('en_IN', NumberFormatter::DECIMAL))->format($row->amount)); ?></td>
                    <td style="text-align:center"><?php echo e($row->txn); ?></td>
                    <td><?php echo e($row->payment_method); ?></td>
                    <td><?php echo e(\Carbon\Carbon::parse($row->created_at)->format('M d Y h:i a')); ?></td>
                  </tr>
                  <?php $i++; ?>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Accept?</p>
</div>
<div id="dialog-confirm2" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Reject?</p>
</div>
<?php $__env->startPush('stylesheet'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script> 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 

<!-- Tempusdominus Bootstrap 4 -->
<link rel="stylesheet" href="<?php echo e(asset('public/front/plugins/tempusdominus-bootstrap-4/css/tempusdominus-bootstrap-4.min.css')); ?>">
<!-- InputMask --> 
<script src="<?php echo e(asset('public/front/plugins/moment/moment.min.js')); ?>"></script> 
<!-- Tempusdominus Bootstrap 4 --> 
<script src="<?php echo e(asset('public/front/plugins/tempusdominus-bootstrap-4/js/tempusdominus-bootstrap-4.min.js')); ?>"></script>
<script>
//Date picker
$('#reservationdate').datetimepicker({
	format: 'YYYY-MM-DD'
});
$('#reservationdate2').datetimepicker({
	format: 'YYYY-MM-DD'
});


/*$(function () {
    $('#example1').DataTable()
})*/

</script> 
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?> 
<?php echo $__env->make('layouts.admin.adminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ff2co/public_html/admin-login.ff2.co.in/resources/views/admin/transfer_report.blade.php ENDPATH**/ ?>