<!DOCTYPE html>
<html lang="en">
<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Contact Support | FF4K Kolkata Fatafat</title>

  <meta name="description" content="Contact FF4K customer support for Kolkata Fatafat, Delhi Fatafat, Goa Fatafat and Main Bazar betting assistance." />
  <link rel="stylesheet" href="<?php echo e(asset('public/css/contact.css')); ?>">
</head>
<body>

  <section class="contactWrap">
    <div class="contactBox">

      <h1>Contact <?php echo e($data['site_title']); ?> Support</h1>

      <p>
        Need help with <strong>Kolkata Fatafat</strong>, <strong>Delhi Fatafat</strong>,
        <strong>Goa Fatafat</strong>, or <strong>Main Bazar</strong> games?
        Our support team is available to assist you.
      </p>

      <div class="contactInfo">
        <div class="infoItem">
          <span>📞 Phone</span>
          <a href="tel:<?php echo e($data['phone']); ?>"><?php echo e($data['phone']); ?></a>
        </div>
        <div class="infoItem">
          <span>💬 WhatsApp</span>
          <a href="https://wa.me/<?php echo e($data['whatsapp']); ?>" target="_blank">Chat on WhatsApp</a>
        </div>
      </div>

      <div class="backLinks">
        <a href="/kolkata-fatafat">Kolkata Fatafat</a>
        <a href="/delhi-fatafat">Delhi Fatafat</a>
        <a href="/goa-fatafat">Goa Fatafat</a>
        <a href="/main-bazar">Main Bazar</a>
      </div>

    </div>
  </section>

</body>
</html>
<?php /**PATH /home/ff4k/public_html/resources/views/privacy.blade.php ENDPATH**/ ?>