<?php $__env->startSection('dashboardContent'); ?>
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Dashboard</h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('administrator')); ?>">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3><?php echo e($total_user); ?></h3>
                            <p>User</p>
                        </div>
                        <div class="icon"> <i class="ion ion-bag"></i> </div>
                        <a href="<?php echo e(url('administrator/user')); ?>" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3><?php echo e($total_withdraw_request); ?></h3>
                            <p>Withdraw Request</p>


                        </div>
                        <div class="icon"> <i class="ion ion-stats-bars"></i> </div>
                        <a href="<?php echo e(url('administrator/withdraw_request')); ?>" class="small-box-footer">Total Pending-
                            <span class="badge badge-warning right"
                                style="font-weight: bold;"><?php echo e($total_withdraw_pending_request); ?></span> <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3><?php echo e($total_balance_request); ?></h3>
                            <p>Balance Request</p>
                        </div>
                        <div class="icon"> <i class="ion ion-person-add"></i> </div>
                        <a href="<?php echo e(url('administrator/balance_request')); ?>" class="small-box-footer">Total Pending-
                            <span class="badge badge-info right"
                                style="font-weight: bold;"><?php echo e($total_balance_pending_request); ?></span> <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3><?php echo e($total_user_balance); ?></h3>
                            <p>Total Wallet Balance</p>
                        </div>
                        <div class="icon"> <i class="ion ion-pie-graph"></i> </div>
                        <a href="<?php echo e(url('administrator/user?type=wallet')); ?>" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header border-0">
                            <div class="d-flex justify-content-between">
                                <h3 class="card-title">Revenue</h3>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="d-flex">
                                <p class="d-flex flex-column"> <span class="text-bold text-lg">
                                        <?=$chart_result['total_profit'];?>
                                    </span> <span>Total Profit</span> </p>
                                <!--<p class="ml-auto d-flex flex-column text-right"> <span class="text-success"> <i class="fas fa-arrow-up"></i> <?=$chart_result['total_profit_percent'];?>% </span> <span class="text-muted">Since last month</span> </p>-->
                            </div>
                            <!-- /.d-flex -->

                            <div class="position-relative mb-4">
                                <canvas id="sales-chart" height="200"></canvas>
                            </div>
                            <div class="d-flex flex-row justify-content-end"> <span class="mr-2"> <i
                                        class="fas fa-square text-primary"></i> Deposit </span> <span> <i
                                        class="fas fa-square text-gray"></i> Withdraw </span> </div>
                        </div>
                    </div>
                    <!-- /.card -->

                </div>
                <div class="col-lg-6">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Today Game Usage</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="chart-responsive">
                                        <canvas id="pieChart" height="150"></canvas>
                                    </div>
                                    <!-- ./chart-responsive -->
                                </div>
                                <!-- /.col -->
                                <div class="col-md-4">
                                    <ul class="chart-legend clearfix">
                                        <?php $__currentLoopData = $current_game_chart_result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <li style="font-size:14px"><i class="far fa-circle"
                                                style="color:<?php echo e($row['color']); ?>"></i> <?php echo e($row['title']); ?></li>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </ul>
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer bg-light p-0">
                            <ul class="nav nav-pills flex-column">
                                <?php $__currentLoopData = $current_game_chart_result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="nav-item"> <a href="javascript:;" class="nav-link"
                                        style="color:<?php echo e($row['color']); ?>"> <?php echo e($row['title']); ?> <span class="float-right"
                                            style="color:<?php echo e($row['color']); ?>"> Total:-₹<?php echo e($row['total_amount']); ?>- Total
                                            Win:-₹<?php echo e($row['total_win_amount']); ?></span> </a> </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                        <!-- /.footer -->
                    </div>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
<?php $__env->startPush('stylesheet'); ?>
<?php $__env->stopPush(); ?>
<?php $__env->startPush('scripts'); ?>
<!-- OPTIONAL SCRIPTS -->
<script src="<?php echo e(asset('public/front/plugins/chart.js/Chart.min.js')); ?>"></script>
<script>
$(function() {
    'use strict'

    var ticksStyle = {
        fontColor: '#495057',
        fontStyle: 'bold'
    }

    var mode = 'index'
    var intersect = true

    var $salesChart = $('#sales-chart')
    // eslint-disable-next-line no-unused-vars
    var salesChart = new Chart($salesChart, {
        type: 'bar',
        data: {
            labels: ['<?=$chart_result['records'][6]['month'];?>',
                '<?=$chart_result['records'][5]['month'];?>',
                '<?=$chart_result['records'][4]['month'];?>',
                '<?=$chart_result['records'][3]['month'];?>',
                '<?=$chart_result['records'][2]['month'];?>',
                '<?=$chart_result['records'][1]['month'];?>',
                '<?=$chart_result['records'][0]['month'];?>'
            ],
            datasets: [{
                    backgroundColor: '#007bff',
                    borderColor: '#007bff',
                    data: ['<?=$chart_result['records'][6]['income'];?>',
                        '<?=$chart_result['records'][5]['income'];?>',
                        '<?=$chart_result['records'][4]['income'];?>',
                        '<?=$chart_result['records'][3]['income'];?>',
                        '<?=$chart_result['records'][2]['income'];?>',
                        '<?=$chart_result['records'][1]['income'];?>',
                        '<?=$chart_result['records'][0]['income'];?>'
                    ]
                },
                {
                    backgroundColor: '#ced4da',
                    borderColor: '#ced4da',
                    data: ['<?=$chart_result['records'][6]['expenses'];?>',
                        '<?=$chart_result['records'][5]['expenses'];?>',
                        '<?=$chart_result['records'][4]['expenses'];?>',
                        '<?=$chart_result['records'][3]['expenses'];?>',
                        '<?=$chart_result['records'][2]['expenses'];?>',
                        '<?=$chart_result['records'][1]['expenses'];?>',
                        '<?=$chart_result['records'][0]['expenses'];?>'
                    ]
                }
            ]
        },
        options: {
            maintainAspectRatio: false,
            tooltips: {
                mode: mode,
                intersect: intersect
            },
            hover: {
                mode: mode,
                intersect: intersect
            },
            legend: {
                display: false
            },
            scales: {
                yAxes: [{
                    // display: false,
                    gridLines: {
                        display: true,
                        lineWidth: '4px',
                        color: 'rgba(0, 0, 0, .2)',
                        zeroLineColor: 'transparent'
                    },
                    ticks: $.extend({
                        beginAtZero: true,

                        // Include a dollar sign in the ticks
                        callback: function(value) {
                            if (value >= 1000) {
                                value /= 1000
                                value += 'k'
                            }


                            return value
                        }
                    }, ticksStyle)
                }],
                xAxes: [{
                    display: true,
                    gridLines: {
                        display: false
                    },
                    ticks: ticksStyle
                }]
            }
        }
    })

    //-------------
    // - PIE CHART -
    //-------------
    // Get context with jQuery - using jQuery's .get() method.

    var chat_labels = [];
    var chat_value = [];
    var chat_color = [];

    <?php $__currentLoopData = $current_game_chart_result; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
    chat_labels.push("<?php echo e($row['title']); ?>");
    chat_value.push("<?php echo e($row['total_amount']); ?>");
    chat_color.push("<?php echo e($row['color']); ?>");
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    var pieChartCanvas = $('#pieChart').get(0).getContext('2d')
    var pieData = {
        labels: chat_labels,
        datasets: [{
            data: chat_value,
            backgroundColor: chat_color
        }]
    }
    var pieOptions = {
        legend: {
            display: false
        }
    }
    // Create pie or douhnut chart
    // You can switch between pie and douhnut using the method below.
    // eslint-disable-next-line no-unused-vars
    var pieChart = new Chart(pieChartCanvas, {
        type: 'doughnut',
        data: pieData,
        options: pieOptions
    })

    //-----------------
    // - END PIE CHART -
    //-----------------

});
</script>
<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.adminLayout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/ff2co/public_html/admin-login.ff2.co.in/resources/views/admin/dashboard.blade.php ENDPATH**/ ?>