<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

Route::get('/', 'Auth\LoginController@admin');
Route::get('index', 'Auth\LoginController@admin');

Route::get('kolkata-fatafat', 'IndexController@pageRequest');
Route::get('delhi-fatafat', 'IndexController@pageRequest');
Route::get('goa-fatafa', 'IndexController@pageRequest');
Route::get('main-bazar', 'IndexController@pageRequest');
Route::get('contact-us', 'IndexController@pageRequest');

Route::get('/clear-cache', function () {
    Artisan::call('cache:clear');
    Artisan::call('config:clear');
    Artisan::call('view:clear');
    return "Cache is cleared";
});

/*
|--------------------------------------------------------------------------
| Admin
|--------------------------------------------------------------------------
|
*/

Route::get('administrator', 'Auth\LoginController@admin');
Route::post('administrator', 'Auth\LoginController@adminAuthentication');
Route::get('admin-logout', 'admin\AdminController@adminlogout');
Route::get('user-bid-info', 'front\ResultController@showbidRequest');
Route::get('entries', 'front\ResultController@teleRequest');

Route::group(['middleware' => ['checkadminauth']], function () {

    # Dashboard
    Route::get('administrator/dashboard', 'admin\AdminController@dashboard');

    # Notification
    Route::get('administrator/notification', 'admin\AdminController@notification');

    # Fcm Topic Subscription
    Route::get('administrator/fcm_topic_subscription', 'admin\AdminController@fcmTopicSubscriptionRequest');

    # UPI
    Route::get('administrator/upi', 'admin\UpiController@upi');
    Route::get('administrator/upi/add', 'admin\UpiController@addUpi');
    Route::get('administrator/upi/edit/{id}', 'admin\UpiController@editUpi');
    Route::post('administrator/upi/save', 'admin\UpiController@saveUpiRequest')->name('upi.save');
    Route::get('administrator/upi/active', 'admin\UpiController@upi_active_request');
    Route::get('administrator/upi/inActive', 'admin\UpiController@upi_inactive_request');
    Route::get('administrator/upi/delete', 'admin\UpiController@deleteUpi');

    Route::get('administrator/upi_request_report', 'admin\PaymentController@upi_request_report');
    Route::get('administrator/upi_request_details_report', 'admin\PaymentController@upi_request_details_report');


    # User
    Route::get('administrator/user', 'admin\UserController@user');
    Route::get('administrator/user/view/{user}', 'admin\UserController@user_show')->name('user.show');
    Route::get('administrator/user/add', 'admin\UserController@addUser');
    Route::get('administrator/user/edit/{id}', 'admin\UserController@editUser');
    Route::post('administrator/user/save', 'admin\UserController@saveUserRequest')->name('user.save');
    Route::get('administrator/user_inactive', 'admin\UserController@userInactive');
    Route::get('administrator/user_active', 'admin\UserController@userActive');
    Route::get('administrator/user_delete', 'admin\UserController@deleteUser');

    # Withdraw
    Route::get('administrator/withdraw_request', 'admin\PaymentController@withdraw_request');
    Route::get('administrator/withdraw_request/accept', 'admin\PaymentController@withdraw_accept_request');
    Route::get('administrator/withdraw_request/reject', 'admin\PaymentController@withdraw_reject_request');

    # Balance
    Route::get('administrator/balance_request', 'admin\PaymentController@balance_request');
    Route::get('administrator/upi_balance_request', 'admin\PaymentController@upi_balance_request');

    Route::get('administrator/balance_request_test', 'admin\PaymentController@balance_request_test');

    Route::get('administrator/balance_request/accept', 'admin\PaymentController@balance_accept_request');
    Route::get('administrator/balance_request/reject', 'admin\PaymentController@balance_reject_request');

    # Balance / Withdraw Report
    Route::get('administrator/balance_request_report', 'admin\PaymentController@balance_request_report');
    Route::get('administrator/withdraw_request_report', 'admin\PaymentController@withdraw_request_report');

    Route::get('administrator/transactions_history', 'admin\PaymentController@transactions_history_report');

    Route::get('administrator/transfer_report', 'admin\PaymentController@transferReport');
    Route::get('administrator/withdraw_report', 'admin\PaymentController@withdrawReport');
    Route::get('administrator/suspected_report', 'admin\PaymentController@suspected_report');
    Route::get('administrator/game_report', 'admin\PaymentController@gameReport');
    Route::get('administrator/profitable_user', 'admin\PaymentController@profitableUserReport');



    # Category
    Route::get('administrator/game_category', 'admin\AdminController@category');
    Route::get('administrator/game_category/add', 'admin\AdminController@addCategory');
    Route::get('administrator/game_category/edit/{id}', 'admin\AdminController@editCategory');
    Route::get('administrator/game_category/delete', 'admin\AdminController@deleteCategory');
    Route::post('administrator/game_category/save', 'admin\AdminController@saveCategoryRequest')->name('category.save');

    # News board
    Route::get('administrator/news_board', 'admin\AdminController@newsBoard');
    Route::post('administrator/news_board/save', 'admin\AdminController@save_news_board_request')->name('newsBoard.save');

    # News
    Route::get('administrator/news', 'admin\AdminController@news');
    Route::get('administrator/news/add', 'admin\AdminController@addNews');
    Route::get('administrator/news/edit/{id}', 'admin\AdminController@editNews');
    Route::get('administrator/news/delete', 'admin\AdminController@deleteNews');
    Route::post('administrator/news/save', 'admin\AdminController@saveNewsRequest')->name('news.save');

    # Slider
    Route::get('administrator/slider', 'admin\AdminController@slider');
    Route::get('administrator/slider/add', 'admin\AdminController@addSlider');
    Route::get('administrator/slider/edit/{id}', 'admin\AdminController@editSlider');
    Route::get('administrator/slider/delete', 'admin\AdminController@deleteSlider');
    Route::post('administrator/slider/save', 'admin\AdminController@saveSliderRequest')->name('slider.save');

    # Slot
    Route::get('administrator/slot', 'admin\AdminController@slot');
    Route::get('administrator/slot/add', 'admin\AdminController@addSlot');
    Route::get('administrator/slot/edit/{id}', 'admin\AdminController@editSlot');
    Route::get('administrator/slot/delete', 'admin\AdminController@deleteSlot');
    Route::post('administrator/slot/save', 'admin\AdminController@saveSlotRequest')->name('slot.save');

    # CP Slot
    Route::get('administrator/cp_slot', 'admin\AdminController@cpSlot');
    Route::get('administrator/cp_slot/add', 'admin\AdminController@addCpSlot');
    Route::get('administrator/cp_slot/edit/{id}', 'admin\AdminController@editCpSlot');
    Route::get('administrator/cp_slot/delete', 'admin\AdminController@deleteCpSlot');
    Route::post('administrator/cp_slot/save', 'admin\AdminController@saveCpSlotRequest')->name('cpSlot.save');

    # Winning Price
    Route::get('administrator/winning-price', 'admin\AdminController@winningPrice');
    Route::get('administrator/winning-price/add', 'admin\AdminController@addWinningPrice');
    Route::get('administrator/winning-price/edit/{id}', 'admin\AdminController@editWinningPrice');
    Route::get('administrator/winning-price/delete', 'admin\AdminController@deleteWinningPrice');
    Route::post('administrator/winning-price/save', 'admin\AdminController@saveWinningPriceRequest')->name('winningprice.save');

    # Money
    Route::get('administrator/money/addition', 'admin\AdminController@addition');
    Route::get('administrator/money/addition/add', 'admin\AdminController@addAddition');
    Route::post('administrator/money/addition/save', 'admin\AdminController@saveAdditionRequest')->name('addition.save');

    Route::get('administrator/money/deduction', 'admin\AdminController@deduction');
    Route::get('administrator/money/deduction/add', 'admin\AdminController@addDeduction');
    Route::post('administrator/money/deduction/save', 'admin\AdminController@saveDeductionRequest')->name('deduction.save');

    # Game Type
    Route::get('administrator/game', 'admin\AdminController@game');
    Route::get('administrator/game/add', 'admin\AdminController@addGame');
    Route::get('administrator/game/edit/{id}', 'admin\AdminController@editGame');
    Route::get('administrator/game/delete', 'admin\AdminController@deleteGame');
    Route::post('administrator/game/save', 'admin\AdminController@saveGameRequest')->name('game.save');

    # Play History
    Route::get('administrator/playhistory/showbid', 'admin\ResultController@showbid');
    Route::get('administrator/playhistory/history', 'admin\ResultController@history');
    Route::get('administrator/playhistory/indivisual', 'admin\ResultController@indivisual');
    Route::get('administrator/playhistory/user_bet_history', 'admin\ResultController@userBetHistory');
    Route::get('administrator/playhistory/delete_user_bet', 'admin\ResultController@deleteUserBet');

    # Game status
    Route::get('administrator/game_status/daily', 'admin\ResultController@dailyReport');
    Route::get('administrator/game_status/monthly', 'admin\ResultController@monthlyReport');
    Route::post('administrator/game_status/login', 'admin\ResultController@gameStatusLogin');
    Route::post('administrator/game_status/betlogin', 'admin\ResultController@gameBetStatusLogin');

    # Result
    Route::get('administrator/result/{slot}', 'admin\ResultController@currentTimeSlotResult');
    Route::get('administrator/resulttest/{slot}', 'admin\ResultController@currentTimeSlotResultTest');
    Route::post('administrator/result/save', 'admin\ResultController@save_result_request');

    Route::get('administrator/prev_result/{slot}', 'admin\ResultController@prevTimeSlotResult');
    Route::post('administrator/prev_result/save', 'admin\ResultController@save_prev_result_request');

    # Delete Result
    Route::get('administrator/delete_result/{slot}', 'admin\Result@currentTimeSlotResult');
    Route::post('administrator/delete_result/save', 'admin\Result@save_result_request');


    #Dev
    Route::get('administrator/dev/game_result', 'admin\ResultController@dev_game_result');



    # Settings
    Route::get('administrator/settings', 'admin\AdminController@settings');
    Route::post('administrator/settings/save', 'admin\AdminController@saveAdminSettings')->name('settings.save');
    Route::post('administrator/upload_logo', 'admin\AdminController@upload_logo_request');

    # Password
    Route::get('profile/password', 'front\MyaccountController@change_password');
    Route::post('user_password_reset', 'front\MyaccountController@passwordReset');


    # upload csv
    Route::post('administrator/upload_csv', 'admin\AdminController@uploadCsvRequest')->name('csv.save');

    # upload image
    Route::post('administrator/upload_image', 'admin\AdminController@uploadImageRequest')->name('image.save');

    # upload Logo
    Route::post('administrator/upload_logo', 'admin\AdminController@uploadLogoRequest')->name('logo.save');

    Route::get('administrator/telescope_entries', 'admin\OrderController@telescope');
});
Route::post('/ajaxpost', 'AjaxController@ajaxpost');
Route::get('show-user-bid-info', 'front\ResultController@showbid');