<!DOCTYPE html>
<html lang="en">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>{{ $title ?? 'No title'}}</title>

{{-- <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,100;0,200;0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,100;1,200;1,300;1,400;1,600;1,700;1,800;1,900&family=Open+Sans:ital,wght@0,300;0,400;0,600;0,700;0,800;1,300;1,400;1,600;1,700;1,800&display=swap" rel="stylesheet"> --}}
<link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Rubik:ital,wght@0,300;0,400;0,500;0,600;0,700;0,800;0,900;1,300;1,400;1,500;1,600;1,700;1,800;1,900&display=swap" rel="stylesheet">

<!-- Font Awesome Icons -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/fontawesome-free/css/all.min.css') }}">
<!-- overlayScrollbars -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/overlayScrollbars/css/OverlayScrollbars.min.css') }}">
<!-- DataTables -->
<link rel="stylesheet" href="{{ asset('public/front/plugins/datatables-bs4/css/dataTables.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('public/front/plugins/datatables-responsive/css/responsive.bootstrap4.min.css') }}">
<link rel="stylesheet" href="{{ asset('public/front/plugins/datatables-buttons/css/buttons.bootstrap4.min.css') }}">
<!-- Theme style -->
<link rel="stylesheet" href="{{ asset('public/front/dist/css/adminlte.min.css') }}">
<link rel="stylesheet" href="{{ asset('public/front/dist/css/custom.css') }}">
</head>
<script>
 var base_url = "{{url('/')}}";
 var csrf_token = "{{csrf_token()}}";
 var prop = <?php echo json_encode(array('url'=>url('/'), 'ajaxurl' => url('/ajaxpost'),  'csrf_token'=>csrf_token()));?>;
</script>

@php
$notification_count=App\Notifications::where('status','N')->orderBy('id', 'DESC')->count();
$notification_list=App\Notifications::where('status','N')->offset(0)->limit(4)->orderBy('id', 'DESC')->get();
@endphp



<!--<body class="hhold-transition skin-blue sidebar-mini">-->
<body class="hold-transition sidebar-mini layout-fixed dark-mode">
<div class="wrapper"> 
  
  <!-- Preloader -->
  <div class="preloader flex-column justify-content-center align-items-center"> <img class="animation__wobble" src="{{ asset('public/front/dist/img/AdminLTELogo.png') }}" alt="AdminLTELogo" height="60" width="60"> </div>
  
  <!-- Navbar --> 
  <!--<nav class="main-header navbar navbar-expand navbar-white navbar-light">-->
  <nav class="main-header navbar navbar-expand navbar-dark"> 
    <!-- Left navbar links -->
    <ul class="navbar-nav">
      <li class="nav-item"> <a class="nav-link" data-widget="pushmenu" href="#" role="button"><i class="fas fa-bars"></i></a> </li>
      <li class="nav-item d-none d-sm-inline-block"> <a href="{{url('/')}}" class="nav-link">Home</a> </li>
    </ul>
    
    <!-- Right navbar links -->
    <ul class="navbar-nav ml-auto">
    <li class="nav-item dropdown" style="display: none"> <a class="nav-link" data-toggle="dropdown" href="#" aria-expanded="false"> <i class="far fa-bell"></i> <span class="badge badge-warning navbar-badge"><?php echo $notification_count; ?></span> </a>
        <div class="dropdown-menu dropdown-menu-lg dropdown-menu-right" style="left: inherit; right: 0px;"> <span class="dropdown-item dropdown-header"><?php echo $notification_count; ?> Notifications</span> @if(!empty($notification_list))
          @foreach($notification_list as $n_row)
          <div class="dropdown-divider"></div>
          <a href="{{ url('administrator/playhistory/user_bet_history') }}?cat_id={{$n_row->category_id}}&slot_id={{$n_row->time_slot_id}}&type_id={{$n_row->play_type}}&phone_number={{$n_row->getUser->phone}}&date={{$n_row->date_slot}}" class="dropdown-item">
          <div class="media"> 
            <!-- <img src="{{ asset('public/admin/dist/img/avatar04.png') }}" alt="User Avatar"
                class="img-size-50 mr-3 img-circle"> -->
            <div class="media-body">
              <h3 class="dropdown-item-title">{{$n_row->getUser->name}}</h3>
              <p class="text-sm">{{$n_row->getUser->phone}}</p>
              <p class="text-sm">{{$n_row->description}}</p>
              <p class="text-sm text-muted"><i class="far fa-clock mr-1"></i> {{ Carbon\Carbon::parse($n_row->created_at)->format('Y-m-d h:i:s A') }}</p>
            </div>
          </div>
          </a> @endforeach
          @else <a href="#" class="dropdown-item">Have No Notification</a> @endif
          <div class="dropdown-divider"></div>
          <a href="{{ url('administrator/notification/') }}" class="dropdown-item dropdown-footer">See All Notifications</a> </div>
      </li>
      <!-- Navbar Search -->
      <li class="nav-item"> <a class="nav-link" href="{{url('admin-logout')}}"> <i class="fas fa-power-off"></i> </a> </li>
    </ul>
  </nav>
  <!-- /.navbar --> 
  
  <!-- Main Sidebar Container --> 
  
  @include('layouts.admin.leftPanelLayout')
  
  @yield('dashboardContent')
  <aside class="control-sidebar control-sidebar-dark"> 
    <!-- Control sidebar content goes here --> 
  </aside>
  <!-- /.control-sidebar --> 
  
  <!-- Main Footer -->
  <footer class="main-footer"> <strong>Copyright &copy; 2025-<?=date('Y');?> <a href="javascript:;">ff2.co.in</a>.</strong> All rights reserved.
    <div class="float-right d-none d-sm-inline-block"> <b>Version</b> 3.1.0 </div>
  </footer>
</div>
<!-- ./wrapper -->

<div class="loader-bg">
  <div class="loader"></div>
</div>






<!-- REQUIRED SCRIPTS --> 
<!-- jQuery --> 
<script src="{{ asset('public/front/plugins/jquery/jquery.min.js') }}"></script> 
<!-- Bootstrap --> 
<script src="{{ asset('public/front/plugins/bootstrap/js/bootstrap.bundle.min.js') }}"></script> 

<!-- DataTables  & Plugins --> 
<script src="{{ asset('public/front/plugins/datatables/jquery.dataTables.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-bs4/js/dataTables.bootstrap4.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-responsive/js/dataTables.responsive.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-responsive/js/responsive.bootstrap4.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-buttons/js/dataTables.buttons.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-buttons/js/buttons.bootstrap4.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/jszip/jszip.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/pdfmake/pdfmake.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/pdfmake/vfs_fonts.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-buttons/js/buttons.html5.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-buttons/js/buttons.print.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/datatables-buttons/js/buttons.colVis.min.js') }}"></script> 

<!-- overlayScrollbars --> 
<script src="{{ asset('public/front/plugins/overlayScrollbars/js/jquery.overlayScrollbars.min.js') }}"></script> 
<!-- AdminLTE App --> 
<script src="{{ asset('public/front/dist/js/adminlte.js') }}"></script> 

<!-- bs-custom-file-input --> 
<script src="{{ asset('public/front/plugins/bs-custom-file-input/bs-custom-file-input.min.js') }}"></script> 
<!-- AdminLTE App --> 

<!-- PAGE PLUGINS --> 
<!-- jQuery Mapael --> 
<script src="{{ asset('public/front/plugins/jquery-mousewheel/jquery.mousewheel.js') }}"></script> 
<script src="{{ asset('public/front/plugins/raphael/raphael.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/jquery-mapael/jquery.mapael.min.js') }}"></script> 
<script src="{{ asset('public/front/plugins/jquery-mapael/maps/usa_states.min.js') }}"></script> 
<!-- ChartJS --> 
<script src="{{ asset('public/front/plugins/chart.js/Chart.min.js') }}"></script> 

<!-- AdminLTE for demo purposes --> 
<script src="{{ asset('public/front/dist/js/demo.js') }}"></script> 
<!-- AdminLTE dashboard demo (This is only for demo purposes) --> 
<!--<script src="{{ asset('public/front/dist/js/pages/dashboard2.js') }}"></script>--> 

<script>

$(window).on('load', function() {
 $('.os-content').attr('style','padding: 0px 8px 0px 0px; height: 100%; width: 100%;');
});
</script>
@stack('scripts')
</body>
</html>
