@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<style>
.tableMd small.label.bg-red {
    padding: 0.2rem 0.5rem;
    border-radius: 0.2rem;
}
.dark-mode .bg-red, .dark-mode .bg-red>a {
    color: #fff!important;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row mb-2">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">@include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table tableMd table-bordered table-striped text-nowrap">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Status</th>
                      <th>Action</th>
                      <th>Date</th>
                      <th>Name</th>
                      <th>Amount</th>
                      <th>Transfer Mode</th>
                      <th>Bank</th>
                      <th>AC No</th>
                      <th>IFSC</th>
                      <th>Paytm No</th>
                      <th>Phone No</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @php $i=1; @endphp
                  @foreach($withdraw_request_list['records'] as $row)
                  <tr>
                    <td>{{ $i }}</td>
                    <td id="action_{{$row->id}}">@if($row->status=='pending') <a href="javascript:;" class="btn btn-success btn-xs status-icon accept_btn" data-toggle="tooltip" title="Accept" data-id="{{ $row->id }}"><i class="fa fa-check"></i>Accept</a> <a href="javascript:;" class="btn btn-danger btn-xs status-icon reject_btn" data-toggle="tooltip" title="Reject" data-id="{{ $row->id }}"><i class="fa fa-times"></i>Reject</a>@endif</td>
                    <td id="status_{{$row->id}}">@if($row->status=='pending')<small class="label bg-yellow">Pending</small>@elseif($row->status=='rejected')<small class="label bg-red">Rejected</small>@else($row->status=='pending')<small class="label bg-green">Paid</small>@endif</td>
                    <td>{{ \Carbon\Carbon::parse($row->created_at)->format('M d Y h:i a') }}</td>
                    <td>{{ $row->customer_name }}</td>
                    <!--<td><i class="fa fa-inr"></i> {{ $row->amount }}</td>-->
                    <td style="float: right;"><i class="fa fa-inr"></i> {{ (new NumberFormatter('en_IN', NumberFormatter::DECIMAL))->format($row->amount) }}</td>
                    <td>{{ $row->payment_method }}</td>
                    <td>{{ $row->bank_name }}</td>
                    <td>{{ $row->ac_no }}</td>
                    <td>{{ $row->ifsc }}</td>
                    <td>{{ $row->paytm_no }}</td>
                    <td>{{ $row->phone_no }}</td>
                  </tr>
                  @php $i++; @endphp
                  @endforeach
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div id="dialog-empty" title="Alert" style="display: none;">
  <p>Please select an action.</p>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Accept ?</p>
</div>
<div id="dialog-confirm2" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Reject?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script> 
<script>
$(function () {
    //$('#example1').DataTable()
		$('#example1').dataTable({
		//"lengthMenu": [[50, 100, 200, -1], ["50", "100", "200", "All"]],
		//"pageLength": 50
		"paging": false,
		"ordering": true,
		"scrollY": "678px",
		"scrollCollapse": true,
		"scrollX": true,
		"stripeClasses": [ 'strip1' ],
		"language" :  {"lengthMenu": "_MENU_ records"},
		"initComplete": function(settings, json) {
			//$('tr.gradeA').css("background-color", "#ff8");
			//console.log(oTable);
		}
	});
  });
$(function() {
      $(document).on('click','.accept_btn',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					//location.href = "<?=url('/administrator/withdraw_request/accept?id=')?>" + id;
					
					$('#action_'+id).html('');
					$('#status_'+id).html('<small class="label bg-green">Paid</small>');
					
					$.ajax({
						type: 'GET',
						url: "<?=url('/administrator/withdraw_request/accept?id=')?>" + id,
						data: '',
						cache: false,
						contentType: false,
						processData: false,
						dataType: "json",
						beforeSend: function() {
							//$('.loader-bg').fadeIn();
						},
						complete: function() {
							//$('.loader-bg').fadeOut();
							//$('#action_'+id).html('');
							//$('#status_'+id).html('<small class="label bg-green">Paid</small>');
							
						},
						success: function(json) {
							
							
						},
						error: function(xhr, ajaxOptions, thrownError) {
							//alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
						}
					});
                    
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
	  $(document).on('click','.reject_btn',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm2").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					//location.href = "<?=url('/administrator/withdraw_request/reject?id=')?>" + id;
					
					$('.loader-bg').fadeOut();
					$('#action_'+id).html('');
					$('#status_'+id).html('<small class="label bg-red">Rejected</small>');
					
					$.ajax({
						type: 'GET',
						url: "<?=url('/administrator/withdraw_request/reject?id=')?>" + id,
						data: '',
						cache: false,
						contentType: false,
						processData: false,
						dataType: "json",
						beforeSend: function() {
							//$('.loader-bg').fadeIn();
						},
						complete: function() {
							//$('.loader-bg').fadeOut();
							//$('#action_'+id).html('');
							//$('#status_'+id).html('<small class="label bg-red">Rejected</small>');
						},
						success: function(json) {
							
						},
						error: function(xhr, ajaxOptions, thrownError) {
							//alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
						}
					});
                    
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
}); 
</script> 
@endpush
@endsection 