@extends('layouts.admin.adminLayout')
@section('dashboardContent') 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{url('administrator/winning-price')}}">Winning Price</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="card card-default"> {{Form::open(['route'=>['winningprice.save'],'name'=>'winningprice','id' =>'winningprice-form','files'=>true])}}
        <input type="hidden" name="calculation_id" value="{{$data->id ?? ''}}" />
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="category_id">Category</label>
                <select class="form-control" name="category_id" id="category_id">
                  <option value="">--Select Category--</option>
                  @foreach($category_list as $row)
                  <option value="{{ $row->id }}" @php if(isset($data->category_id)){if($row->id==$data->category_id){ echo 'selected="selected"';}} @endphp> {{ $row->label }} </option>
                   @endforeach
                </select>
              </div>
              
              <div class="form-group">
                <label for="play_type">Type</label>
                <select class="form-control" name="play_type" id="play_type">
                  <option value="">--Select Type--</option>
                  @foreach($type_list as $row)
                  <option value="{{ $row->id }}" @php if(isset($data->play_type)){if($row->id==$data->play_type){ echo 'selected="selected"';}} @endphp> {{ $row->name }} </option>
                   @endforeach
                </select>
              </div>
              
              <div class="form-group">
                <label for="calculation_type">Calculation Type</label>
                <select class="form-control" name="calculation_type" id="calculation_type">
                  <option value="">--Select Calculation Type--</option>
                  <option value="1" @php if(isset($data->calculation_type)){if($data->calculation_type==1){ echo 'selected="selected"';}} @endphp> Multiply </option>
                  <option value="2" @php if(isset($data->calculation_type)){if($data->calculation_type==2){ echo 'selected="selected"';}} @endphp echo> Percentage </option>
                </select>
              </div>
              <div class="form-group">
                <label for="value">Value</label>
                <input type="text" class="form-control" id="value" name="value" placeholder="Enter Value" value="{{$data->value ?? ''}}">
              </div>
            </div>
          </div>
        </div>
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">Submit</button>
        </div>
        {{Form::close()}} </div>
    </div>
  </section>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 
<script>
$(function() {
    $("#winningprice-form").validate({
        errorElement: "span",
        rules: {
            category_id: "required",
            play_type: "required",
            calculation_type: "required",
			value: "required"
			
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});
</script> 
@endpush
@endsection 