@extends('layouts.admin.adminLayout')
@section('dashboardContent')

<style>
  .dropdown-menu {
    position: absolute;
    top: 100%;
    left: 0;
    z-index: 1000;
    float: left;
    min-width: 10rem;
    padding: 0.5rem 0;
    margin: 0.125rem 0 0;
    font-size: 1rem;
    color: #212529;
    text-align: left;
    list-style: none;
    background-color: #fff !important;
    background-clip: padding-box;
    border: 1px solid rgba(0,0,0,.15);
    border-radius: 0.25rem;
    box-shadow: 0 0.5rem 1rem rgba(0,0,0,.175);
}
.dark-mode .dropdown-item a {
  color: #000 !important;
}

.dark-mode a:not(.btn):hover {
  color: #fff !important;
}
.tableMd small.label.bg-danger {
  padding: 0.2rem 0.5rem;
  border-radius: 0.2rem;
}
</style>
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title ?? '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  <!-- Content Header (Page header) --> 
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid">@include('messages.flash_messages')
      <div class="row">
        <div class="col-md-12">
          <div class="card">
            <div class="card-body">
              <form action="" method="get">
                <div class="row">
                  
                  <div class="col-lg-2 col-md-2 col-sm-6 col-12">
                    <div class="form-group">
                      <label>User Status:</label>
                      <select class="selectOption" name="user_status" id="user_status">
                        <option value="">All</option>
                        <option value="active" @php if(isset($_GET['user_status'])){if('active'==$_GET['user_status']){ echo 'selected="selected"';}} @endphp> Active </option>
                        <option value="inactive" @php if(isset($_GET['user_status'])){if('inactive'==$_GET['user_status']){ echo 'selected="selected"';}} @endphp> In-Active </option>
                      </select>
                    </div>
                  </div>
                  <div class="col-6">
                    <div class="form-group w-100 d-flex justify-content-center">
                      <button type="submit" class="btn btn-info"><i class="fas fa-search"></i> SEARCH</button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
          </div>
        </div>
        <div class="col-md-12">
          <div class="card">
            <div class="card-header">
              <h3 class="card-title">User List</h3>
            </div>
            <!-- /.card-header -->
            <div class="card-body">
              <div class="table-responsive">
                <table id="example1" class="table table-bordered table-striped tableMd">
                  <thead>
                    <tr>
                      <th>#</th>
                      <th>Info</th>
                      <th>Name</th>
                      <th>Balance</th>
                      <th>Phone</th>
                      <th>Status</th>
                      <th>Date created</th>
                      <th>Action</th>
                    </tr>
                  </thead>
                  <tbody>
                  
                  @php $i=1;@endphp
                  @foreach($user_list['records'] as $row)
                  <tr>
                    <td>{{ $i }}</td>
                    <td><a href="javascript:;"
                      class="btn btn-info btn-xs status-icon info_btn"
                      data-toggle="tooltip" title="Payment History"
                      data-id="{{ $row['id'] }}" data-user_id="{{ $row['id'] }}"><i
                          class="fa fa-info-circle"></i> Info</a></td>
                    <td>{{ $row['name'] }}</td>
                    <td> @if($row['balance']>10) <small class="label bg-green"><i class="fas fa-rupee-sign"></i> {{ $row['balance'] }}</small> @else <small class="label bg-yellow"><i class="fas fa-rupee-sign"></i> {{ $row['balance'] }}</small> @endif </td>
                    <td>{{ $row['phone'] }}</td>
                    <td>@if($row['status']==1)<small class="label bg-green">Active</small>@else<small class="label bg-danger">In-active</small>@endif</td>
                    <td>{{ $row['created_at'] }}</td>
                    <td>
                      <!-- <a href="{{ route('user.show', $row['id'])}}" class="btn btn-success btn-sm" data-toggle="tooltip" title="View"><i class="fas fa-eye"></i></a> <a href="javascript:;" class="btn btn-danger btn-sm delete-icon" data-id="{{$row['id']}}" data-toggle="tooltip" title="Remove"><i class=" fa fa-trash"></i></a> -->

                      <div class="btn-group">
                  <button type="button" class="btn btn-success btn-flat">Action</button>
                  <button type="button" class="btn btn-success btn-flat dropdown-toggle" data-toggle="dropdown">
                    <span class="caret"></span>
                    <span class="sr-only">Toggle Dropdown</span>
                  </button>
                  <ul class="dropdown-menu" role="menu">
                    <li class="dropdown-item"><a href="{{ route('user.show', $row['id'])}}"> <i class="fas fa-eye"></i> View</a></li>
                    <li class="dropdown-item"><a class="delete-icon" data-id="{{$row['id']}}" href="javascript:;"><i class=" fa fa-trash"></i> Remove</a></li>
                    @if($row['status']==1)
                    <li class="dropdown-item inactive-icon" data-id="{{$row['id']}}"><a href="javascript:;"><i class="fa fa-user-times" aria-hidden="true"></i> In-active</a></li>
                    @else
                    <li class="dropdown-item active-icon" data-id="{{$row['id']}}"><a href="javascript:;"><i class="fa fa-user-plus" aria-hidden="true"></i> Active</a></li>
                    @endif
                   
                  </ul>
                </div>
                    
                    </td>
                  </tr>
                  @php $i++;@endphp
                  @endforeach
                    </tbody>
                  
                </table>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  </section>
</div>
<div class="example-modal">
  <div class="modal" id="transaction_history_modal">
      <div class="modal-dialog modal-lg">
          <div class="modal-content">
              <div class="modal-header">
                  <h4 class="modal-title" id="modal-title">Transaction history </h4>
                  <button type="button" class="close" data-dismiss="modal" aria-label="Close"> <span
                          aria-hidden="true">×</span></button>
              </div>
              <div class="modal-body">
                  <div class="col-md-12">
                      <div class="card">
                          <div class="card-header p-2">
                              <ul class="nav nav-pills">
                                  <li class="nav-item"><a class="nav-link active" href="#withdraw_sec"
                                          data-toggle="tab">Withdraw</a></li>
                                  <li class="nav-item"><a class="nav-link" href="#deposit_sec"
                                          data-toggle="tab">Deposit</a></li>
                                  <li class="nav-item"><a class="nav-link" href="#report_sec" data-toggle="tab">Report</a></li>
                              </ul>
                          </div>
                          
                          <div class="card-body">
                              <div class="tab-content">
                                  <div class="active tab-pane" id="withdraw_sec">
                                      <div class="col-md-12">
                                          <div class="box">
                                              <div class="box-header">
                                                  <h3 class="box-title">Last 10 Withdraw History</h3>
                                              </div>
                                              <!-- /.box-header -->
                                              <div class="box-body no-padding">
                                                  <table class="table table-striped">
                                                      <tr>
                                                          <th style="width: 10px">#</th>
                                                          <th>Amount</th>
                                                          <th>Transfer Mode</th>
                                                          <th>Date</th>
                                                      </tr>
                                                      <tbody id="withdraw_transaction_history_sec">
                                                          <tr>
                                                          </tr>
                                                      </tbody>
                                                      <!--<td><span class="badge bg-red">55%</span></td>
                      <td><span class="badge bg-yellow">70%</span></td>
                      <td><span class="badge bg-green">90%</span></td>-->

                                                  </table>
                                              </div>
                                              <!-- /.box-body -->
                                          </div>
                                          <!-- /.box -->
                                      </div>
                                  </div>
                                  <div class="tab-pane" id="deposit_sec">
                                      <div class="col-md-12">
                                          <div class="box">
                                              <div class="box-header">
                                                  <h3 class="box-title">Last 10 Deposit History</h3>
                                              </div>
                                              <!-- /.box-header -->
                                              <div class="box-body no-padding">
                                                  <table class="table table-striped">
                                                      <tr>
                                                          <th style="width: 10px">#</th>
                                                          <th>Amount</th>
                                                          <th>Transfer Mode</th>
                                                          <th>Date</th>
                                                      </tr>
                                                      <tbody id="deposit_transaction_history_sec">
                                                          <tr>
                                                          </tr>
                                                      </tbody>
                                                  </table>
                                              </div>
                                              <!-- /.box-body -->
                                          </div>
                                          <!-- /.box -->
                                      </div>
                                  </div>
                                  <div class="tab-pane" id="report_sec">
                                      <div class="col-md-12">
                                        <div class="box">
                                          <div class="box-header">
                                            <h3 class="box-title">Report</h3>
                                          </div>
                                          <!-- /.box-header -->
                                          <div class="box-body no-padding">
                                            <table class="table table-striped">
                                              <tr>
                                                <th>Total Withdraw</th>
                                                <th>Total Deposit</th>
                                                <th>Total Wallet</th>
                                                <th>Total Profit</th>
                                              </tr>
                                               <tbody id="transaction_report_sec">
                                              <tr> 
                                              </tr>
                                              </tbody>
                                            </table>
                                          </div>
                                          <!-- /.box-body --> 
                                        </div>
                                        <!-- /.box --> 
                                      </div>
                                    </div>
                              </div>
                          </div>
                      </div>
                  </div>
              </div>
              <div class="modal-footer justify-content-between">
                  <button type="button" class="btn btn-default" data-dismiss="modal">Close</button>
              </div>
          </div>
      </div>
  </div>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to delete this permanently?</p>
</div>
<div id="dialog-inactive-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to In-active this permanently?</p>
</div>
<div id="dialog-active-confirm" title="Confirmation" style="display: none;">
  <p>Are you sure you want to Active this ?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts') 
<link href="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/themes/smoothness/jquery-ui.css" rel="stylesheet" />
<script src="https://ajax.googleapis.com/ajax/libs/jqueryui/1.12.1/jquery-ui.min.js"></script>
<script>
$(function () {
    $('#example1').DataTable();
    $(document).on('click', '.info_btn', function() {
        var user_id = $(this).attr("data-user_id");
        $.ajax({
            url: prop.ajaxurl,
            type: "post",
            data: {
                user_id: user_id,
                action: 'get_transaction_history',
                _token: prop.csrf_token
            },
            beforeSend: function() {
                $('.loader-bg').fadeIn();
            },
            success: function(response) {
                $('.loader-bg').fadeOut();
                const obj_response = JSON.parse(response);
                $('#withdraw_transaction_history_sec').html(obj_response.withdraw_html);
                $('#deposit_transaction_history_sec').html(obj_response.deposite_html);
                $('#transaction_report_sec').html(obj_response.report_html);

                $('#transaction_history_modal').modal('show');
            },

            error: function(jqXHR, textStatus, errorThrown) {
                $('.loader-bg').fadeOut();
                console.log(textStatus, errorThrown);
            }
        });
    });
  })
  
$(function() {
	$(document).on('click','.delete-icon',function(){
        var id = $(this).attr("data-id");
        $("#dialog-confirm").dialog({
            resizable: false,
            height: 200,
            width: 'auto',
            modal: true,
            buttons: {
                "Yes": function() {
                    $(this).dialog("close");
					location.href = "<?=url('/administrator/user_delete?id=')?>" + id;
                    
                },
                No: function() {
                    $(this).dialog("close");
                }
            }
        });
    });
  $(document).on('click','.inactive-icon',function(){
      var id = $(this).attr("data-id");
      $("#dialog-inactive-confirm").dialog({
          resizable: false,
          height: 200,
          width: 'auto',
          modal: true,
          buttons: {
              "Yes": function() {
                  $(this).dialog("close");
                  location.href = "<?=url('/administrator/user_inactive?id=')?>" + id;
              },
              No: function() {
                  $(this).dialog("close");
              }
          }
      });
  });
  $(document).on('click','.active-icon',function(){
    var id = $(this).attr("data-id");
    $("#dialog-active-confirm").dialog({
        resizable: false,
        height: 200,
        width: 'auto',
        modal: true,
        buttons: {
            "Yes": function() {
                $(this).dialog("close");
                location.href = "<?=url('/administrator/user_active?id=')?>" + id;
            },
            No: function() {
                $(this).dialog("close");
            }
        }
    });
});
});  
  
</script> 
@endpush
@endsection 