@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row">
                <div class="col-sm-6">
                    <h1 class="m-0">{{ $title ?? '' }}</h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{ url('administrator/dashboard') }}">Home</a></li>
                        <li class="breadcrumb-item"><a href="{{ url('administrator/upi') }}">UPI LIST</a></li>
                        <li class="breadcrumb-item active">{{ $breadcumbs ?? 'No title' }}</li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid"> @include('messages.flash_messages')
            <div class="card card-default">
                {{ Form::open(['route' => ['upi.save'], 'id' => 'upi-form', 'files' => true]) }}
                <input type="hidden" name="upi_id" value="{{ $data->id ?? '' }}" />

                <div class="card-body">
                    <div class="row">
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category_id">Payment Method</label>
                                <select class="form-control" name="type" id="type">
                                    <option value="">--Select Method--</option>
                                    <option value="phonepe" @php if(isset($data->type)){if($data->type=='phonepe'){ echo
                                        'selected="selected"';}} @endphp> PhonePe </option>
                                    <option value="gpay" @php if(isset($data->type)){if($data->type=='gpay'){ echo
                                        'selected="selected"';}} @endphp> Gpay </option>
                                    <option value="paytm" @php if(isset($data->type)){if($data->type=='paytm'){ echo
                                        'selected="selected"';}} @endphp> Paytm </option>

                                </select>
                            </div>

                            <div class="form-group">
                                <label for="category_id">Payment Type</label>
                                <select class="form-control" name="payment_type" id="payment_type">
                                    <option value="">--Select Type--</option>
                                    <option value="upi" @php if(isset($data->
                                        payment_type)){if($data->payment_type=='upi'){ echo 'selected="selected"';}}
                                        @endphp> UPI </option>
                                    <option value="scan" @php if(isset($data->
                                        payment_type)){if($data->payment_type=='scan'){ echo 'selected="selected"';}}
                                        @endphp> Scan </option>
                                </select>
                            </div>

                            <div class="form-group upi input_group_sec">
                                <label for="label">Title</label>
                                <input type="text" class="form-control" id="title" name="title"
                                    placeholder="Enter Title" value="{{$data->title ?? ''}}">
                            </div>

                            <div class="form-group upi input_group_sec">
                                <label for="label">UPI</label>
                                <input type="text" class="form-control" id="upi" name="upi" placeholder="Enter UPI"
                                    value="{{$data->upi ?? ''}}">
                            </div>
                            <div class="form-group upi input_group_sec">
                                <label for="label">Payee Name</label>
                                <input type="text" class="form-control" id="payeeName" name="payeeName"
                                    placeholder="Enter Payee Name" value="{{$data->payeeName ?? ''}}">
                            </div>
                            <input type="hidden" name="status" value="{{$data->status ?? 'N'}}" />
                        </div>
                        <div class="col-md-6">
                            <div class="form-group">
                                <label for="category">QR Image</label>
                                <div class="col-auto"> <a href="javascript:;" class="preview fetch_image"
                                        id="thumb-image"><img src="{{ $thumb ??  ''}}" alt="{{ $thumb ?? ''}}"
                                            width="150px"></a>
                                    <input type="hidden" name="image" value="{{$data->qr_img ?? ''}}" id="input-image">
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="card-footer">
                    <button type="submit" class="btn btn-primary">Submit</button>
                </div>
                {{ Form::close() }}
            </div>
        </div>
    </section>
</div>
<div style="display:none;">
    {{Form::open(['route'=>['image.save'],'class'=>'form-image-upload', 'id' => 'form-image-upload','files'=>true])}}
    <input name="upload_photo" id="upload_photo" style="display:none" onchange="preview_image(this.files)" type="file">
    </form>
</div>
<div id="dialog-confirm" title="Confirmation" style="display: none;">
    <p>Are you sure you want to add this UPI?</p>
</div>
@push('stylesheet')
@endpush
@push('scripts')
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script>
<script>
$(document).on('click', '.fetch_image', function(e) {
    $('#upload_photo').click();
});

function preview_image(files) {

    input = document.getElementById('upload_photo');
    var files = !!input.files ? input.files : [];
    if (!files.length || !window.FileReader) return;
    if (/^image/.test(files[0].type)) {
        var reader = new FileReader(); // instance of the FileReader
        reader.readAsDataURL(files[0]); // read the local file
        reader.onloadend = function() { // set image data as background of div
            $("#form-image-upload").submit()
            //$("#view_image_"+index).attr("src",this.result);  
            //$("#thumb-image").find('img').attr('src', this.result).css("height", "150px").css("height", "150px");;
        }
    }
}
$(document).ready(function() {
    $('#form-image-upload').submit(function(evt) {
        evt.preventDefault();
        var formData = new FormData(this);
        if ($('input[name=\'upload_photo\']').val() != '') {
            var upload_photo_id = $('#upload_photo_id').val();
            $.ajax({
                type: 'POST',
                url: $(this).attr('action'),
                data: formData,
                cache: false,
                contentType: false,
                processData: false,
                dataType: "json",
                beforeSend: function() {
                    $('.loader-bg').fadeIn();
                },
                complete: function() {
                    $('.loader-bg').fadeOut();
                    $('#form-image-upload')[0].reset();
                },
                success: function(json) {
                    ;
                    if (json[0].success == 1) {
                        $("#thumb-image").find('img').attr('src', json[0].image_path);
                        $("#input-image").val(json[0].file_name);
                        //$('#button-clear').show();
                    } else {
                        alert(json[0].error_message);
                    }
                },
                error: function(xhr, ajaxOptions, thrownError) {
                    //alert(thrownError + "\r\n" + xhr.statusText + "\r\n" + xhr.responseText);
                }
            });
        }
    });
});

$(function() {
    $("#upi-form").validate({
        errorElement: "span",
        rules: {
            type: "required",
            name: "required",
            upi: "required",
            payment_type: "required",
            payeeName: "required",
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});
</script>
@endpush
@endsection