@extends('layouts.admin.adminLayout')
@section('dashboardContent')
<div class="content-wrapper">
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1 class="m-0">Dashboard</h1>
                </div>
                <!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <li class="breadcrumb-item"><a href="{{url('administrator')}}">Home</a></li>
                        <li class="breadcrumb-item active">Dashboard</li>
                    </ol>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <!-- Small boxes (Stat box) -->
            <div class="row">
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-info">
                        <div class="inner">
                            <h3>{{$total_user}}</h3>
                            <p>User</p>
                        </div>
                        <div class="icon"> <i class="ion ion-bag"></i> </div>
                        <a href="{{url('administrator/user')}}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-success">
                        <div class="inner">
                            <h3>{{$total_withdraw_request}}</h3>
                            <p>Withdraw Request</p>


                        </div>
                        <div class="icon"> <i class="ion ion-stats-bars"></i> </div>
                        <a href="{{url('administrator/withdraw_request')}}" class="small-box-footer">Total Pending-
                            <span class="badge badge-warning right"
                                style="font-weight: bold;">{{$total_withdraw_pending_request}}</span> <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-warning">
                        <div class="inner">
                            <h3>{{$total_balance_request}}</h3>
                            <p>Balance Request</p>
                        </div>
                        <div class="icon"> <i class="ion ion-person-add"></i> </div>
                        <a href="{{url('administrator/balance_request')}}" class="small-box-footer">Total Pending-
                            <span class="badge badge-info right"
                                style="font-weight: bold;">{{$total_balance_pending_request}}</span> <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                <div class="col-lg-3 col-6">
                    <!-- small box -->
                    <div class="small-box bg-danger">
                        <div class="inner">
                            <h3>{{$total_user_balance}}</h3>
                            <p>Total Wallet Balance</p>
                        </div>
                        <div class="icon"> <i class="ion ion-pie-graph"></i> </div>
                        <a href="{{url('administrator/user?type=wallet')}}" class="small-box-footer">More info <i
                                class="fas fa-arrow-circle-right"></i></a>
                    </div>
                </div>
                <!-- ./col -->
                
                <div class="col-lg-12">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">Today Game Usage</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-8">
                                    <div class="chart-responsive">
                                        <canvas id="pieChart" height="150"></canvas>
                                    </div>
                                    <!-- ./chart-responsive -->
                                </div>
                                <!-- /.col -->
                                <div class="col-md-4">
                                    <ul class="chart-legend clearfix">
                                        @foreach($current_game_chart_result as $row)
                                        <li style="font-size:14px"><i class="far fa-circle"
                                                style="color:{{$row['color']}}"></i> {{$row['title']}}</li>
                                        @endforeach
                                    </ul>
                                </div>
                                <!-- /.col -->
                            </div>
                            <!-- /.row -->
                        </div>
                        <!-- /.card-body -->
                        <div class="card-footer bg-light p-0">
                            <ul class="nav nav-pills flex-column">
                                @foreach($current_game_chart_result as $row)
                                <li class="nav-item"> <a href="javascript:;" class="nav-link"
                                        style="color:{{$row['color']}}"> {{$row['title']}} <span class="float-right"
                                            style="color:{{$row['color']}}"> Total:-₹{{$row['total_amount']}}- Total
                                            Win:-₹{{$row['total_win_amount']}}</span> </a> </li>
                                @endforeach
                            </ul>
                        </div>
                        <!-- /.footer -->
                    </div>
                </div>
            </div>
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
</div>
@push('stylesheet')
@endpush
@push('scripts')
<!-- OPTIONAL SCRIPTS -->
<script src="{{ asset('public/front/plugins/chart.js/Chart.min.js') }}"></script>
<script>
$(function() {
    'use strict'

    var ticksStyle = {
        fontColor: '#495057',
        fontStyle: 'bold'
    }

    var mode = 'index'
    var intersect = true

    

    //-------------
    // - PIE CHART -
    //-------------
    // Get context with jQuery - using jQuery's .get() method.

    var chat_labels = [];
    var chat_value = [];
    var chat_color = [];

    @foreach($current_game_chart_result as $row)
    chat_labels.push("{{$row['title']}}");
    chat_value.push("{{$row['total_amount']}}");
    chat_color.push("{{$row['color']}}");
    @endforeach

    var pieChartCanvas = $('#pieChart').get(0).getContext('2d')
    var pieData = {
        labels: chat_labels,
        datasets: [{
            data: chat_value,
            backgroundColor: chat_color
        }]
    }
    var pieOptions = {
        legend: {
            display: false
        }
    }
    // Create pie or douhnut chart
    // You can switch between pie and douhnut using the method below.
    // eslint-disable-next-line no-unused-vars
    var pieChart = new Chart(pieChartCanvas, {
        type: 'doughnut',
        data: pieData,
        options: pieOptions
    })

    //-----------------
    // - END PIE CHART -
    //-----------------

});
</script>
@endpush
@endsection