@extends('layouts.admin.adminLayout')
@section('dashboardContent') 
<!-- Content Wrapper. Contains page content -->
<div class="content-wrapper"> 
  <!-- Content Header (Page header) -->
  <div class="content-header">
    <div class="container-fluid">
      <div class="row">
        <div class="col-sm-6">
          <h1 class="m-0">{{ $title or '' }}</h1>
        </div>
        <!-- /.col -->
        <div class="col-sm-6">
          <ol class="breadcrumb float-sm-right">
            <li class="breadcrumb-item"><a href="{{url('administrator/dashboard')}}">Home</a></li>
            <li class="breadcrumb-item"><a href="{{url('administrator/cp_slot')}}">CP Digits</a></li>
            <li class="breadcrumb-item active">{{ $breadcumbs or 'No title'}}</li>
          </ol>
        </div>
        <!-- /.col --> 
      </div>
      <!-- /.row --> 
    </div>
    <!-- /.container-fluid --> 
  </div>
  
  <!-- Main content -->
  <section class="content">
    <div class="container-fluid"> @include('messages.flash_messages')
      <div class="card card-default"> {{Form::open(['route'=>['cpSlot.save'],'name'=>'cpSlot','id' =>'cpSlot-form','files'=>true])}}
        <input type="hidden" name="cp_id" value="{{$data->id ?? ''}}" />
        <div class="card-body">
          <div class="row">
            <div class="col-md-6">
              <div class="form-group">
                <label for="label">Digit</label>
                <input type="text" class="form-control" id="digit" name="digit" placeholder="Enter Digit" value="{{$data->digit ?? ''}}">
              </div>
              
              <div class="form-group">
                <label for="status">Status</label>
                <select class="form-control" name="status" id="status">
                  <option value="">--Select Status--</option>
                  <option value="1" @php if(isset($data->status)){if($data->status==1){ echo 'selected="selected"';}} @endphp> Active </option>
                  <option value="0" @php if(isset($data->status)){if($data->status==0){ echo 'selected="selected"';}} @endphp echo> InActive </option>
                </select>
              </div>
            </div>
            
            
            
          </div>
        </div>
        <div class="card-footer">
          <button type="submit" class="btn btn-primary">Submit</button>
        </div>
        {{Form::close()}} </div>
    </div>
  </section>
</div>
<div style="display:none;"> {{Form::open(['route'=>['image.save'],'class'=>'form-image-upload', 'id' => 'form-image-upload','files'=>true])}}
  <input name="upload_photo" id="upload_photo" style="display:none" onchange="preview_image(this.files)" type="file">
  </form>
</div>
@push('stylesheet')

@endpush
@push('scripts') 
<script src="https://ajax.aspnetcdn.com/ajax/jquery.validate/1.11.1/jquery.validate.min.js"></script> 
<script>
$(function() {
    $("#cpSlot-form").validate({
        errorElement: "span",
        rules: {
			digit: {
				required: true,
				min: 3,
				digits: true
			},
            status: "required"
        },
        messages: {},
        errorElement: "em",
        errorPlacement: function(error, element) {
            // Add the `help-block` class to the error element
            error.addClass("help-block");
            error.insertAfter(element);
        },
        highlight: function(element, errorClass, validClass) {
            $(element).addClass("has-error").removeClass("has-success");
        },
        unhighlight: function(element, errorClass, validClass) {
            $(element).addClass("has-success").removeClass("has-error");
        },
        submitHandler: function(form) {
            form.submit();
        }
    });
});






</script> 
@endpush
@endsection 