<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Withdraw_request extends Model
{
    protected $table 	= 'withdraw_request';
	protected $guarded	= [];

	// public function getBankDesc() {
    //     return $this->hasOne('App\User_bank', 'user_id', 'user_id');
    // }
	
	public function customer_details(){
        return $this->hasOne(User::class,'id','user_id');
    }
	
	public function getBankDesc() {
		return $this->hasOne('App\User_bank', 'user_id', 'user_id');
	}
	public function getUser() {
        return $this->hasOne('App\User', 'id', 'user_id');
    }
	
	
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_payments = DB::table('withdraw_request');
        if($search != '') {
            $total_payments = $total_payments->where(function($total_payments) use ($search) {
                $total_payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
        
		
		$total_payments = $total_payments->count();
		
		$payments = DB::table('withdraw_request')->select('withdraw_request.*','user_bank.bank_name','user_bank.ac_no','user_bank.ifsc','user_bank.paytm_no','user_bank.phone_no','users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'withdraw_request.user_id')->leftJoin('user_bank', 'user_bank.user_id', 'withdraw_request.user_id');
		if($search != '') {
            $payments = $payments->where(function($payments) use ($search) {
				$payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$payments = $payments->orderby('id', 'DESC')->offset(0)->limit(300)->get();
		//$payments = $payments->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $payments;
		$return['total_orders'] = $total_payments;
		return $return;
	}
	
	public static function get_report_data($param = array()) {
		$payments		= array();
		
		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate']:'';
		$todate 		= isset($param['todate'])?$param['todate']:'';
		$status 		= isset($param['status'])?$param['status']:'';
		
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		
		
		
		if($fromdate!=''){
			$payments = DB::table('withdraw_request')->select('withdraw_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'withdraw_request.user_id')->where('withdraw_request.status', 'completed');
			$payments = $payments->whereDate('withdraw_request.created_at',$fromdate);
			$payments = $payments->orderby('id', 'ASC')->get();		
		}
		
		$return['records'] 		= $payments;
		return $return;
	}
	
	public static function get_transfer_report($param = array()) {
		$payments		= array();
		
		$search 		= $param['search'];
		$fromdate 		= isset($param['fromdate'])?$param['fromdate'].' 00:00:00':'';
		$todate 		= isset($param['todate'])?$param['todate'].' 23:59:59':'';
		$status 		= isset($param['status'])?$param['status']:'';
		
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		//print_r($fromdate.'-'.$todate);exit;
		
		
		if($fromdate!='' || $todate!='' ){
			$payments = DB::table('withdraw_request')->select('withdraw_request.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'withdraw_request.user_id')->where('withdraw_request.status', 'completed');
			if($fromdate!='' && $todate!=''){
				$payments = $payments->where('withdraw_request.created_at', '>=', $fromdate)->where('withdraw_request.created_at', '<=', $todate);
			}else{
				if($fromdate!=''){
					
					$payments = $payments->where('withdraw_request.created_at', '>=', $fromdate)->where('withdraw_request.created_at', '<=', $param['fromdate'].' 23:59:59');
				}
			}
			
			
			$payments = $payments->orderby('id', 'DESC')->get();
		}
		$return['records'] 		= $payments;
		return $return;
	}
	
	
	public static function getChartResult($param = array()) {
		$return			= array();
        $current_date 	= $param['current_date'];
		
		$month_name		= date('M');
		$month_fdate	= date('Y-m').'-01';
		$month_edate	= date("Y-m-t", strtotime($month_fdate));
		
		$date=[];
		
		/*$date[]=array(
			'month'=>$month_name,
			'fdate'=>$month_fdate,
			'ldate'=>$month_edate
		);
		
		for ($i = 1; $i < 7; $i++) {
			$month_name		= date('M', strtotime("-$i month"));
			$month_fdate	= date('Y-m', strtotime("-$i month"));
			$month_fdate	= $month_fdate.'-01';
			$month_edate	= date("Y-m-t", strtotime($month_fdate));
			
			$date[]=array(
				'month'=>$month_name,
				'fdate'=>$month_fdate,
				'ldate'=>$month_edate
			);
		}*/
		
		
		for ($i =0; $i < 7; $i++) {
			$month_name		= date("M", strtotime( date( 'Y-m-01' )." -$i months"));
			$month_fdate 	= date("Y-m-d", strtotime( date( 'Y-m-01' )." -$i months"));
			$month_edate	= date("Y-m-t", strtotime($month_fdate));
			$date[]=array(
				'month'=>$month_name,
				'fdate'=>$month_fdate,
				'ldate'=>$month_edate
			);
		}
		
		
		$records = [];
		
		$gross_total_income		= 0;
		$gross_total_expenses	= 0;
		
		
		
		/*$date_from	= '2021-03-01';
		$date_to	= '2021-03-31';
		
		$start_date = date('Y-m-d 00:00:00', strtotime($date_from));
		$end_date = date('Y-m-d 23:59:59', strtotime($date_to));
		
		
		$result		= DB::table('balance_request')->where('created_at', '>=', $start_date)->where('created_at', '<=', $end_date)->sum('amount');
		
		echo '<pre>';print_r($result);exit;*/
		
		
		
		
		
		for ($i =0; count($date)>$i; $i++) {
			$month_name	= strtoupper($date[$i]['month']);
			$date_from	= $date[$i]['fdate'];
			$date_to	= $date[$i]['ldate'];
			
			$start_date = date('Y-m-d 00:00:00', strtotime($date_from));
			$end_date = date('Y-m-d 23:59:59', strtotime($date_to));
			
			$total_income_result	= DB::table('balance_request')->where('status','completed')->whereBetween('created_at', [$start_date, $end_date])->selectRaw('sum(amount) as total_amount')->get();
			$total_income	= isset($total_income_result[0]->total_amount)?$total_income_result[0]->total_amount:'0';
			
			$gross_total_income +=$total_income;
			
			$total_expenses_result	= DB::table('withdraw_request')->where('status','completed')->whereBetween('created_at', [$start_date, $end_date])->selectRaw('sum(amount) as total_amount')->get();
			$total_expenses			= isset($total_expenses_result[0]->total_amount)?$total_expenses_result[0]->total_amount:'0';
			$gross_total_expenses +=$total_expenses;
			
			$total_profit	= ($total_income-$total_expenses);
			
			
			$records[]=array(
				'month'			=> $month_name,
				'fdate'			=> $date_from,
				'ldate'			=> $date_to,
				'income'		=> $total_income,
				'expenses'		=> $total_expenses,
				'total_profit'	=> $total_profit
			);
		}
		
		$total_profit	= ($gross_total_income-$gross_total_expenses);
		$total_profit	= number_format($total_profit,2);
		
		$total_profit_percent=0;
		if($gross_total_income>0){
			$total_profit_percent	= round((($gross_total_income - $gross_total_expenses) * 100) / $gross_total_income);
		}
		
		
		
		$return['records'] 				= $records;
		$return['total_profit'] 		= number_format($records[0]['total_profit'],2);//$total_profit;
		$return['total_profit_percent']	= $total_profit_percent;
		$return['gross_total_income'] 	= $gross_total_income;
		$return['gross_total_expenses'] = $gross_total_expenses;
		
		return $return;
	}
	
	
}
