<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB AS DB;

class UpiAccounts extends Model
{
    protected $table='upi_accounts';
	protected $guarded=[];

	public static function get_data($param = array()) {
		$return			= array();

		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];

		$total_payments = DB::table('upi_accounts');
        if($search != '') {
            $total_payments = $total_payments->where(function($total_payments) use ($search) {
                $total_payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }


		$total_payments = $total_payments->count();

		$payments = DB::table('upi_accounts');
		if($search != '') {
            $payments = $payments->where(function($payments) use ($search) {
				$payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }

		$payments = $payments->orderby('id', 'ASC')->get();
		$return['records'] = $payments;
		$return['total_orders'] = $total_payments;
		return $return;
	}
}