<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;


use Session;
use Helpers;

class Payments extends Model
{
    protected $table = 'payments';
	protected $fillable = ['unique_id','user_id','txn_id','payment_gross','total_amount','currency_code','payment_status','created_at'];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_payments = DB::table('payments');
        if($search != '') {
            $total_payments = $total_payments->where(function($total_payments) use ($search) {
                $total_payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
        
		
		$total_payments = $total_payments->count();
		
		$payments = DB::table('payments')->select('payments.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone')->leftJoin('users', 'users.id', 'payments.user_id');
		if($search != '') {
            $payments = $payments->where(function($payments) use ($search) {
				$payments->where(DB::raw("txn_id"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$payments = $payments->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $payments;
		$return['total_orders'] = $total_payments;
		return $return;
	}
}
