<?php

namespace App;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB AS DB;

use Session;
use Helpers;

class Order extends Model
{
	protected $table = 'order';
	
	public static function getOrderDetails($token) {
		$result	= array();
		$order_result = DB::table('order as O')
		 			->leftjoin('merchant as M', 'O.merchant_id', '=','M.merchant_id')
					->select('O.*','M.restaurant_name')
		 			->where('O.order_id_token',(int)$token)
					->where('O.order_status','1')
		 			->get();
					
		if(count($order_result)>0){
			$cart_result = DB::table('cart_items as CI')
		 			->leftjoin('menu_items as MI', 'CI.product_id', '=','MI.item_id')
					->select('CI.*','MI.item_name','MI.size','MI.price','MI.photo')
		 			->where('CI.ses_id',(int)$order_result[0]->cart_id)
		 			->orderby('CI.id', 'ASC')
		 			->get();
		 
		 
		 //echo '<pre>';print_r($cart_result);exit;			
			
			
			$cat_info		= array();
			$addon_items 	= array();
			
			
			foreach($cart_result as $row){
				
				$cart_result = DB::table('cart_items as CI')
		 			->leftjoin('menu_items as MI', 'CI.product_id', '=','MI.item_id')
					->select('CI.*','MI.item_name','MI.size','MI.price','MI.photo')
		 			->where('CI.ses_id',(int)$order_result[0]->cart_id)
		 			->orderby('CI.id', 'ASC')
		 			->get();
					
					
				$addon_items = DB::select(DB::raw("SELECT CAI.*,AI.item_name FROM cart_addon_items CAI LEFT JOIN addon_item as AI on CAI.addon_id = AI.addon_item_id WHERE CAI.ses_id = '" .(int)$row->ses_id. "' AND CAI.product_id = '" .(int)$row->product_id. "' ORDER BY CAI.id ASC"));
				$cat_info[]=array(
					'cart_id' 		=> $row->id,
					'item_name'		=> $row->item_name,
					'size'			=> Helpers::get_item_size_by_id($row->size_id),
					'photo'			=> $row->photo,
					'price'			=> $row->price,
					'total_price'	=> $row->total_price,
					'grand_total'	=> $row->grand_total,
					'qnty'			=> $row->qnty,
					'notes'			=> $row->notes,
					'addon_items'	=> $addon_items			
				);	
			}
			
			$delivery_address_result = DB::select(DB::raw("SELECT * FROM `order_delivery_address` WHERE order_id = '" . (int)$token. "'"));
			$result= array(
				'order_info'				=> $order_result,
				'cat_info'					=> $cat_info,
				'cart_result'				=> $cart_result,
				'delivery_address_result'	=> array(),
			);
		}
		return $result;
	}
    
	public static function get_orders($param = array()) {
		$return			= array();
		
		$user_id 		= $param['user_id'];
		
		$search 		= $param['search'];
		$brand 			= isset($param['brand'])?$param['brand']:'';
		$model 			= isset($param['model'])?$param['model']:'';
		$engine			= isset($param['engine'])?$param['engine']:'';
		$ecu_type		= isset($param['ecu_type'])?$param['ecu_type']:'';
		$status			= isset($param['status'])?$param['status']:'';
		$vehicle_type	= isset($param['vehicle_type'])?$param['vehicle_type']:'';
		$date_min		= isset($param['date_min'])?$param['date_min']:'';
		$date_max		= isset($param['date_max'])?$param['date_max']:'';
		
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_orders = DB::table('order')->where('order.user_id', $user_id);
        if($search != '') {
            $total_orders = $total_orders->where(function($total_orders) use ($search) {
                $total_orders->where(DB::raw("order.order_id_token"), 'LIKE', '%' . $search . '%');
            });
        }
        
		
		$total_orders = $total_orders->count();
		
		$orders = DB::table('order')->select('order.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone', 'vehicle_type.name as vehicle_type_name', 'manufacturer.name as manufacturer_name', 'model.name as model_name', 'engine.name as engine_name', 'ecu_type.name as ecu_type_name')->leftJoin('vehicle_type', 'vehicle_type.id', 'order.vehicle_type_id')->leftJoin('manufacturer', 'manufacturer.id', 'order.manufacturer_id')->leftJoin('model', 'model.id', 'order.model_id')->leftJoin('engine', 'engine.id', 'order.engine_id')->leftJoin('ecu_type', 'ecu_type.id', 'order.ecu_type_id')->leftJoin('users', 'users.id', 'order.user_id')->where('order.user_id', $user_id);
		if($search != '') {
            $orders = $orders->where(function($orders) use ($search) {
				$orders->where(DB::raw("order.order_id_token"), 'LIKE', '%' . $search . '%');
            });
        }
		
		if($brand){
			$orders->where('manufacturer.name',$brand);
		}
		if($model){
			$orders->where('model.name',$model);
		}
		if($engine){
			$orders->where('engine.name',$engine);
		}
		if($ecu_type){
			$orders->where('ecu_type.name',$ecu_type);
		}
		if($status){
			$orders->where('order.status',$status);
		}
		if($vehicle_type){
			$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		if($date_min){
			//$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		if($date_max){
			//$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		
		
		$orders = $orders->orderby('order.order_id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $orders;
		$return['total_orders'] = $total_orders;
		return $return;
	}
	
	public static function get_admin_orders($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$brand 			= isset($param['brand'])?$param['brand']:'';
		$model 			= isset($param['model'])?$param['model']:'';
		$engine			= isset($param['engine'])?$param['engine']:'';
		$ecu_type		= isset($param['ecu_type'])?$param['ecu_type']:'';
		$status			= isset($param['status'])?$param['status']:'';
		$vehicle_type	= isset($param['vehicle_type'])?$param['vehicle_type']:'';
		$priority		= isset($param['priority'])?$param['priority']:'';
		$date_min		= isset($param['date_min'])?$param['date_min']:'';
		$date_max		= isset($param['date_max'])?$param['date_max']:'';
		
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_orders = DB::table('order');
        if($search != '') {
            $total_orders = $total_orders->where(function($total_orders) use ($search) {
                $total_orders->where(DB::raw("order.order_id_token"), 'LIKE', '%' . $search . '%');
            });
        }
        
		
		$total_orders = $total_orders->count();
		
		$orders = DB::table('order')->select('order.*', 'vehicle_type.name as vehicle_type_name', 'manufacturer.name as manufacturer_name', 'model.name as model_name', 'engine.name as engine_name', 'ecu_type.name as ecu_type_name')->leftJoin('vehicle_type', 'vehicle_type.id', 'order.vehicle_type_id')->leftJoin('manufacturer', 'manufacturer.id', 'order.manufacturer_id')->leftJoin('model', 'model.id', 'order.model_id')->leftJoin('engine', 'engine.id', 'order.engine_id')->leftJoin('ecu_type', 'ecu_type.id', 'order.ecu_type_id');
		if($search != '') {
            $orders = $orders->where(function($orders) use ($search) {
				$orders->where(DB::raw("order.order_id_token"), 'LIKE', '%' . $search . '%');
            });
        }
		
		if($brand){
			$orders->where('manufacturer.name',$brand);
		}
		if($model){
			$orders->where('model.name',$model);
		}
		if($engine){
			$orders->where('engine.name',$engine);
		}
		if($ecu_type){
			$orders->where('ecu_type.name',$ecu_type);
		}
		if($status){
			$orders->where('order.status',$status);
		}
		if($vehicle_type){
			$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		if($priority){
			$orders->where('order.priority',$priority);
		}
		if($date_min){
			//$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		if($date_max){
			//$orders->where('order.vehicle_type_id',$vehicle_type);
		}
		
		
		$orders = $orders->orderby('order.order_id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $orders;
		$return['total_orders'] = $total_orders;
		return $return;
	}
	
	public static function get_order($order_id) {
		$order = DB::table('order')->select('order.*', 'users.name as customer_name', 'users.email as customer_email', 'users.phone as customer_phone','vehicle_type.name as vehicle_type_name', 'manufacturer.name as manufacturer_name', 'model.name as model_name', 'engine.name as engine_name', 'ecu_type.name as ecu_type_name', 'gearbox_type.title as gearbox_type_name','reading_method.title as reading_method_title')->leftJoin('vehicle_type', 'vehicle_type.id', 'order.vehicle_type_id')->leftJoin('manufacturer', 'manufacturer.id', 'order.manufacturer_id')->leftJoin('model', 'model.id', 'order.model_id')->leftJoin('engine', 'engine.id', 'order.engine_id')->leftJoin('ecu_type', 'ecu_type.id', 'order.ecu_type_id')->leftJoin('gearbox_type', 'gearbox_type.id', 'order.gearbox_type')->leftJoin('reading_method', 'reading_method.id', 'order.reading_method_id')->leftJoin('users', 'users.id', 'order.user_id')->where('order.order_id_token', $order_id)->first();
		
		return $order;
	}
}
