<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class News_board extends Model
{
	protected $table = 'news_board';
	protected $fillable = ['title','content','status','created_at'];
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('news_board');
        if($search != '') {
            $total_records = $total_records->where(function($total_records) use ($search) {
                $total_records->where(DB::raw("name"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$total_records = $total_records->count();
		
		$records = DB::table('news_board')->select('news_board.*');
		if($search != '') {
            $records = $records->where(function($records) use ($search) {
				$records->where(DB::raw("name"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$records = $records->orderby('id', 'DESC')->get();
		//$records = $records->orderby('id', 'DESC')->offset($limit_start)->limit($per_page)->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
}
