<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\User;
use Input;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Session;
use Carbon;
use Auth;
use Image;
use DB;
use Helpers;
use Hash;
use App\Common;
use App\User_wallet;
use App\Payments;
use App\Withdraw_request;
use App\Balance_request;
use App\Time_slots;
use App\Category;
use App\Play_type;
use App\Game_type;
use App\Transactions;
use App\User_bit_transaction;
use App\Avality_time_date_slots;
use App\Win_price_calculation;
use App\Win_period;
use Config;
class Result extends Controller {
	protected $paymentsModel;
	protected $withdrawRequestModel;
	protected $balanceRequestModel;
	protected $timeSlotsModel;
	protected $userBitTransactionModel;
	protected $avalityTimeDateSlotsModel;
	protected $userTransactionsModel;
	public function __construct(){
		$this->paymentsModel 				= new Payments;
		$this->withdrawRequestModel 		= new Withdraw_request;
		$this->balanceRequestModel 			= new Balance_request;
		$this->timeSlotsModel 				= new Time_slots;
		$this->userBitTransactionModel 		= new User_bit_transaction;
		$this->avalityTimeDateSlotsModel 	= new Avality_time_date_slots;
		$this->userTransactionsModel		= new Transactions;
		Helpers::set_elescope_entries();
    }
	
	
	
	public function currentTimeSlotResult($id){
		$title 			= 'Delete Result';
        $breadcumbs 	= 'Result';
		$category_info 	= Category::where('id',$id)->first();
		$active 		= isset($category_info->slug)?$category_info->slug:'result';
		$category_id	= $id;
		$meta_data 		= array();
        $search 		= request()->input('s');
        $cur_page 		= request()->input('pg');
        $cur_page 		= $cur_page == '' ? 1 : $cur_page;
        $per_page		= 20;
        $limit_start	= ($cur_page - 1) * $per_page;
        $param 					= array();
		$param['search'] 		= $search;
		$param['cat_id'] 		= $id;
        $param['cur_page'] 		= $cur_page;
        $param['per_page'] 		= $per_page;
        $param['limit_start']	= $limit_start;
		$result		=[]; //Time_slots::getTimeSlotResult($param);
		$type_list  = Play_type::get();
		
		$cat_id 		= $id;
		$category_info 	= Category::where('id',$cat_id)->first();
		$category_name 	= isset($category_info->name)?$category_info->name:'';
		
		$slot_result	= Time_slots::where('category_id',$cat_id)->get();

		
		
		$play_type_title='';
		$play_type_result = Play_type::where('status',1)->get();
		foreach($play_type_result as $row){
			$play_type_title .=' & '.$row->name;
		}
		$play_type_title = ltrim($play_type_title, ' &');
		
		$currentSlotWiseTypeResult=[];
		$play_type_result = Play_type::where('status',1)->get();
		
		$current_date 	= date('Y-m-d');
		
		$last_result_time_slot_id='';
		
		foreach($play_type_result as $row){
			$slotWiseResult=[];
			foreach($slot_result as $slot_row){
				$game_info	= Game_type::where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
				$game_id 	= isset($game_info->id)?$game_info->id:'';
			
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$slot_row->id,$game_id,$row->id);
				$setResultInfo	= Win_period::where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				if($win_status=='Y'){
				    $last_result_time_slot_id=$slot_row->id;
				}
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'game_type_id'	=> $game_id,
					'category_id'	=> $slot_row->category_id,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $win_status
				);
			}
			$currentSlotWiseTypeResult[]=array(
				'type_id'			=> $row->id,
				'type_name'			=> $row->name,
				'slotWiseResult'	=> $slotWiseResult
				
			);	
		}

		//echo '<pre>';print_r($currentSlotWiseTypeResult);exit;
		
		$current_time_slot_result = [];
		$status	= 'N';
		$i=0;
		foreach($slot_result as $row){
			
			$game_info	= Game_type::where('category_id',$cat_id)->where('time_slot_id',$row->id)->first();
			$game_id 	= isset($game_info->id)?$game_info->id:'';
			
			$play_type_result = Play_type::where('status',1)->get();
			
			$play_result = [];
			foreach($play_type_result as $ptrow){
				$period_id		= Helpers::getPeriod($current_date,$cat_id,$row->id,$game_id,$ptrow->id);
				if($ptrow->id==3){
					if($i!=0){
						$current_slot_number	= $row->id;
						$prev_slot_number 		= Time_slots::where('id', '<', $current_slot_number)->max('id');
						$current_game_id		= $game_id;
						$prev_game_id			= Game_type::where('id', '<', $current_game_id)->max('id');
						$period_id 				= Helpers::getPeriod($current_date,$cat_id,$prev_slot_number,$prev_game_id,$ptrow->id);
					}
				}
				
				$setResultInfo	= Win_period::where('is_active','Y')->where('period',$period_id)->first();
				$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'';
				$status			= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
				
				$play_result[]=array(
					'type_id'		=> $ptrow->id,
					'type_name'		=> $ptrow->name,
					'period_id'		=> $period_id,
					'win_number'	=> $win_number,
					'status'		=> $status,
				);
			}
			$current_time_slot_result[]=array(
				'id'			=> $row->id,
				'from_time'		=> $row->from_time,
				'to_time'		=> $row->to_time,
				'game_type_id'	=> $game_id,
				'category_id'	=> $row->category_id,
				'status'		=> $status,
				'play_result'	=> $play_result
			);
			
		 $i++;	
		}
		
		/*Current Date*/
		$result[]=array(
			'id'			=> 2,
			'date'			=> $current_date,
			'type_title'	=> $play_type_title,
			'cat_name'		=> $category_name,
			'last_result_time_slot_id'=>$last_result_time_slot_id,
			'time_slot'		=> $current_time_slot_result,
			'slot_result' 	=> $currentSlotWiseTypeResult
		);
		
		//echo '<pre>';print_r($result);exit;

		$totalSlot=isset($result[0]['time_slot'])?count($result[0]['time_slot']):'0';
		
		//echo '<pre>';print_r($totalSlot);exit;
		return view('admin.delete_result/index', compact('title','active','breadcumbs','result','type_list','category_id'));
    }
	public function save_result_request(Request $request){
		
		$category_id	= $request->input('category_id');
		$win_number		= $request->input('win_number');
		$slot_period	= $request->input('period_id');
		$type			= $request->input('type_id');
		$game_id		= $request->input('game_id');
		$date_slot		= $request->input('date_slot');
		$time_slot_id	= $request->input('time_slot_id');
		$time_id		= $request->input('time_id');
		
		//echo '<pre>';print_r($_POST);exit;
		
		$baziResult 		= Game_type::where('id', $game_id)->where('category_id', $category_id)->first();
		$bazi_title			= isset($baziResult->name)?$baziResult->name:'';
		$categotyResult 	= Category::where('id', $category_id)->first();
		$played_game_title	= isset($categotyResult->name)?$categotyResult->name:'';
			
		$description='Won '.$played_game_title.' '.$bazi_title;
		
		$bidResult=[];
		
		for($i=0;count($slot_period)>$i;$i++){
		    $period_id	= $slot_period[$i];
			$type_id	= $type[$i];
			$number		= $win_number[$i];
			
			$price_calculation	= Win_price_calculation::where('category_id',$category_id)->where('play_type',$type_id)->first();
			if($type_id==4){
			    $price_calculation	= Win_price_calculation::where('category_id',$category_id)->where('play_type',2)->first();
			}
			$calculation_type	= isset($price_calculation->calculation_type)?$price_calculation->calculation_type:1;
			$calculation_value	= isset($price_calculation->value)?$price_calculation->value:'9.5';
			
			$userBitTransactionResult	= $this->userBitTransactionModel->select('*', DB::raw('SUM(amount) as total_amount'))->where('period_id',$period_id)->where('win_status','win')->where('status',1) ->groupBy('user_id')->get();
			
			foreach($userBitTransactionResult as $row){
			    $payment_gross	= $row->total_amount;
				$total_win_amount =0;
				if($payment_gross!=''){
				    if($payment_gross>0){
				        if($calculation_type==1){
				            $total_win_amount=$payment_gross*$calculation_value;
				        }elseif($calculation_type==2){
				            $percent = $calculation_value;
							$discount_value = ($payment_gross / 100) * $percent;
							$total_win_amount = $payment_gross + $discount_value;
						}
					}
				}
				
				$user_id		= $row->user_id;
				$wallet_data 	= Common::getSingelData($where=['user_id'=>$user_id],$table='user_wallet',$data=['balance'],'id','ASC');
				$balance_gross 	= isset($wallet_data->balance)? $wallet_data->balance:'0';
				$wallet_amount = 0;
				$wallet_amount+= $balance_gross;
				$wallet_amount-= $total_win_amount;
				Common::updateData($table="user_wallet", "user_id", $user_id, array('balance'=>$wallet_amount,'updated_at'=>date('Y-m-d H:i:s')));
				
				
				$transactionsData=array(
					'user_id'   			=> $user_id,
					'description'   		=> 'Win Amount Debited',
					'amount'				=> $total_win_amount,
					'available_bal'			=> $wallet_amount,
					'type'					=> 1,
					'status'				=> 'paid',
					'is_transaction_view'	=> 1,
					'date_slot'				=> date('Y-m-d')
				);
				Transactions::create($transactionsData);
				
				$bidResult[]=array(
				    'user_id'   	=> $user_id,
				    'type_id'       => $type_id,
				    'win_amount'		=> $total_win_amount,
				    'balance_gross'	=> $balance_gross,
				    'wallet_amount' => $wallet_amount,
				    'date_slot'		=> date('Y-m-d')
				);
				
				
				
				
				//echo 'total_win_amount:'.$type_id.'-'.$total_win_amount.'balance_gross'.$balance_gross.'wallet_amount'.$wallet_amount.'</br>';
				
			}
			
			$this->userBitTransactionModel::where('period_id', $period_id)->update(['win_status' =>'pending']);
			Common::deleteData('win_period','period',$period_id);
			
		}
		
		
		//echo '<pre>';print_r($bidResult);exit;
		Session::flash('success', 'Successfully Saved data.');
		return redirect::back();
	}	
}