<?php
namespace App\Http\Controllers\admin;
use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Support\Facades\File;
use Illuminate\Support\Facades\Redirect;
use Illuminate\Support\Facades\Validator;
use Illuminate\Http\Request;

use Kreait\Firebase\Factory;
use Kreait\Firebase\Messaging\CloudMessage;

use App\User;
use App\Common;
use App\User_wallet;
use App\Time_slots;
use App\Play_type;
use App\Game_type;
use App\Balance_request;
use App\Withdraw_request;
use App\Transactions;
use App\News;
use App\News_board;
use App\Category;
use App\Slider;
use App\Cp_digits;
use App\Deduction;
use App\Addition;
use App\User_bit_transaction;
use App\Win_price_calculation;
use App\Telescope_entries;
use App\Notifications;
use App\AppNotifications;
use Google_Client;
use Input;
use Session;
use Carbon;
use Auth;
use Image;
use DB;
use Helpers;
use Hash;
use Config;


//require_once('public/mpdf/vendor/autoload.php');
class AdminController extends Controller
{
	use AuthenticatesUsers;
	protected $userModel;
	protected $timeSlotsModel;
	protected $gameTypeModel;
	protected $userBitTransactionModel;
	protected $balanceRequestModel;
	protected $withdrawRequestModel;
	protected $userTransactionsModel;
	protected $userWalletModel;
	protected $client;
	public function __construct()
	{
		$this->userModel = new User;
		$this->timeSlotsModel = new Time_slots;
		$this->gameTypeModel = new Game_type;
		$this->userBitTransactionModel = new User_bit_transaction;
		$this->balanceRequestModel = new Balance_request;
		$this->withdrawRequestModel = new Withdraw_request;
		$this->userTransactionsModel = new Transactions;
		$this->userWalletModel = new User_wallet;

		$credentialsFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json';
		$this->client = new Google_Client();
		$this->client->setAuthConfig($credentialsFilePath);
		$this->client->addScope('https://www.googleapis.com/auth/firebase.messaging');
		$this->client->refreshTokenWithAssertion();

		Helpers::set_elescope_entries();
	}
	/**
	 * Where to redirect users after login.
	 *
	 * @var string
	 */
	protected $redirectTo = '/administrator/dashboard';
	/**
	 * Display admin dashboard.
	 *
	 */
	public function dashboard()
	{
		$title = "Dashboard";
		$breadcumbs = "Dashboard";
		$active = "dashboard";
		$adminId = Session::get('adminId');

		//print_r($adminId);exit;


		$param = array();
		$param['current_date'] = date('Y-m-d');
		$param['current_time'] = date('h:i a');
		$total_user = $this->userModel->where('user_type', 2)->count();
		$total_withdraw_request = $this->withdrawRequestModel->count();
		$total_withdraw_pending_request = $this->withdrawRequestModel->where('status', 'pending')->count();
		$total_balance_request = $this->balanceRequestModel->count();
		$total_balance_pending_request = $this->balanceRequestModel->where('status', 'pending')->count();
		$total_user_balance = $this->userWalletModel->sum('balance');
		$chart_result = $this->withdrawRequestModel->getChartResult($param);
		$current_game_chart_result = $this->userBitTransactionModel->getChartCurrentGame($param);

		$token_list = User::select('fcm_token', 'id')->where('is_subscribe', 'N')->orderBy('id', 'asc')->get()->toArray();
		$fcmTokenList = array_column($token_list, 'fcm_token');

		if (count($fcmTokenList) > 0) {
			User::where('is_subscribe', 'N')->update(['is_subscribe' => 'Y']);

			// Path to your service account file
			$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json';

			// Initialize Firebase with the service account credentials
			$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
			$messaging = $factory->createMessaging();

			$topic = 'ff2-notification'; // Your topic name

			try {
				$messaging->subscribeToTopic($topic, $fcmTokenList);
				//echo 'Successfully subscribed to topic';
			} catch (\Kreait\Firebase\Exception\MessagingException $e) {
				//echo 'Error subscribing to topic: ' . $e->getMessage();
			}
		}

		//echo '<pre>';print_r($chart_result);exit;

		if ($adminId == 9) {
			return view('admin.team_dashboard', compact('title', 'breadcumbs', 'active', 'total_user', 'total_withdraw_request', 'total_withdraw_pending_request', 'total_balance_request', 'total_balance_pending_request', 'total_user_balance', 'current_game_chart_result'));

		} else {
			return view('admin.dashboard', compact('title', 'breadcumbs', 'active', 'total_user', 'total_withdraw_request', 'total_withdraw_pending_request', 'total_balance_request', 'total_balance_pending_request', 'total_user_balance', 'current_game_chart_result', 'chart_result'));

		}






	}

	public function notification()
	{
		$userId = '67';
		$title = 'Notification Testing'; // Notification title
		$content = 'Notification V1'; // Notification body

		//echo 'ff';exit;

		//$token = $this->sendNotificationToSingle($userId,$title,$content);
		$token = $this->sendNotificationToAll($title, $content);
	}

	/*+++++++++++++++++++++++ Notification +++++++++++++++++++++++++++++++++++*/

	public function sendNotificationToAll($title, $content)
	{
		$topic = 'ff2-notification'; // Topic to send the notification to

		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json'; // Path to service account file

		// Initialize Firebase with the service account credentials
		$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
		$messaging = $factory->createMessaging();

		// Create the message to send
		$message = CloudMessage::withTarget('topic', $topic)
			->withNotification([
					'title' => strtoupper($title), // Using dynamic title
					'body' => $content, // Using dynamic content
				])
			->withData([
					'title' => strtoupper($title),
					'body' => $content,
					'notification_foreground' => 'true',
					'notification_status' => 'true',
					'show_status' => 'true',
					'head_title' => 'success',
					'is_notification' => 'true',
				]); // Custom data

		// Send the notification to the topic
		$messaging->send($message);

		return true;
	}

	public function sendNotificationToSingle($userId, $title, $content)
	{
		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json'; // Path to service account file

		$user = User::find($userId);
		$device_token = $user->fcm_token ?? '';

		if ($device_token != '') {
			// Initialize Firebase with the service account credentials
			$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
			$messaging = $factory->createMessaging();

			$message = CloudMessage::withTarget('token', $device_token)
				->withNotification([
						'title' => strtoupper($title),
						'body' => $content,
					])
				->withData([
						'title' => strtoupper($title),
						'body' => $content,
						'notification_foreground' => 'true',
						'notification_status' => 'true',
						'show_status' => 'true',
						'head_title' => 'success',
						'is_notification' => 'true',
						'priceRefresh' => '1'
					]);

			//echo '<pre>';print_r($message);exit;
			$messaging->send($message);
		}

		return true;
	}

	/*+++++++++++++++++++++++End+++++++++++++++++++++++++++++++++++*/


	public function fcmTopicSubscriptionRequest()
	{

		// Path to your service account file
		$serviceAccountFilePath = 'fcm/bet-ff2-firebase-adminsdk-fbsvc-d80ec82538.json';

		// Initialize Firebase with the service account credentials
		$factory = (new Factory)->withServiceAccount($serviceAccountFilePath);
		$messaging = $factory->createMessaging();

		$topic = 'ff2-notification';



		$item_per_page = 300;
		$total_records = User::where('fcm_token', '!=', 'null')->where('user_type', 2)->count();
		$v = ($total_records / $item_per_page);
		if ($v > (int) $v)
			$total_pages = (int) $v + 1;
		else
			$total_pages = (int) $v;

		for ($i = 0; $total_pages > $i; $i++) {
			$limit_start = $i * $item_per_page;
			$token_list = User::select('fcm_token', 'id')->where('fcm_token', '!=', 'null')->offset($limit_start)->limit($item_per_page)->orderBy('id', 'asc')->get()->toArray();

			$fcmTokenList = array_column($token_list, 'fcm_token');

			try {
				$messaging->subscribeToTopic($topic, $fcmTokenList);
				echo 'Successfully subscribed to topic';
			} catch (\Kreait\Firebase\Exception\MessagingException $e) {
				echo 'Error subscribing to topic: ' . $e->getMessage();
			}


		}
	}



	public function category()
	{
		$title = "Category";
		$breadcumbs = "Category";
		$active = "category";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$category_list = Category::get_data($param);
		//echo '<pre>';print_r($category_list);exit;
		return view('admin.category/index', compact('title', 'active', 'breadcumbs', 'category_list'));
	}
	public function addCategory()
	{
		$title = "Add Category";
		$breadcumbs = "Add Category";
		$active = "category";
		$data = [];
		$category_thumb = asset('public/images/no_image-150x150.png');
		return view('admin.category/form', compact('title', 'active', 'breadcumbs', 'category_thumb', 'data'));
	}
	public function editCategory($id)
	{
		$title = "Edit Category";
		$breadcumbs = "Edit Category";
		$active = "category";
		$data = Category::where('id', $id)->first();
		$category_thumb = isset($data->image) ? Helpers::category_image($data->image) : asset('public/images/no_image-150x150.png');
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.category/form', compact('title', 'active', 'breadcumbs', 'category_thumb', 'data'));
	}
	public function deleteCategory()
	{
		$category_id = request()->input('id');
		if ($category_id != null) {
			$check = DB::table('time_slots')->whereRaw('FIND_IN_SET(' . $category_id . ',category_id)')->first();
			if (!empty($check)) {
				Session::flash('error', 'Can not be deleted as time slot are in this date slot !');
			} else {
				Common::deleteData('category', 'id', $category_id);
				Session::flash('success', 'Category deleted successfully.');
			}
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveCategoryRequest(Request $request)
	{
		$category_id = $request->input('category_id');
		$label = $request->input('label');
		$name = $request->input('category');
		$image = $request->input('image');
		$status = $request->input('status');

		$validator = Validator::make($request->all(), [
			'label' => 'required',
			'category' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
			//return back()->withInput()->withErrors(['error'=>'Phone or password is invalid!']);
		} else {

			$slug = Helpers::create_slug($name);
			if ($category_id != '') {
				$category = Category::find($category_id);
				$category->label = $label;
				$category->name = $name;
				$category->slug = $slug;
				$category->image = $image;
				$category->status = $status;
				$category->save();
			} else {
				$sort = Category::count();


				$category = new Category;
				$category->label = $label;
				$category->name = $name;
				$category->slug = $slug;
				$category->image = $image;
				$category->status = $status;
				$category->sort = $sort;
				$category->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/game_category');
	}
	public function news()
	{
		$title = "News";
		$breadcumbs = "News";
		$active = "news";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$news_list = News::get_data($param);
		//echo '<pre>';print_r($news_list);exit;
		return view('admin.news/index', compact('title', 'active', 'breadcumbs', 'news_list'));
	}
	public function addNews()
	{
		$title = "Add News";
		$breadcumbs = "Add News";
		$active = "news";
		$data = [];
		return view('admin.news/form', compact('title', 'active', 'breadcumbs', 'data'));
	}
	public function editNews($id)
	{
		$title = "Edit News";
		$breadcumbs = "Edit News";
		$active = "news";
		$data = News::where('id', $id)->first();
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.news/form', compact('title', 'active', 'breadcumbs', 'data'));
	}
	public function deleteNews()
	{
		$id = request()->input('id');
		if ($id != null) {
			Common::deleteData('news', 'id', $id);
			Session::flash('success', 'News deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveNewsRequest(Request $request)
	{
		$news_id = $request->input('news_id');
		$name = $request->input('news');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'news' => 'required',
			'status' => 'required',
		]);


		print_r($_POST);
		exit;

		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			$slug = Helpers::create_slug($name);
			if ($news_id != '') {
				$news = News::find($news_id);
				$news->name = $name;
				$news->slug = $slug;
				$news->status = $status;
				$news->save();
			} else {
				$news = new News;
				$news->name = $name;
				$news->slug = $slug;
				$news->status = $status;
				$news->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/news');
	}
	public function cpSlot()
	{
		$title = "CP Digits";
		$breadcumbs = "CP Digits";
		$active = "cp_slot";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$cp_list = Cp_digits::get_data($param);
		/*$dight='100 200 300 400 500 600 700 800 900 000 678 345 120 789 456 123 890 567 234 127 777 444 111 888 555 222 999 666 333 190 560 570 580 590 140 150 160 170 180 280 470 480 490 130 230 330 340 350 360 370 380 390 670 680 690 240 250 260 270 460 290 660 238 248 258 268 278 288 450 550 119 129 139 149 159 169 179 189 199 235 137 237 337 347 357 367 377 116 117 118 236 336 157 158 799 448 467 233 469 578 146 246 346 446 267 899 115 459 126 145 669 679 689 699 780 124 125 667 479 579 255 355 455 447 790 223 224 478 668 399 147 247 266 366 466 666 477 135 299 588 228 256 112 113 358 557 990 225 334 489 499 166 356 122 880 368 134 488 245 688 599 239 177 114 359 558 379 389 155 148 338 249 556 449 369 559 226 227 138 788 257 339 259 269 378 289 569 178 144 778 344 156 889 349 133 445 220 229 770 440 388 677 279 577 136 335 110 348 457 188 128 589 779 167 168 277 458 468 668 244';
		$dight_array=explode(' ',$dight);
		for($i=0;count($dight_array)>$i;$i++){
			$cp_digits = new Cp_digits;
			$cp_digits->digit	= $dight_array[$i];
			$cp_digits->save();
		}
		echo '<pre>';
			print_r($dight_array);
			print_r($dight);
			exit;
	*/
		return view('admin.cp_slot/index', compact('title', 'active', 'breadcumbs', 'cp_list'));
	}
	public function addCpSlot()
	{
		$title = "Add CP Digits";
		$breadcumbs = "Add CP Digits";
		$active = "cp_slot";
		$data = [];
		return view('admin.cp_slot/form', compact('title', 'active', 'breadcumbs', 'data'));
	}
	public function editCpSlot($id)
	{
		$title = "Edit CP Digits";
		$breadcumbs = "Edit CP Digits";
		$active = "cp_slot";
		$data = Cp_digits::where('id', $id)->first();
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.cp_slot/form', compact('title', 'active', 'breadcumbs', 'data'));
	}
	public function deleteCpSlot()
	{
		$id = request()->input('id');
		if ($id != null) {
			Common::deleteData('cp_digits', 'id', $id);
			Session::flash('success', 'Digit deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveCpSlotRequest(Request $request)
	{
		$cp_id = $request->input('cp_id');
		$digit = $request->input('digit');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'digit' => 'required',
			'status' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			if ($cp_id != '') {
				$cp_digits = Cp_digits::find($cp_id);
				$cp_digits->digit = $digit;
				$cp_digits->status = $status;
				$cp_digits->save();
			} else {
				$cp_digits = new Cp_digits;
				$cp_digits->digit = $digit;
				$cp_digits->status = $status;
				$cp_digits->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/cp_slot');
	}
	public function addition()
	{
		$title = "Addition List";
		$breadcumbs = "Addition List";
		$active = "addition";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$addition_list = Addition::get_data($param);
		//echo '<pre>';print_r($addition_list);exit;
		return view('admin.money/addition', compact('title', 'active', 'breadcumbs', 'addition_list'));
	}
	public function addAddition()
	{
		$title = "Add Addition";
		$breadcumbs = "Add Addition";
		$active = "addition";
		return view('admin.money/addition_form', compact('title', 'active', 'breadcumbs'));
	}
	public function saveAdditionRequest(Request $request)
	{
		$customer_id = $request->input('customer_id');
		$amount = $request->input('amount');
		$validator = Validator::make($request->all(), [
			'customer_id' => 'required',
			'amount' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			$wallet_data = Common::getSingelData($where = ['user_id' => $customer_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount += $amount;
			Common::updateData($table = "user_wallet", "user_id", $customer_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));
			$addition = new Addition;
			$addition->user_id = $customer_id;
			$addition->amount = $amount;
			$addition->save();

			$transactionsData = array(
				'user_id' => $customer_id,
				'description' => 'Balance Added',
				'amount' => $amount,
				'available_bal' => $wallet_amount,
				'type' => 3,
				'status' => 'paid',
				'is_transaction_view' => 1,
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);

			$title = strtoupper('Balance Added successfully');
			$content = 'Amount-' . $amount . " .Tap to refresh.";

			$this->sendNotificationToSingle($customer_id, $title, $content);

			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/money/addition');
	}
	public function deduction()
	{
		$title = "Deduction List";
		$breadcumbs = "Deduction List";
		$active = "deduction";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$deduction_list = Deduction::get_data($param);
		//echo '<pre>';print_r($addition_list);exit;
		return view('admin.money/deduction', compact('title', 'active', 'breadcumbs', 'deduction_list'));
	}
	public function addDeduction()
	{
		$title = "Add Deduction";
		$breadcumbs = "Add Deduction";
		$active = "deduction";
		return view('admin.money/deduction_form', compact('title', 'active', 'breadcumbs'));
	}
	public function saveDeductionRequest(Request $request)
	{
		$customer_id = $request->input('customer_id');
		$amount = $request->input('amount');
		$validator = Validator::make($request->all(), [
			'customer_id' => 'required',
			'amount' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			$wallet_data = Common::getSingelData($where = ['user_id' => $customer_id], $table = 'user_wallet', $data = ['balance'], 'id', 'ASC');
			$balance_gross = isset($wallet_data->balance) ? $wallet_data->balance : '0';
			$wallet_amount = 0;
			$wallet_amount += $balance_gross;
			$wallet_amount -= $amount;
			Common::updateData($table = "user_wallet", "user_id", $customer_id, array('balance' => $wallet_amount, 'updated_at' => date('Y-m-d H:i:s')));
			$deduction = new Deduction;
			$deduction->user_id = $customer_id;
			$deduction->amount = $amount;
			$deduction->save();

			$transactionsData = array(
				'user_id' => $customer_id,
				'description' => 'Balance Deducted',
				'amount' => $amount,
				'available_bal' => $wallet_amount,
				'type' => 4,
				'status' => 'paid',
				'is_transaction_view' => 1,
				'date_slot' => date('Y-m-d')
			);
			$this->userTransactionsModel::create($transactionsData);

			$title = strtoupper('Balance Deduction successfully');
			$content = 'Amount-' . $amount . " .Tap to refresh.";
			$this->sendNotificationToSingle($customer_id, $title, $content);

			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/money/deduction');
	}
	public function slider()
	{
		$title = "Slider";
		$breadcumbs = "Slider";
		$active = "slider";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$slider_list = Slider::get_data($param);
		//echo '<pre>';print_r($news_list);exit;
		return view('admin.slider/index', compact('title', 'active', 'breadcumbs', 'slider_list'));
	}
	public function addSlider()
	{
		$title = "Add Slider";
		$breadcumbs = "Add Slider";
		$active = "slider";
		$data = [];
		$thumb = asset('public/images/no_image-150x150.png');
		return view('admin.slider/form', compact('title', 'active', 'breadcumbs', 'thumb', 'data'));
	}
	public function editSlider($id)
	{
		$title = "Edit Slider";
		$breadcumbs = "Edit Slider";
		$active = "slider";
		$data = Slider::where('id', $id)->first();
		$thumb = isset($data->image) ? Helpers::category_image($data->image) : asset('public/images/no_image-150x150.png');
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.slider/form', compact('title', 'active', 'breadcumbs', 'thumb', 'data'));
	}
	public function deleteSlider()
	{
		$id = request()->input('id');
		if ($id != null) {
			Common::deleteData('slider', 'id', $id);
			Session::flash('success', 'Slider deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveSliderRequest(Request $request)
	{
		$slider_id = $request->input('slider_id');
		$title = $request->input('title');
		$image = $request->input('image');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'title' => 'required',
			'status' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			if ($slider_id != '') {
				$slider = Slider::find($slider_id);
				$slider->title = $title;
				//$slider->title2	= $title2;
				//$slider->title3	= $title3;
				//$slider->desc	= $desc;
				$slider->image = $image;
				$slider->status = $status;
				$slider->save();
			} else {
				$slider = new Slider;
				$slider->title = $title;
				//$slider->title2	= $title2;
				//$slider->title3	= $title3;
				//$slider->desc	= $desc;
				$slider->image = $image;
				$slider->status = $status;
				$slider->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/slider');
	}
	public function slot()
	{
		$title = "Slot";
		$breadcumbs = "Slot";
		$active = "slot";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$slot_list = Time_slots::get_data($param);
		//echo '<pre>';print_r($slot_list);exit;
		return view('admin.slot/index', compact('title', 'active', 'breadcumbs', 'slot_list'));
	}
	public function addSlot()
	{
		$title = "Add Slot";
		$breadcumbs = "Add Slot";
		$active = "slot";
		$data = [];
		$category_list = Category::where('is_deleted', 0)->get();
		return view('admin.slot/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list'));
	}
	public function editSlot($id)
	{
		$title = "Edit Slot";
		$breadcumbs = "Edit Slot";
		$active = "slot";
		$data = Time_slots::where('id', $id)->first();
		$category_list = Category::where('is_deleted', 0)->get();
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.slot/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list'));
	}
	public function deleteSlot()
	{
		$id = request()->input('id');
		if ($id != null) {
			$check = DB::table('category')->whereRaw('FIND_IN_SET(' . $id . ',id)')->first();
			if (!empty($check)) {
				Session::flash('error', 'Can not be deleted as time slot are in this date slot !');
			} else {
				Common::deleteData('time_slots', 'id', $id);
				Session::flash('success', 'Slot deleted successfully.');
			}
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveSlotRequest(Request $request)
	{
		$slot_id = $request->input('slot_id');
		$category_id = $request->input('category_id');
		$start_time = $request->input('start_time');
		$end_time = $request->input('end_time');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'category_id' => 'required',
			'start_time' => 'required',
			'end_time' => 'required',
			'status' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			$from_time = date('h:i a', strtotime($start_time));
			$to_time = date('h:i a', strtotime($end_time));
			$from_time_slug = date('H:i', strtotime($start_time));
			$to_time_slug = date('H:i', strtotime($end_time));
			$time = strtotime($to_time);
			$result_time = date("h:i a", strtotime('+30 minutes', $time));
			//$game_type_id	= 1;
			if ($slot_id != '') {
				$slots = Time_slots::find($slot_id);
				$slots->from_time = $from_time;
				$slots->from_time_slug = $from_time_slug;
				$slots->to_time = $to_time;
				$slots->to_time_slug = $to_time_slug;
				$slots->result_time = $result_time;
				$slots->category_id = $category_id;
				$slots->status = $status;
				$slots->save();
			} else {
				$slots = new Time_slots;
				$slots->from_time = $from_time;
				$slots->from_time_slug = $from_time_slug;
				$slots->to_time = $to_time;
				$slots->to_time_slug = $to_time_slug;
				$slots->result_time = $result_time;
				$slots->category_id = $category_id;
				$slots->status = $status;
				$slots->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/slot');
	}
	public function winningPrice()
	{
		$title = "Winning Price";
		$breadcumbs = "Winning Price";
		$active = "winningPrice";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$price_list = Win_price_calculation::get_data($param);
		//echo '<pre>';print_r($price_list);exit;
		return view('admin.winningPrice/index', compact('title', 'active', 'breadcumbs', 'price_list'));
	}
	public function addWinningPrice()
	{
		$title = "Add Winning Price";
		$breadcumbs = "Add Winning Price";
		$active = "winningPrice";
		$data = [];
		$category_list = Category::where('is_deleted', 0)->get();
		$type_list = Play_type::get();
		return view('admin.winningPrice/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list', 'type_list'));
	}
	public function editWinningPrice($id)
	{
		$title = "Edit Winning Price";
		$breadcumbs = "Edit Winning Price";
		$active = "winningPrice";
		$data = Win_price_calculation::where('id', $id)->first();
		$category_list = Category::where('is_deleted', 0)->get();
		$type_list = Play_type::get();
		//echo '<pre>';print_r($category_thumb);exit;
		return view('admin.winningPrice/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list', 'type_list'));
	}
	public function deleteWinningPrice()
	{
		$id = request()->input('id');
		if ($id != null) {
			Common::deleteData('win_price_calculation', 'id', $id);
			Session::flash('success', 'Price deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveWinningPriceRequest(Request $request)
	{
		$calculation_id = $request->input('calculation_id');
		$category_id = $request->input('category_id');
		$play_type = $request->input('play_type');
		$calculation_type = $request->input('calculation_type');
		$value = $request->input('value');
		$validator = Validator::make($request->all(), [
			'category_id' => 'required',
			'play_type' => 'required',
			'calculation_type' => 'required',
			'value' => 'required',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';

			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			if ($calculation_id != '') {
				$calculation = Win_price_calculation::find($calculation_id);
				$calculation->category_id = $category_id;
				$calculation->play_type = $play_type;
				$calculation->calculation_type = $calculation_type;
				$calculation->value = $value;
				$calculation->save();
			} else {
				$calculation = new Win_price_calculation;
				$calculation->category_id = $category_id;
				$calculation->play_type = $play_type;
				$calculation->calculation_type = $calculation_type;
				$calculation->value = $value;
				$calculation->save();
			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/winning-price');
	}
	public function game()
	{
		$title = "Game List";
		$breadcumbs = "Game List";
		$active = "game";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$game_type_list = $this->gameTypeModel->get_data($param);
		//echo '<pre>';print_r($game_type_list);exit;
		return view('admin.game/index', compact('title', 'active', 'breadcumbs', 'game_type_list'));
	}
	public function addGame()
	{
		$title = "Add Game";
		$breadcumbs = "Add Game";
		$active = "game";
		$data = [];
		$category_list = Category::where('is_deleted', 0)->get();
		$type_list = Play_type::get();
		$time_slots = [];
		$thumb = asset('public/images/no_image-150x150.png');
		$days = isset($data->day) ? explode(',', $data->day) : [];
		//$t=date('d-m-Y');
		//date("l",strtotime($t));exit;
		//echo '<pre>';print_r($time_slots);exit;
		return view('admin.game/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list', 'type_list', 'time_slots', 'thumb', 'days'));
	}
	public function editGame($id)
	{
		$title = "Edit Game";
		$breadcumbs = "Edit Game";
		$active = "game";
		$data = $this->gameTypeModel->where('id', $id)->first();
		$category_list = Category::where('is_deleted', 0)->get();
		$type_list = Play_type::get();
		$time_slots = Time_slots::where('category_id', $data->category_id)->get();
		$thumb = isset($data->image) ? Helpers::category_image($data->image) : asset('public/images/no_image-150x150.png');
		$days = isset($data->day) ? explode(',', $data->day) : [];
		//echo '<pre>';print_r($days);exit;
		return view('admin.game/form', compact('title', 'active', 'breadcumbs', 'data', 'category_list', 'type_list', 'time_slots', 'thumb', 'days'));
	}
	public function deleteGame()
	{
		$game_type_id = request()->input('id');
		if ($game_type_id != null) {
			$check = Common::getSingelData($where = ['game_type' => $game_type_id], $table = 'avality_time_date_slots', $data = ['id'], 'id', 'ASC');
			if (!empty($check)) {
				Session::flash('error', 'Can not be deleted as date or time slot are in this game type !');
			} else {
				Common::deleteData('game_type', 'id', $game_type_id);
				Session::flash('success', 'Date slot deleted successfully.');
			}
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function saveGameRequest(Request $request)
	{
		$game_id = $request->input('game_id');
		$category_id = $request->input('category_id');
		$name = $request->input('name');
		$time_slot_id = $request->input('time_slot_id');
		$play_day = $request->input('play_day');
		$minum_coin = $request->input('minum_coin');
		$image = $request->input('image');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'category_id' => 'required|string|max:255',
			//'name.*'			=> "required|string|distinct|min:1",
			//'time_slot_id.*'	=> "required|string|distinct|min:1",
			"play_day.*" => "required|string|distinct|min:1",
			'minum_coin' => 'required|string|max:255',
			'status' => 'required|string|max:255',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			Session::flash('error', $error_html);
			return redirect::back();
		} else {
			$days = implode(',', $play_day);





			if ($game_id != '') {
				$game = Game_type::find($game_id);
				$game->name = $name;
				$game->category_id = $category_id;
				$game->time_slot_id = $time_slot_id;
				$game->day = $days;
				$game->min_bid_amount = $minum_coin;
				$game->image = $image;
				$game->status = $status;
				//echo '<pre>';print_r($game);exit;
				$game->save();
			} else {
				for ($i = 0; count($time_slot_id) > $i; $i++) {
					$game = new Game_type;
					$game->name = $name[$i];
					$game->category_id = $category_id;
					$game->time_slot_id = $time_slot_id[$i];
					$game->day = $days;
					$game->min_bid_amount = $minum_coin;
					$game->image = $image;
					$game->status = $status;
					$game->save();

				}

			}
			Session::flash('success', 'Successfully Saved data.');
		}
		return redirect('administrator/game');
	}
	public function uploadCsvRequest(Request $request)
	{
		$csvMimes = array('text/x-comma-separated-values', 'text/comma-separated-values', 'application/octet-stream', 'application/vnd.ms-excel', 'application/x-csv', 'text/x-csv', 'text/csv', 'application/csv', 'application/excel', 'application/vnd.msexcel', 'text/plain');
		if (!empty($_FILES['upload_csv']['name']) && in_array($_FILES['upload_csv']['type'], $csvMimes)) {
			if (is_uploaded_file($_FILES['upload_csv']['tmp_name'])) {
				$csvFile = fopen($_FILES['upload_csv']['tmp_name'], 'r');
				fgetcsv($csvFile);
				while (($line = fgetcsv($csvFile)) !== FALSE) {
					$category_name = $line[0];
					$category_label = $line[1];
					$game_name = $line[2];
					$start_time = $line[3];
					$end_time = $line[4];
					$days = $line[5];
					$minum_coin = $line[6];
					$type = $line[7];
					$calculation_type = $line[8];
					$calculation_amount = $line[9];
					$status = $line[10];
					if ($category_name != '' && $start_time != '' && $end_time != '') {
						$category_slug = Helpers::create_slug($category_label . '' . $category_name);
						$category_data = Category::where('slug', $category_slug)->first();
						$category_id = isset($category_data->id) ? $category_data->id : '';
						if ($category_id == '') {
							$category = new Category;
							$category->label = $category_label;
							$category->name = $category_name;
							$category->slug = $category_slug;
							$category->save();
							$category_id = $category->id;
						}
						$from_time = date('h:i a', strtotime($start_time));
						$to_time = date('h:i a', strtotime($end_time));
						$from_time_slug = date('H:i', strtotime($start_time));
						$to_time_slug = date('H:i', strtotime($end_time));
						$time = strtotime($to_time);


						if ($category_id == 4) {
							$result_time = date("h:i a", strtotime('+5 minutes', $time));
						} else {
							$result_time = date("h:i a", strtotime('+10 minutes', $time));
						}

						$slot_data = Time_slots::where('category_id', $category_id)->where('from_time_slug', $from_time_slug)->where('to_time_slug', $to_time_slug)->first();
						$slot_id = isset($slot_data->id) ? $slot_data->id : '';
						if ($slot_id == '') {
							$slots = new Time_slots;
							$slots->from_time = $from_time;
							$slots->from_time_slug = $from_time_slug;
							$slots->to_time = $to_time;
							$slots->to_time_slug = $to_time_slug;
							$slots->result_time = $result_time;
							$slots->category_id = $category_id;
							$slots->save();
							$slot_id = $slots->id;
						}

						$type_slug = Helpers::create_slug($type);
						$play_type_data = Play_type::where('slug', $type_slug)->first();
						$play_type_id = isset($play_type_data->id) ? $play_type_data->id : '1';

						$calculation_type = 1;
						if ($calculation_type == 'Percentage') {
							$calculation_type = 2;
						}
						$win_amount = 0;
						if ($calculation_amount != '') {
							$win_amount = $calculation_amount;
						}
						Win_price_calculation::where('category_id', $category_id)->where('play_type', $play_type_id)->where('calculation_type', $calculation_type)->delete();
						$calculation = new Win_price_calculation;
						$calculation->category_id = $category_id;
						$calculation->play_type = $play_type_id;
						$calculation->calculation_type = $calculation_type;
						$calculation->value = $win_amount;
						$calculation->save();
						$calculation_id = $calculation->id;

						$game_data = $this->gameTypeModel->where('category_id', $category_id)->where('time_slot_id', $slot_id)->first();
						$game_id = isset($game_data->id) ? $game_data->id : '';

						$game_status_id = '1';
						if ($status != 'Active') {
							$game_status_id = '0';
						}
						$game_image = '';
						if ($game_id != '') {
							$game = Game_type::find($game_id);
							$game->name = $game_name;
							$game->category_id = $category_id;
							$game->time_slot_id = $slot_id;
							$game->day = $days;
							$game->min_bid_amount = $minum_coin;
							$game->status = $game_status_id;
							$game->save();
						} else {
							$game = new Game_type;
							$game->name = $game_name;
							$game->category_id = $category_id;
							$game->time_slot_id = $slot_id;
							$game->day = $days;
							$game->min_bid_amount = $minum_coin;
							$game->image = $game_image;
							$game->status = $game_status_id;
							$game->save();
							$game_id = $game->id;
						}
					}
				}
			}
		}
		Session::flash('success', 'Successfully import data.');
		return redirect('administrator/game');
	}

	public function delete_game_type_request()
	{
		$game_type_id = request()->input('id');
		if ($game_type_id != null) {
			$check = Common::getSingelData($where = ['game_type' => $game_type_id], $table = 'avality_time_date_slots', $data = ['id'], 'id', 'ASC');
			if (!empty($check)) {
				Session::flash('error', 'Can not be deleted as date or time slot are in this game type !');
			} else {
				Common::deleteData('game_type', 'id', $game_type_id);
				Session::flash('success', 'Date slot deleted successfully.');
			}
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function time_slots()
	{
		$title = "Time Slot";
		$breadcumbs = "Time Slot";
		$active = "time_slots";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$time_slot_list = $this->timeSlotsModel->get_data($param);
		//$result_list = $this->avalityTimeDateSlotsModel->get_time_table();
		//echo '<pre>';print_r($result_list);exit;
		return view('admin.time_slots', compact('title', 'active', 'breadcumbs', 'time_slot_list'));
	}
	public function save_time_slots_request(Request $request)
	{
		$time_slot_id = $request->input('time_slot_id');
		$time_slot = $request->input('time_slot');
		$status = $request->input('status');
		$validator = Validator::make($request->all(), [
			'time_slot' => 'required|string|max:255',
			'status' => 'required|string|max:255'
		]);
		$error_html = '';
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			foreach ($errors as $er) {
				$error_html .= $er;
			}
		} else {
			$time_slot_arr = explode('-', $time_slot);
			$start_time = isset($time_slot_arr[0]) ? trim($time_slot_arr[0]) : '';
			$end_time = isset($time_slot_arr[1]) ? trim($time_slot_arr[1]) : '';
			$check = Common::getSingelData($where = ['from_time' => $start_time, 'to_time' => $end_time], $table = 'time_slots', $data = ['id'], 'id', 'ASC');
			if (!empty($check)) {
				if ($check->id != $time_slot_id) {
					$error_html .= 'Warning: ' . $time_slot . ' already exists!';
				}
			}
		}
		if ($error_html != '') {
			Session::flash('error', $error_html);
		} else {
			if ($time_slot_id != '') {
				$data = array(
					'from_time' => $start_time,
					'to_time' => $end_time,
					'status' => $status,
					'updated_at' => date('Y-m-d H:i:s')
				);
				Common::updateData($table = "time_slots", "id", $time_slot_id, $data);
				Session::flash('success', 'Successfully Updated data.');
			} else {
				$data = array(
					'from_time' => $start_time,
					'to_time' => $end_time,
					'status' => $status,
					'created_at' => date('Y-m-d H:i:s')
				);
				Common::insertData($table = "time_slots", $data);
				Session::flash('success', 'Successfully Insert data.');
			}
		}
		return redirect::back();
	}
	public function delete_time_slots_request()
	{
		$time_slot_id = request()->input('id');
		if ($time_slot_id != null) {
			$check = DB::table('avality_time_date_slots')->whereRaw('FIND_IN_SET(' . $time_slot_id . ',time_id)')->first();
			if (!empty($check)) {
				Session::flash('error', 'Can not be deleted as time slot are in this date slot !');
			} else {
				Common::deleteData('time_slots', 'id', $time_slot_id);
				Session::flash('success', 'Time slot deleted successfully.');
			}
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}

	public function notification_old_test()
	{
		$title = 'Notification';
		$content = 'Notification Testting plz ignor';

		$token = $this->client->getAccessToken();
		$url = 'https://fcm.googleapis.com/v1/projects/ff2-1aae2/messages:send';
		$headers = array(
			'Authorization: Bearer ' . $token['access_token'],
			'Content-Type: application/json'
		);

		$fcm_token_list = User::select('fcm_token')
			->where('fcm_token', '!=', '')
			->whereIn('id', [3, 67])
			->orderBy('id', 'DESC')
			->chunk(300, function ($tokens) use ($title, $content, $url, $headers) {
				foreach ($tokens as $tokenData) {
					$fcmToken = $tokenData->fcm_token;

					$notification = [
						'message' => [
							'token' => $fcmToken,
							'notification' => [
								'title' => strtoupper($title),
								'body' => $content,
							],
							'data' => [
								'title' => strtoupper($title),
								'body' => $content,
								'notification_foreground' => 'true',
								'notification_status' => 'true',
								'show_status' => 'true',
								'head_title' => 'success',
								'is_notification' => 'true',
							]
						]
					];

					$fields = json_encode($notification);
					$ch = curl_init();
					curl_setopt($ch, CURLOPT_URL, $url);
					curl_setopt($ch, CURLOPT_POST, true);
					curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
					curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
					curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

					$result = curl_exec($ch);
					curl_close($ch);

					// echo '<pre>';
					// print_r($result);
					// exit;
				}
			});



	}






	public function notification_4()
	{
		$title = 'GOOD MORNING TO ALL OUR CUSTOMER';
		$content = 'GOOD MORNING TO ALL OUR CUSTOMER';

		$token = $this->client->getAccessToken();
		$url = 'https://fcm.googleapis.com/v1/projects/ffa1-1aae2/messages:send';
		$headers = array(
			'Authorization: Bearer ' . $token['access_token'],
			'Content-Type: application/json'
		);

		$fcm_token_list = User::select('fcm_token')
			->where('fcm_token', '!=', '')
			->whereIn('id', [3, 67])
			->orderBy('id', 'DESC')
			->chunk(10, function ($tokens) use ($title, $content, $url, $headers) {
				$registrationIds = [];
				foreach ($tokens as $tokenData) {
					$registrationIds[] = $tokenData->fcm_token;
				}

				$notification = [
					'registration_ids' => $registrationIds, // up to 500 tokens
					'notification' => [
						'title' => strtoupper($title),
						'body' => $content,
					],
					'data' => [
						'title' => strtoupper($title),
						'body' => $content,
						'notification_foreground' => 'true',
					]
				];

				$fields = json_encode($notification);
				$ch = curl_init();
				curl_setopt($ch, CURLOPT_URL, $url);
				curl_setopt($ch, CURLOPT_POST, true);
				curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
				curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

				$result = curl_exec($ch);
				curl_close($ch);

				echo '<pre>';
				print_r($result);
				exit;
			});






		exit;
		$fcm_token_list = User::select('fcm_token')->where('phone', '7003438796')->orderBy('id', 'DESC')->get()->toArray();
		//echo '<pre>';print_r($fcm_token_list);exit;
		foreach ($fcm_token_list as $tokenData) {
			$deviceToken = $tokenData['fcm_token'];
			$notification = [
				'message' => [
					'token' => $deviceToken,
					'notification' => [
						'title' => strtoupper($title),
						'body' => $content
					],
					'data' => [
						'title' => strtoupper($title),
						'body' => $content,
						'notification_foreground' => 'true',
						'notification_status' => 'true',
						'show_status' => 'true',
						'head_title' => 'success',
						'is_notification' => 'true',
					]
				]
			];

			//echo '<pre>';print_r($headers);exit;

			$fields = json_encode($notification);
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, $url);
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $fields);

			$result = curl_exec($ch);
			curl_close($ch);

			echo '<pre>';
			print_r($result);
			exit;
		}


		// $title 			= "Bid Notifications";
		// $breadcumbs 	= "Bid Notifications";
		// $active 		= "notification";
		// $notification_list 		= Notifications::where('status','N')->offset(0)->limit(1000)->orderBy('id', 'DESC')->get();
		// //echo '<pre>';print_r($notification_list);exit;
		// return view('admin.notification', compact('title','active','breadcumbs','notification_list'));
	}
	public function newsBoard()
	{
		$title = "News Board";
		$breadcumbs = "News Board";
		$active = "news_board";
		$meta_data = array();
		$search = request()->input('s');
		$cur_page = request()->input('pg');
		$cur_page = $cur_page == '' ? 1 : $cur_page;
		$per_page = 20;
		$limit_start = ($cur_page - 1) * $per_page;
		$param = array();
		$param['search'] = $search;
		$param['cur_page'] = $cur_page;
		$param['per_page'] = $per_page;
		$param['limit_start'] = $limit_start;
		$news_list = News_board::get_data($param);

		return view('admin.news_board/index', compact('title', 'active', 'breadcumbs', 'news_list'));
	}
	public function save_news_board_request(Request $request)
	{
		$title = $request->input('title');
		$content = $request->input('content');
		$validator = Validator::make($request->all(), [
			'title' => 'required|string|max:255',
			'content' => 'required|string|max:255',
		]);
		$error_html = '';
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			foreach ($errors as $er) {
				$error_html .= $er;
			}
		} else {
			if ($error_html != '') {
				Session::flash('error', $error_html);
			} else {
				$data = array(
					'title' => $title,
					'content' => $content,
					'created_at' => date('Y-m-d H:i:s')
				);
				Common::insertData($table = "news_board", $data);
				Session::flash('success', 'Successfully Insert data.');

				$notification = AppNotifications::create([
					'title' => $title,
					'message' => $content,
					'type' => 'common',
				]);

				$this->sendNotificationToAll($title, $content);

			}

			return redirect::back();
		}
	}
	public function delete_news_board_request()
	{
		$news_board_id = request()->input('id');
		if ($news_board_id != null) {
			Common::deleteData('news_board', 'id', $news_board_id);
			Session::flash('success', 'Date slot deleted successfully.');
		} else {
			Session::flash('error', 'Something wrong please try again !');
		}
		return redirect::back();
	}
	public function settings()
	{
		$title = "Settings";
		$breadcumbs = "Settings";
		$active = "settings";
		$user_id = Session::get('adminId');
		$data = [];
		$user_id = Session::get('adminId');
		$user_info = Common::getSingelData($where = ['id' => 1], $table = 'users', $data = ['name', 'email'], 'id', 'ASC');
		$data['site_title'] = Common::get_settings($where = ['option_name' => 'site_title']);
		$data['meta_title'] = Common::get_settings($where = ['option_name' => 'meta_title']);
		$data['meta_keywords'] = Common::get_settings($where = ['option_name' => 'meta_keywords']);
		$data['meta_description'] = Common::get_settings($where = ['option_name' => 'meta_description']);
		$data['email'] = Common::get_settings($where = ['option_name' => 'email']);
		$data['whatsapp'] = Common::get_settings($where = ['option_name' => 'whatsapp']);
		$data['phone'] = Common::get_settings($where = ['option_name' => 'phone']);
		$data['app_status'] = Common::get_settings($where = ['option_name' => 'app_status']);
		$data['game_status'] = Common::get_settings($where = ['option_name' => 'game_status']);
		$data['welcome_message'] = Common::get_settings($where = ['option_name' => 'welcome_message']);
		$data['g-play'] = Common::get_settings($where = ['option_name' => 'g-play']);
		$data['withdrawal_status'] = Common::get_settings($where = ['option_name' => 'withdrawal_status']);
		$data['add_balance_message'] = Common::get_settings($where = ['option_name' => 'add_balance_message']);
		$data['balance_request_status'] = Common::get_settings($where = ['option_name' => 'balance_request_status']);
		$data['admin_name'] = $user_info->name;
		$data['admin_email'] = $user_info->email;

		return view('admin.settings_form', compact('title', 'active', 'breadcumbs', 'data'));
	}
	public function saveAdminSettings(Request $request)
	{
		$site_title = $request->input('site_title');
		$meta_title = $request->input('meta_title');
		$meta_keywords = $request->input('meta_keywords');
		$meta_description = $request->input('meta_description');
		$email = $request->input('email');
		$whatsapp = $request->input('whatsapp');
		$phone = $request->input('phone');
		$app_status = $request->input('app_status');
		$game_status = $request->input('game_status');
		$admin_name = $request->input('admin_name');
		$admin_email = $request->input('admin_email');
		$password = $request->input('password');
		$withdrawal_status = $request->input('withdrawal_status');
		$welcome_message = $request->input('welcome_message');
		$add_balance_message = $request->input('add_balance_message');
		$balance_request_status = $request->input('balance_request_status');

		$IP = Helpers::get_ip();
		$validator = Validator::make($request->all(), [
			'site_title' => 'required|string|max:255',
			'email' => 'required|string|email|max:255',
		]);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			$return_data['success'] = 0;
			$return_data['error_message'] = $error_html;
			return response()->json([$return_data]);
		} else {
			$user_id = Session::get('adminId');
			$email_check = Common::getSingelData($where = ['email' => $admin_email], $table = 'users', $data = ['id'], 'id', 'ASC');
			if (!empty($email_check)) {
				if ($email_check->id != $user_id) {
					//$return_data['error_message'] 	= 'Warning: Email already exists!';
					//$return_data['success']			= 0;
					//echo json_encode($return_data);exit;
				}
			}
			$data_general = array(
				'name' => $admin_name,
				//'email'				=> $admin_email,
				'IP' => $IP,
				'updated_at' => date('Y-m-d H:i:s')
			);
		}
		if ($password != '') {
			$data_general['password'] = Hash::make($password);
		}

		Common::updateData($table = "users", "id", $user_id, $data_general);
		Common::updateData($table = "site_settings", "option_name", "site_title", array('option_value' => $site_title));
		Common::updateData($table = "site_settings", "option_name", "meta_title", array('option_value' => $meta_title));
		Common::updateData($table = "site_settings", "option_name", "meta_keywords", array('option_value' => $meta_keywords));
		Common::updateData($table = "site_settings", "option_name", "meta_description", array('option_value' => $meta_description));
		Common::updateData($table = "site_settings", "option_name", "whatsapp", array('option_value' => $whatsapp));
		Common::updateData($table = "site_settings", "option_name", "phone", array('option_value' => $phone));
		Common::updateData($table = "site_settings", "option_name", "app_status", array('option_value' => $app_status));
		Common::updateData($table = "site_settings", "option_name", "game_status", array('option_value' => $game_status));
		Common::updateData($table = "site_settings", "option_name", "welcome_message", array('option_value' => $welcome_message));
		Common::updateData($table = "site_settings", "option_name", "withdrawal_status", array('option_value' => $withdrawal_status));
		Common::updateData($table = "site_settings", "option_name", "add_balance_message", array('option_value' => $add_balance_message));
		Common::updateData($table = "site_settings", "option_name", "balance_request_status", array('option_value' => $balance_request_status));
		Session::flash('success', 'Successfully Saved data.');
		return redirect('administrator/settings/');
	}
	public function uploadImageRequest(Request $request)
	{
		//print_r($_FILES);exit;
		$validator = Validator::make($request->all(), ['upload_photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048']);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			$return_data['success'] = 0;
			$return_data['error_message'] = $error_html;
			return response()->json([$return_data]);
		} else {
			$image_path = '';
			$fileName = '';
			if ($request->hasFile('upload_photo')) {
				$image = $request->file('upload_photo');
				$imageName = $image->getClientOriginalName();
				$fileName = date('His') . time() . '.' . $image->getClientOriginalExtension();
				$directory = public_path('/upload/image/');
				$imageUrlOriginal = $directory . '/' . $fileName;
				$imageUrl = $directory . $fileName;
				$imageUrl400_400 = $directory . '400_400/' . $fileName;
				$imageUrl150_150 = $directory . '150_150/' . $fileName;
				$imageUrl50_50 = $directory . '50_50/' . $fileName;
				$imageUrl360_224 = $directory . '360_224/' . $fileName;
				Image::make($image)->save($imageUrlOriginal);
				Image::make($image)->resize(400, 400)->save($imageUrl400_400);
				Image::make($image)->resize(150, 150)->save($imageUrl150_150);
				Image::make($image)->resize(50, 50)->save($imageUrl50_50);
				Image::make($image)->resize(360, 171)->save($imageUrl360_224);
				$image_path = asset('public/upload/image/400_400/' . $fileName . '?v=' . time());
				$return_data['success'] = 1;
			}
			$return_data['success'] = 1;
			$return_data['file_name'] = $fileName;
			$return_data['image_path'] = $image_path;
			return response()->json([$return_data]);
		}
	}
	public function uploadLogoRequest(Request $request)
	{
		$validator = Validator::make($request->all(), ['upload_photo' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048']);
		if ($validator->fails()) {
			$errors = $validator->errors()->all();
			$error_html = '';
			foreach ($errors as $er) {
				$error_html .= '<span>' . $er . '</span></br>';
			}
			$return_data['success'] = 0;
			$return_data['error_message'] = $error_html;
			return response()->json([$return_data]);
		} else {
			$image_path = '';
			$fileName = '';
			if ($request->hasFile('upload_photo')) {
				$image = $request->file('upload_photo');
				$imageName = $image->getClientOriginalName();
				$fileName = date('His') . time() . '.' . $image->getClientOriginalExtension();
				$directory = public_path('/upload/logo/');
				$imageUrlOriginal = $directory . '/' . $fileName;
				$imageUrl = $directory . $fileName;
				$imageAppLogo = $directory . 'thumb/' . $fileName;
				Image::make($image)->save($imageUrlOriginal);
				Image::make($image)->resize(192, 25)->save($imageAppLogo);
				//Image::make($image)->resize(150, 150)->save($imageUrl150_150);
				$image_path = asset('public/upload/logo/thumb/' . $fileName . '?v=' . time());
				$return_data['success'] = 1;
			}
			$return_data['success'] = 1;
			$return_data['file_name'] = $fileName;
			$return_data['image_path'] = $image_path;
			return response()->json([$return_data]);
		}
	}
	/**
	 * Logout admin.
	 *
	 */
	public function adminlogout()
	{
		\Auth::logout();
		Session::flush();
		return redirect('administrator');
	}
}