<?php

namespace App\Http\Controllers\Auth;

use App\User;

use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Illuminate\Foundation\Auth\RegistersUsers;
use Illuminate\Http\Request;
use Redirect;
use Input;
use Helpers;
use Session;
use App\Common;
use Response;
use DB;
use App\User_wallet as User_wallet;

class RegisterController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Register Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles the registration of new users as well as their
    | validation and creation. By default this controller uses a trait to
    | provide this functionality without requiring any additional code.
    |
    */

    use RegistersUsers;

    /**
     * Where to redirect users after registration.
     *
     * @var string
     */
    protected $redirectTo = '/';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(){
        $this->middleware('checkadminauth')->except('logout');
    }
	
	 public function index(){
        $title 	= 'Registration';
        $active = "registration";
		$userId = Session::get('adminId');
		
		$adminId 	= Session::get('adminId');
		$admin_type = Session::get('admin_type');
		
		if(isset($adminId)){
			if($admin_type==2){
				return redirect('merchant/dashboard');
			}else{
				return redirect('administrator/dashboard');
			}
		}
		
		$countries = Common::listingData($where=[],$table='countries',$data=['*'],'name','ASC');
		return view('auth.register', compact('title','active','countries'));
	}
	
	

    /**
     * Get a validator for an incoming registration request.
     *
     * @param  array  $data
     * @return \Illuminate\Contracts\Validation\Validator
     */
   protected function validator(array $data)
    {
        return Validator::make($data, [
            'name' => 'required|string|max:255',
            'email' => 'required|string|email|max:255|unique:users',
            'password' => 'required|string|min:6|confirmed',
        ]);
    }

    /**
     * Create a new user instance after a valid registration.
     *
     * @param  array  $data
     * @return \App\User
     */
    protected function create(array $data)
    {
		
        return User::create([
            'name' => $data['name'],
            'email' => $data['email'],
            'password' => Hash::make($data['password']),
        ]);
    }
	
	 /**
     * send otp to user email.
     *
     */
    public function sendOtp(Request $request){
		$validator = Validator::make($request->all(), [
		'email' => 'required|string|email|max:255|unique:users'
        ]);
		if($validator->fails()){
			$errors=$validator->errors()->all();
			$error_html='';
			foreach($errors as $er){
				$error_html .='<span>'.$er.'</span></br>';
				}
			   
		   $return_data['success'] = 0; 
		   $return_data['error_message'] = $error_html;
		   return response()->json([$return_data]);
		  }else{
			   $userEmail = Input::post('email');
			   $otp = Helpers::generateOTP();
			   $otpArr = array(
			   'email' => $userEmail,
			   'verification_code' => $otp
			   );
			   Session::put('reg_otp', $otpArr);
			   
			   $subject = 'Email verification Otp';
			   $mailData = [
                    'to' 		=> $userEmail,
                    'subject' 	=> $subject,
                    'from' 		=> 'subha@aqualeafitsol.com',
                    'email' 	=> $userEmail,
                    'otp'		=> $otp,
                    'view' 		=> 'mail_templates/registration_otp_tempalte',
                ];
				
				Helpers::sendSinglemail($mailData);
				//print_r($email_html);
				//print_r($mailData);exit;
			   $return_data['success'] = 1;
			   $return_data['otp'] = $otp;
			   
			return response()->json([$return_data]);
			}
		
		}
		
		
	 /**
     * validate otp and resend otp.
     *
     */
    public function otpValidation(){
        $otp = Input::post('otp');
		$getotpArr=Session::get('reg_otp');
		$verification_code=$getotpArr['verification_code'];
		if(!empty($otp)){
			if($verification_code==$otp){
				$return_data['action']=1;
				}else{
					$return_data['action']=0;
					}
				}else{
					$return_data['action']=0;
					}	
						
       return response()->json([$return_data]);
    }
	
	
	/**
     * Registration process.
     *
     */
	 
    public function createUser(Request $request){
        $validator = Validator::make($request->all(), [
			'fullName' 	=> 'required|string|max:255',
			'dob' 		=> 'required|string|max:255',
			'email' 	=> 'required|string|email|max:255|unique:users',
        	'password' 	=> 'required|min:6|confirmed',
        ]);
		
        if ($validator->fails()){
           $errors=$validator->errors()->all();
		   $error_html='';
		   foreach($errors as $er){
			   $error_html .='<span>'.$er.'</span></br>';
			   }
		   $return_data['success'] = 0; 
		   $return_data['error_message'] = $error_html;
		   return response()->json([$return_data]);
        }else{
			$user_type 			= 2;
			$fullName 			= Input::post('fullName');
			$dob 				= Input::post('dob');
			$gender 			= Input::post('gender');
			$email 				= Input::post('email');
			$phone 				= Input::post('phone');
			$alternet_phone 	= Input::post('alternet_phone');
			$password 			= Input::post('password');
			$country 			= Input::post('country');
			$city 				= Input::post('city');
			
				 
			$IP = Helpers::get_ip();
			
			$userArr = [
				'roll'				=> $user_type,
				'name'				=> $fullName,
				'email'				=> $email,
				'password' 			=> Hash::make($password),
				'dob'				=> $dob,
				'gender'			=> $gender,
				'phone'				=> $phone,
				'alternet_phone'	=> $alternet_phone,
				'country'			=> $country,
				'city'				=> $city,
				'status' 			=> 1,
				'IP'				=> $IP,
				'remember_token' 	=> $request->_token,
				'created_at'		=> date('Y-m-d')
               ];
			   
			 $user = User::create($userArr);
			 $lastInsertedId = $user->id;
			 
			 $userWalletArr = ['user_id' => $lastInsertedId,'balance' => 0];
			 User_wallet::create($userWalletArr);
			 
			 Session::put('adminId', $lastInsertedId);
			 Session::put('admin_type', $user_type);
			 Session::put('admin_email', $email);
			 Session::put('admin_userName', $fullName);
			
 			/*$subject = 'Confirmation of registration email';
			$mailData = [
				'to' 		=> $email,
                'subject' 	=> $subject,
                'uName' 	=> $name,
				'user_verification_link'=>url('/'),
                'view' 		=> 'mail_templates/registration_welcome_template',
              ];
				
			Helpers::sendSinglemail($mailData);*/
			
			$return_data['success'] 		= 1;
			$return_data['success_message'] = '<span>Record is successfully added</span>';
			return response()->json([$return_data]);
		}
			
    }
		
	public function create_test(){
		return response()->json(['name' => 'Abigail','state' => 'CA']);die();
		
		}	
		
	
	
	
}
