<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use App\Http\Requests;
use Illuminate\Support\Facades\Input;
use Redirect;
use Session;
use App\User;
use Auth;
use DB;
use Response;
use Hash;
use App\Common;
use Helpers;

class LoginController extends Controller
{
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */
    protected $redirectTo = '/my-account';

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct(){
        $this->middleware('checkadminauth')->except('logout');
    }
	
	public function index(){
        $title = "Login";
        $active = "Login";
		return view('auth.admin', compact('title','active'));
	}
	
	// Admin Login			
	public function admin(){
		$title	= 'Admin Login';
		$active = "adminlogin";
		
		$adminId 	= Session::get('adminId');
		$admin_type = Session::get('admin_type');
		
		if(isset($adminId)){
			if($adminId == 228){
				return redirect('administrator/balance_request');
			}elseif($adminId == 229){
				return redirect('administrator/withdraw_request');
			}elseif($adminId == 230){
				return redirect('administrator/result/1');
			}else{
				return redirect('administrator/dashboard');
			}
		}
        return view('auth.login', compact('title','active'));
    }
	
	
	public function adminAuthentication(Request $request){
		$data= $request->only('email','password','user_type');
		$remember = $request->get('remember');
		if(!empty($remember)){
			setcookie ("email",$request->email,time()+ (60 * 2));
			setcookie ("password",$request->password,time()+ (60 * 2));
		}else {
			if(isset($_COOKIE["email"])) {
				setcookie ("email","");
			}
			if(isset($_COOKIE["password"])) {
				setcookie ("password","");
			}
		}
		
        if(Auth::attempt($data,$remember)){
			$user = User::where([['email', '=', $data['email']],['user_type', '=', '1']])->first();
        	$userId = $user->id;
        	$userType = $user->user_type;
        	$userEmail = $user->email;
        	$userName = $user->name;
			
			if($userType == 1){
				Session::put('adminId', $userId);
				Session::put('admin_type', $userType);
				Session::put('admin_email', $userEmail);
				Session::put('admin_userName', $userName);
				if($userId == 228){
					return redirect('administrator/balance_request');

				}elseif($userId == 229){
					return redirect('administrator/withdraw_request');
					
				}elseif($userId == 230){
					return redirect('administrator/result/1');
				}else{
					return redirect('administrator/dashboard');
				}

				
			}else{
				return back()->withInput()->withErrors(['error'=>'Email or password is invalid!']);
			}
		}else{
			return back()->withInput()->withErrors(['error'=>'Email or password is invalid!']);
			}
		}
		
}