<?php
namespace App\Http\Controllers\API;

use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Input;
use Image;
use DB;
use Helpers;
use App\User;
use App\Common;
use App\Time_slots;
use App\Win_period;
use App\Category;
use App\Transactions;
use App\Balance_request;
use App\Withdraw_request;
use App\User_wallet;
use App\User_bank;
use App\Cp_digits;
use App\User_bit_transaction;
use App\Avality_time_date_slots;
use App\User_bit_cp_transaction;
use Config;


class ResultController extends Controller
{
	protected $userBitTransactionModel;
	protected $winPeriodModel;
	protected $userTransactionsModel;
	protected $balanceRequestModel;
	protected $withdrawRequestModel;
	protected $userWalletModel;
	protected $userBankModel;
	protected $avalityTimeDateSlotsModel;
	
	public function __construct(){
		$this->userBitTransactionModel	= new User_bit_transaction;
		$this->winPeriodModel			= new Win_period;
		$this->userTransactionsModel	= new Transactions;
		$this->balanceRequestModel		= new Balance_request;
		$this->withdrawRequestModel 	= new Withdraw_request;
		$this->userWalletModel 			= new User_wallet;
		$this->userBankModel 			= new User_bank;
		$this->avalityTimeDateSlotsModel= new Avality_time_date_slots;
    }
	
	public function test_notification(){
		$customer_id		= Input::get('customer_id');
		
		if($customer_id!=''){
			$SERVER_API_KEY = Config::get('notification.SERVER_API_KEY');
			$token_list = User::whereNotNull('device_token')->where('id',$customer_id)->get()->toArray();
			
			$msg = array(
				'body'  => 'Tap to refresh.',
				'title' => strtoupper('Refresh successfully')
			);
			$data = $msg;
            $data['notification_foreground'] = true;
			$data['priceRefresh'] = 1;
			$fields = array(
				'registration_ids'  => array_column($token_list,'device_token'),
				'notification'      => $msg,
				'data'				=> $data
			);
			$dataString = json_encode($fields);
			
			$headers = [
				'Authorization: key=' . $SERVER_API_KEY,
				'Content-Type: application/json',
			];
			$ch = curl_init();
			curl_setopt($ch, CURLOPT_URL, 'https://fcm.googleapis.com/fcm/send');
			curl_setopt($ch, CURLOPT_POST, true);
			curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
			curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
			curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
			curl_setopt($ch, CURLOPT_POSTFIELDS, $dataString);
			$response = curl_exec($ch);
			
			print_r($response);exit;
		}
		
	}
	
	public function getTestList(){
		$cat_id		= Input::get('category_id');
		$play_type	= Input::get('play_type');
		$play_type_id	= 1;
		if(isset($play_type)){
			if($play_type!=''){
				$play_type_id	= $play_type;
			}
		}
		
		$result_dates	= [];
		
		$current_date 	= date('Y-m-d');
		for($i=0;7>$i;$i++){
			$result_dates[]=date('Y-m-d', strtotime($current_date .' - '.$i.' day'));
		}
		//$result_dates[]='2022-01-18';
		
		
		
		$result=[];
		if($play_type_id==1){
			foreach($result_dates as $c_date){
			$win_single_period_result	= Win_period::select('win_number')->where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',1)->get();
			//echo '<pre>';print_r($win_single_period_result);exit;
			$win_patti_period_result	= Win_period::where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',2)->get();
			
			$slotWiseResult=[];
			for($i=0;8>$i;$i++){
				$single_win	= isset($win_single_period_result[$i]->win_number)?$win_single_period_result[$i]->win_number:'-';
				$patti_win	= isset($win_patti_period_result[$i]->win_number)?$win_patti_period_result[$i]->win_number:'-';
				$slotWiseResult[]=array(
					'single_win'	=> $single_win,
					'patti_win'		=> $patti_win
				);
			}
			
			$result[]=array(
				'date'		=> $c_date,
				'result'	=> $slotWiseResult
			);
			
			//echo '<pre>';print_r($result);exit;
		}
			$html='';
			foreach($result as $row){
				$html .='<div class="reasultBox"><div class="secTitle w-100"><h5>'.$row['date'].'</h5></div>';
				$html .='<div class="reasultBoxInner" ><ul class="row">';
				foreach($row['result'] as $r_slot){
					$html .='<li><span>';
					$html .='<strong class="single">'.$r_slot['single_win'].'</strong>';
					$html .='<p class="patti">'.$r_slot['patti_win'].'</p>';
					$html .='</span></li>';
				}
				$html .='</ul></div></div>';
			}
		}else{
			foreach($result_dates as $c_date){
			$win_jodi_period_result	= Win_period::select('win_number')->where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',3)->get();
			
			$slotWiseResult=[];
			$slotWiseResult[]=['jodi_win'=>'-'];
			for($i=0;7>$i;$i++){
				$jodi_win	= isset($win_jodi_period_result[$i]->win_number)?$win_jodi_period_result[$i]->win_number:'-';
				$slotWiseResult[]=array(
					'jodi_win'	=> $jodi_win
				);
			}
			
			$result[]=array(
				'date'		=> $c_date,
				'result'	=> $slotWiseResult
			);
			
			//echo '<pre>';print_r($result);exit;
		}
			$html='';
			foreach($result as $row){
				$html .='<div class="reasultBox"><div class="secTitle w-100"><h5>'.$row['date'].'</h5></div>';
				$html .='<div class="reasultBoxInner" ><ul class="row">';
				foreach($row['result'] as $r_slot){
					$html .='<li><span>';
					$html .='<strong class="single">'.$r_slot['jodi_win'].'</strong>';
					
					$html .='</span></li>';
				}
				$html .='</ul></div></div>';
			}
		}
		$result = array(
			'statusCode'	=> '200',
			'result'		=> [],
			'html'			=> $html,
			'message'		=> 'Success'
		);
		
		return response()->json($result);
	}
	public function getTestList_1(){
		$cat_id		= Input::get('category_id');
		$play_type	= Input::get('play_type');
		$play_type_id	= 1;
		if(isset($play_type)){
			if($play_type!=''){
				$play_type_id	= $play_type;
			}
		}
		
		$result_dates	= [];
		
		$current_date 	= date('Y-m-d');
		for($i=0;7>$i;$i++){
			$result_dates[]=date('Y-m-d', strtotime($current_date .' - '.$i.' day'));
		}
		//$result_dates[]='2022-01-18';
		
		
		
		$result=[];
		if($play_type_id==1){
			foreach($result_dates as $c_date){
			$win_single_period_result	= Win_period::select('win_number')->where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',1)->get();
			//echo '<pre>';print_r($win_single_period_result);exit;
			$win_patti_period_result	= Win_period::where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',2)->get();
			
			$slotWiseResult=[];
			
			for($i=0;8>$i;$i++){
				$single_win	= isset($win_single_period_result[$i]->win_number)?$win_single_period_result[$i]->win_number:'-';
				$patti_win	= isset($win_patti_period_result[$i]->win_number)?$win_patti_period_result[$i]->win_number:'-';
				$slotWiseResult[]=array(
					'single_win'	=> $single_win,
					'patti_win'		=> $patti_win
				);
			}
			
			$result[]=array(
				'date'		=> $c_date,
				'result'	=> $slotWiseResult
			);
			
			//echo '<pre>';print_r($result);exit;
		}
			$html='';
			foreach($result as $row){
				$html .='<div class="reasultBox"><div class="secTitle w-100"><h5>'.$row['date'].'</h5></div>';
				$html .='<div class="reasultBoxInner" ><ul class="row">';
				foreach($row['result'] as $r_slot){
					$html .='<li><span>';
					$html .='<strong class="single">'.$r_slot['single_win'].'</strong>';
					$html .='<p class="patti">'.$r_slot['patti_win'].'</p>';
					$html .='</span></li>';
				}
				$html .='</ul></div></div>';
			}
		}else{
			foreach($result_dates as $c_date){
			$win_jodi_period_result	= Win_period::select('win_number')->where('date_slot',$c_date)->where('category_id',$cat_id)->where('play_type',3)->get();
			
			$slotWiseResult=[];
			$slotWiseResult[]=['jodi_win'=>'-'];
			for($i=0;7>$i;$i++){
				$jodi_win	= isset($win_jodi_period_result[$i]->win_number)?$win_jodi_period_result[$i]->win_number:'-';
				$slotWiseResult[]=array(
					'jodi_win'	=> $jodi_win
				);
			}
			
			$result[]=array(
				'date'		=> $c_date,
				'result'	=> $slotWiseResult
			);
			
			//echo '<pre>';print_r($result);exit;
		}
			$html='';
			foreach($result as $row){
				$html .='<div class="reasultBox"><div class="secTitle w-100"><h5>'.$row['date'].'</h5></div>';
				$html .='<div class="reasultBoxInner" ><ul class="row">';
				foreach($row['result'] as $r_slot){
					$html .='<li><span>';
					$html .='<strong class="single">'.$r_slot['jodi_win'].'</strong>';
					
					$html .='</span></li>';
				}
				$html .='</ul></div></div>';
			}
		}
		
		
		
		
		
		
		
		
		
		
		
		
		
		echo '<pre>';print_r($html);exit;
		
		
		exit;
		
		$play_type_result	= DB::table('play_type')->where('status',1)->get();
		$slot_result		= DB::table('time_slots')->where('category_id',$cat_id)->get();
		
		$current_date 	= date('Y-m-d');
		for($i=0;25>$i;$i++){
			$result_dates[]=date('Y-m-d', strtotime($current_date .' - '.$i.' day'));
		}
		
		$result=[];
		foreach($result_dates as $c_date){
			$category_info 	= Category::where('id',$cat_id)->first();
			$category_name 	= isset($category_info->name)?$category_info->name:'';
			
			$slotWiseResult=[];
			foreach($slot_result as $slot_row){
				$slotWiseTypeResult=[];
				foreach($play_type_result as $row){
					$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
					$game_id 	= isset($game_info->id)?$game_info->id:'';
					$period_id		= Helpers::getPeriod($c_date,$cat_id,$slot_row->id,$game_id,$row->id);
					$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
					$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'-';
					$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
					
					$slotWiseTypeResult[]=array(
						'type_id'		=> $row->id,
						'type_name'		=> $row->name,
						'type_slug'		=> $row->slug,
						'win_number'	=> $win_number,
					);
				}
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'betResult'		=> $slotWiseTypeResult
				);
			}
			
			$result[]=array(
				'date'		=> $c_date,
				'result'	=> $slotWiseResult
			);
		}
		
		$html='';
		foreach($result as $row){
			$html .='<div class="reasultBox"><div class="secTitle w-100"><h5>'.$row['date'].'</h5></div>';
			$html .='<div class="reasultBoxInner" ><ul class="row">';
			foreach($row['result'] as $r_slot){
				$html .='<li title="'.$r_slot['from_time'].'-'.$r_slot['to_time'].'"><span>';
				foreach($r_slot['betResult'] as $r_bet){
					if($r_bet['type_slug']=='single'){
						$html .='<strong class="'.$r_bet['type_slug'].'">'.$r_bet['win_number'].'</strong>';
					}else{
						$html .='<p class="'.$r_bet['type_slug'].'">'.$r_bet['win_number'].'</p>';
					}
				}
				$html .='</span></li>';
			}
			$html .='</ul></div></div>';
		}
		
		$result = array(
			'statusCode'	=> '200',
			'result'		=> $result,
			'html'			=> $html,
			'message'		=> 'Success'
		);
		
		return response()->json($result);
	}
	
	

	public function fflivebethistory(){
		$game_id	= Input::get('game_id');
		$date_slot	= Input::get('date_slot');
		$time_slot	= Input::get('time_slot');
		
		$param 					= array();
		
		$param['game_id'] 		= $game_id;
        $param['date_slot'] 	= $date_slot;
		$param['time_slot'] 	= $time_slot;
		$category_info 			= Category::where('id',$game_id)->first();
		$category_name 			= isset($category_info->name)?$category_info->name:'';
		
		$result 				= $this->userBitTransactionModel->getffliveHistoryResult($param);
		$result_history	= [];
		$i=0;
		foreach($result['records'] as $row){
			$play_type='Single';
			if($row->play_type==2){
				$play_type='Patti';
			}elseif($row->play_type==3){
				$play_type='Jodi';
			}
			$result_history[]=array(
				'id'						=> $row->id,
				'title'						=> $row->name,
				'customer_name'				=> $row->customer_name,
				'customer_phone'			=> $row->phone,
				'digit'						=> $row->number,
				'amount'					=> $row->amount,
				'type'						=> $play_type,
				'status'					=> $row->win_status,
				'date'						=> date('Y-m-d',strtotime($row->created_at)),
				'time'						=> date('h:i a',strtotime($row->created_at))
			);
			
		$i++;
		}
		
		$return = array(
			'statusCode'	=> '200',
			'game_title'	=> $category_name,
			'date'			=> $date_slot,
			'result'		=> $result_history,
			'message'		=> 'Success'
		);
		
		//echo '<pre>';print_r($return);exit;
		
		return response()->json($return);
	}
	public function ffliveresulthistory(){
		$cat_id		= Input::get('game_id');
		
		$result_dates	= [];
		
		$play_type_result	= DB::table('play_type')->whereIn('id', array('1','2','3'))->where('status',1)->get();
		
		//echo '<pre>';print_r($play_type_result);exit;
		
		$slot_result		= DB::table('time_slots')->where('category_id',$cat_id)->get();
		
		$current_date 	= date('Y-m-d');
		for($i=0;25>$i;$i++){
			$result_dates[]=date('Y-m-d', strtotime($current_date .' - '.$i.' day'));
		}
		
		$result=[];
		foreach($result_dates as $c_date){
			$category_info 	= Category::where('id',$cat_id)->first();
			$category_name 	= isset($category_info->name)?$category_info->name:'';
			
			$slotWiseResult=[];
			$i=0;
			foreach($slot_result as $slot_row){
				$slotWiseTypeResult=[];
				foreach($play_type_result as $row){
					$game_info	= DB::table('game_type')->where('category_id',$cat_id)->where('time_slot_id',$slot_row->id)->first();
					$game_id 		= isset($game_info->id)?$game_info->id:'';
					
					if($row->id==3){
						$win_number='-';
						if($i!=0){
							$current_slot_number	= $slot_row->id;
							$prev_slot_number 		= DB::table('time_slots')->where('id', '<', $current_slot_number)->max('id');
							$current_game_id		= $game_id;
							$prev_game_id			= DB::table('game_type')->where('id', '<', $current_game_id)->max('id');
							
							
							
							$period_id		= Helpers::getPeriod($c_date,$cat_id,$prev_slot_number,$prev_game_id,$row->id);
							$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
							$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'-';
							$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
						}
					}else{
						$period_id		= Helpers::getPeriod($c_date,$cat_id,$slot_row->id,$game_id,$row->id);
						$setResultInfo	= DB::table('win_period')->where('is_active','Y')->where('period',$period_id)->first();
						$win_number		= isset($setResultInfo->win_number)?$setResultInfo->win_number:'-';
						$win_status		= isset($setResultInfo->is_active)?$setResultInfo->is_active:'N';
					}
					
					$slotWiseTypeResult[]=array(
						'type_id'		=> $row->id,
						'type_name'		=> $row->name,
						//'type_slug'		=> $row->slug,
						'win_number'	=> $win_number,
					);
				}
				
				$slotWiseResult[]=array(
					'id'			=> $slot_row->id,
					'from_time'		=> $slot_row->from_time,
					'to_time'		=> $slot_row->to_time,
					'slotResult'	=> $slotWiseTypeResult
				);
			$i++;}
			
			$result[]=array(
				'date'		=> $c_date,
				'winResult'	=> $slotWiseResult
			);
		}
		
		//echo '<pre>';print_r($result);exit;
		
		$result = array(
			'statusCode'	=> '200',
			'result'		=> $result,
			'message'		=> 'Success'
		);
		
		return response()->json($result);
	}
	public function fflivecurrentresulthistory(){
		$cat_id				= Input::get('game_id');
		$game_status 		= Common::get_settings($where=['option_name'=>'game_status']);
		
		$play_type_result	= DB::table('play_type')->whereIn('id', array('1','2','3'))->where('status',1)->get();
		
		$result_list 		= Category::where('id',$cat_id)->where('status',1)->orderBy('id','ASC')->get();
		$result=[];
		
		$singleBidResult	= [];
		$totalSingleAmount	= 0;
						
		$pattiBidResult		= [];
		$totalPattiAmount	= 0;
						
		$jodiBidResult		= [];
		$totalJodiAmount	= 0;
						
		$cpBidResult		= [];
		$totalCpAmount		= 0;
		
		if($game_status!='off'){
			if(count($result_list)>0){
				$current_date	= date('Y-m-d');
				$current_day	= date("l",strtotime($current_date));
				$current_time	= date('H:i');
				$avalityTimeSlotResult	= Time_slots::where('category_id', $cat_id)->where('from_time_slug', '<=', $current_time)->where('to_time_slug', '>=', $current_time)->where('status',1)->first();
				//echo '<pre>';print_r($avalityTimeSlotResult);exit;
				$slot_id	= isset($avalityTimeSlotResult->id)?$avalityTimeSlotResult->id:'';
				if($slot_id!=''){
					$distinct_single_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->get();
					foreach($distinct_single_bid_numbers as $row){
						$single_bid_amount = DB::table('user_bit_transaction')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
						$single_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 1)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
						$totalSingleAmount+= $single_bid_amount;
						$singleBidResult[]=array(
							'digit'=>$row->number,
							'totalBid'=>$single_bid_count,
							'amount'=>$single_bid_amount
						);
					}
					
					$distinct_patti_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->get();
					foreach($distinct_patti_bid_numbers as $row){
						$patti_bid_amount = DB::table('user_bit_transaction')->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
						$patti_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 2)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
						$totalPattiAmount+= $patti_bid_amount;
						$pattiBidResult[]=array(
							'digit'=>$row->number,
							'totalBid'=>$patti_bid_count,
							'amount'=>$patti_bid_amount
						);
					}
					
					$distinct_jodi_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->get();
					foreach($distinct_jodi_bid_numbers as $row){
						$jodi_bid_amount = DB::table('user_bit_transaction')->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
						$jodi_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 3)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
						$totalJodiAmount+= $jodi_bid_amount;
						$jodiBidResult[]=array(
							'digit'=>$row->number,
							'totalBid'=>$jodi_bid_count,
							'amount'=>$jodi_bid_amount
						);
					}
					
					$distinct_cp_bid_numbers = DB::table('user_bit_transaction')->select('number')->distinct()->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->get();
					foreach($distinct_cp_bid_numbers as $row){
						$cp_bid_amount = DB::table('user_bit_transaction')->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->sum('amount');
						$cp_bid_count = DB::table('user_bit_transaction')->select('number')->where('play_type', 4)->where('date_slot', $current_date)->where('time_slot_id', $slot_id)->where('number', $row->number)->count();
						$totalCpAmount+= $cp_bid_amount;
						$cpBidResult[]=array(
							'digit'		=> $row->number,
							'totalBid'	=> $cp_bid_count,
							'amount'	=> $cp_bid_amount
						);
					}
					
					$result = array(
						'statusCode'	=> '200',
						'singleResult'	=> $singleBidResult,
						'pattiResult'	=> $pattiBidResult,
						'jodiResult'	=> $jodiBidResult,
						'cpResult'		=> $cpBidResult,
						'message'		=> 'Success',
					);
					
				}
			}else{
				$result = array(
					'statusCode'	=> '404',
					'message'		=> 'Error',
				);
			}
			
		}else{
			$result = array(
				'statusCode'	=> '404',
				'message'		=> 'Error',
			);
		}
				
		return response()->json($result);
	}

}
