<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;

class Game_type extends Model
{
    protected $table = 'game_type';
	protected $guarded	= [];
	
	public function getCategory() {
        return $this->hasOne('App\Category', 'id', 'category_id');
    }
	public function getTimeslots() {
        return $this->hasOne('App\Time_slots', 'id', 'time_slot_id');
    }
	
	public static function get_data($param = array()) {
		$return			= array();
		
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$total_records = DB::table('game_type');
        if($search != '') {
            $total_records = $total_records->where(function($total_records) use ($search) {
                $total_records->where(DB::raw("name"), 'LIKE', '%' . $search . '%');
            });
        }
		
		$total_records = $total_records->count();
		
		$records = DB::table('game_type')->select('game_type.*','category.name as category','time_slots.from_time','time_slots.to_time')->join('category','category.id','=','game_type.category_id')->join('time_slots','time_slots.id','=','game_type.time_slot_id')->where('category.is_deleted',0);
		if($search != '') {
            $records = $records->where(function($records) use ($search) {
				$records->where(DB::raw("name"), 'LIKE', '%' . $search . '%');
            });
        }
		//->offset($limit_start)->limit($per_page)
		$records = $records->orderby('category.sort', 'ASC')->get();
		$return['records'] = $records;
		$return['total_records'] = $total_records;
		return $return;
	}
}
