<?php

namespace App;

use Illuminate\Support\Facades\DB AS DB;
use Illuminate\Database\Eloquent\Model;
use App\Time_slots;
use Illuminate\Database\Eloquent\Relations\BelongsTo;

class Avality_time_date_slots extends Model
{
    protected $table = 'avality_time_date_slots';
	protected $fillable = ['slot_unic_id','date','time_id','game_type','status','additional_massage','created_at'];
	
	public function get_slot($param = array()){
		$return  = array();
		
		$search 		= $param['search'];
        $cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
		
		$slot_info = DB::table('avality_time_date_slots')
                 	->select('slot_unic_id', DB::raw('count(*) as total'))
                 	->groupBy('slot_unic_id')
                 	->get();
					
		$data=[];
		foreach($slot_info as $row){
			$slot_start_date_info 	= DB::table('avality_time_date_slots')->where('slot_unic_id', $row->slot_unic_id)->select('date')->orderBy('date', 'ASC')->first();
			$slot_end_date_info 	= DB::table('avality_time_date_slots')->where('slot_unic_id', $row->slot_unic_id)->select('date')->orderBy('date', 'DESC')->first();
			$start_date	= isset($slot_start_date_info->date)?date('Y/m/d',strtotime($slot_start_date_info->date)):'';
			$end_date	= isset($slot_end_date_info->date)?date('Y/m/d',strtotime($slot_end_date_info->date)):'';
			
			$slot_status_info = DB::table('avality_time_date_slots_status')->where('slot_unic_id', $row->slot_unic_id)->select('status')->first();
			$status	= isset($slot_status_info->status)?$slot_status_info->status:'';
			
			//echo '<pre>';print_r($slot_start_date_info);exit;
			
			$data[]=array(
				'slot_unic_id'	=> $row->slot_unic_id,
				'slot'			=> $start_date.' - '.$end_date,
				'total'			=> $row->total,
				'status'		=> $status,
			);
			
		}
		
		//echo '<pre>';print_r($data);exit;
		
		$return['records'] = $data;
        $return['total_records'] = count($data);
        return $return;
	}
	
	public static function get_date_slot($param = array()) {
		$return  = array();
		
		$slot_unic_id 	= $param['slot_unic_id'];
		$type 			= $param['type'];
		$search 		= $param['search'];
		$cur_page 		= $param['cur_page'];
        $per_page 		= $param['per_page'];
        $limit_start 	= $param['limit_start'];
        
        $total_slot_date = DB::table('avality_time_date_slots')->where('slot_unic_id',$slot_unic_id)->where('game_type',$type);
        if($search != '') {
            $total_slot_date = $total_slot_date->where(function($total_slot_date) use ($search) {
                $total_slot_date->where(DB::raw("date"), 'LIKE', '%' . $search . '%');
            });
        }
        $total_slot_date = $total_slot_date->count();
		
		$slot_date = DB::table('avality_time_date_slots')->select('avality_time_date_slots.*','game_type.name as type')->leftJoin('game_type', 'game_type.id', 'avality_time_date_slots.game_type')->where('slot_unic_id',$slot_unic_id)->where('game_type',$type);
		if($search != '') {
            $slot_date = $orders->where(function($slot_date) use ($search) {
                $slot_date->where(DB::raw("date"), 'LIKE', '%' . $search . '%');
            });
        }
		$slot_date = $slot_date->orderby('date', 'DESC')->get();
		$return['records'] = $slot_date;
		$return['total_records'] = $total_slot_date;
		return $return;
	}

	public static function get_time_table() {
		$return  = array();
		
		$avality_game_type_result	= DB::table('game_type')->where('status',1)->get();

		$result=[];
		foreach($avality_game_type_result as $row){
			$time_slot_list=[];
			$avality_time_slot_result	= DB::table('time_slots')->where('game_type_id',$row->id)->where('status',1)->get();
			foreach($avality_time_slot_result as $time){
				$time_slot_list[]=array(
					'last_play_time'	=> $time->from_time.'-'.$time->to_time,
					'result_time'		=> $time->result_time
				);
			}
			
			$result[]=array(
				'game_title'=>strtoupper($row->name),
				'time_slot_ids'=>$time_slot_list
			);
		}
		
		return $result;
	}
	
	public function timeDetails(){
		return $this->belongsTo(Time_slots::class, 'time_id');
	}
}
